
/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */


/* ---------------------------------------------------------------------------
 * This is the Notify Action that is included in the compilation of action.c
 *
 * does what's appropriate for the current mode setting. This normaly
 * means creation of an object at the current crosshair location.
 *
 * new created objects are added to the create undo list of course
 */
static void NotifyMode(void)
{
	void	*ptr1,
			*ptr2,
			*ptr3;
	int		type;

	if (Settings.RatWarn)
		ClearWarnings();
	switch(Settings.Mode)
	{
		case VIA_MODE:
		{
			PinTypePtr	via;

			if (!PCB->ViaOn)
			{
				Message("You must turn via visibility on before\n"
					"you can place vias\n");
				break;
			}
			if ((via = CreateNewVia(PCB->Data, Crosshair.X, Crosshair.Y,
					Settings.ViaThickness, Settings.ViaDrillingHole,
					NULL, VIAFLAG)) != NULL)
			{
				UpdatePIPFlags(via, (ElementTypePtr) via, NULL, False);
				AddObjectToCreateUndoList(VIA_TYPE, via, via, via);
				IncrementUndoSerialNumber();
				DrawVia(via, 0);
				Draw();
				SetChangedFlag(True);
			}
			break;
		}

		case ARC_MODE:
		{
			switch(Crosshair.AttachedBox.State)
			{
				case STATE_FIRST:
					Crosshair.AttachedBox.Point1.X =
						Crosshair.AttachedBox.Point2.X = Crosshair.X;
					Crosshair.AttachedBox.Point1.Y =
						Crosshair.AttachedBox.Point2.Y = Crosshair.Y;
					Crosshair.AttachedBox.State = STATE_SECOND;
					break;

				case STATE_SECOND:
				case STATE_THIRD:
				{
					ArcTypePtr arc;
					int wx, wy, sa, dir;

					wx = Crosshair.X - Crosshair.AttachedBox.Point1.X;
					wy = Crosshair.Y - Crosshair.AttachedBox.Point1.Y;
					if (abs(wy) > abs(wx))
					{
						Crosshair.AttachedBox.Point2.X = Crosshair.AttachedBox.Point1.X
							+ abs(wy)*SGN(wx);
						sa = (wx >= 0) ? 0 : 180;
#ifdef ARC45
						if (abs(wy) >= 2*abs(wx))
							dir = (SGN(wx) == SGN(wy)) ? 45 : -45;
						else
#endif
							dir = (SGN(wx) == SGN(wy)) ? 90 : -90;
					}
					else
					{
						Crosshair.AttachedBox.Point2.Y = Crosshair.AttachedBox.Point1.Y
							+ abs(wx)*SGN(wy);
						sa = (wy >= 0) ? -90 : 90;
#ifdef ARC45
						if (abs(wx) >= 2*abs(wy))
							dir = (SGN(wx) == SGN(wy)) ? -45 : 45;
						else
#endif
							dir = (SGN(wx) == SGN(wy)) ? -90 : 90;
						wy = wx;
					}
					if (abs(wy) > 0 && (arc = CreateNewArcOnLayer(CURRENT,
						Crosshair.AttachedBox.Point2.X,
						Crosshair.AttachedBox.Point2.Y, abs(wy), sa, dir,
						Settings.LineThickness, NOFLAG)))
					{
						BoxTypePtr	bx;

						bx = GetArcEnds(arc);
						Crosshair.AttachedBox.Point1.X = 
						Crosshair.AttachedBox.Point2.X = bx->X2;
						Crosshair.AttachedBox.Point1.Y =
						Crosshair.AttachedBox.Point2.Y = bx->Y2;
						AddObjectToCreateUndoList(ARC_TYPE, CURRENT, arc, arc);
						IncrementUndoSerialNumber();
						addedLines++;
						DrawArc(CURRENT, arc, 0);
						SetChangedFlag(True);
						Draw();
						Crosshair.AttachedBox.State = STATE_THIRD;
					}
					break;
				}
			}
			break;
		}
		case THERMAL_MODE:
		{
			int	LayerThermFlag;
			int	LayerPIPFlag = L0PIPFLAG << INDEXOFCURRENT;

			if (((type = SearchObjectByPosition(PIN_TYPES,&ptr1,&ptr2,&ptr3,
			    Crosshair.X, Crosshair.Y, TO_PCB(1))) != NO_TYPE) &&
			    TEST_FLAG(LayerPIPFlag, (PinTypePtr) ptr3) &&
			    !TEST_FLAG(HOLEFLAG, (PinTypePtr) ptr3))
			{
				AddObjectToFlagUndoList(type, ptr1, ptr2, ptr3);
				LayerThermFlag = L0THERMFLAG << INDEXOFCURRENT;
				TOGGLE_FLAG(LayerThermFlag,(PinTypePtr) ptr3);
				IncrementUndoSerialNumber();
				ClearPin((PinTypePtr) ptr3, type, 0);
				SetChangedFlag(True);
				Draw();
			}
			break;
		}

		case LINE_MODE:
				/* do update of position */
			NotifyLine();

				/* create line if both ends are determined && length != 0 */
			if (Crosshair.AttachedLine.State == STATE_THIRD)
			{
				LineTypePtr	line;

				if ((Crosshair.AttachedLine.Point1.X != Crosshair.AttachedLine.Point2.X
				    || Crosshair.AttachedLine.Point1.Y != Crosshair.AttachedLine.Point2.Y)
				    && (line = CreateNewLineOnLayer(CURRENT,
						Crosshair.AttachedLine.Point1.X,
						Crosshair.AttachedLine.Point1.Y,
						Crosshair.AttachedLine.Point2.X,
						Crosshair.AttachedLine.Point2.Y,
						Settings.LineThickness, NOFLAG)) != NULL)
				{
					PinTypePtr	via;

					addedLines++;
					AddObjectToCreateUndoList(LINE_TYPE, CURRENT, line, line);
					DrawLine(CURRENT, line, 0);
					SetChangedFlag(True);
						/* place a via if vias are visible, the layer is
						   in a new group since the last line and there
						   isn't a pin already here */
					if (PCB->ViaOn && GetLayerGroupNumberByPointer(CURRENT) !=
						GetLayerGroupNumberByPointer(lastLayer) &&
						SearchObjectByPosition(PIN_TYPES, &ptr1, &ptr2, &ptr3,
							Crosshair.AttachedLine.Point1.X,
							Crosshair.AttachedLine.Point1.Y,
							Settings.ViaThickness/2) == NO_TYPE &&  
						(via = CreateNewVia(PCB->Data, Crosshair.AttachedLine.Point1.X,
						Crosshair.AttachedLine.Point1.Y, Settings.ViaThickness,
						Settings.ViaDrillingHole, NULL, VIAFLAG)) != NULL)
					{
						UpdatePIPFlags(via, (ElementTypePtr) via, NULL, False);
						AddObjectToCreateUndoList(VIA_TYPE, via, via, via);
						DrawVia(via, 0);
					}
						/* copy the coordinates */
					Crosshair.AttachedLine.Point1.X=Crosshair.AttachedLine.Point2.X;
					Crosshair.AttachedLine.Point1.Y=Crosshair.AttachedLine.Point2.Y;
					IncrementUndoSerialNumber();
					lastLayer = CURRENT;
				}
				if (PCB->Clipping && (Crosshair.X != Crosshair.AttachedLine.Point2.X
					|| Crosshair.Y != Crosshair.AttachedLine.Point2.Y) &&
					(line = CreateNewLineOnLayer(CURRENT,
						Crosshair.AttachedLine.Point2.X,
						Crosshair.AttachedLine.Point2.Y,
						Crosshair.X, Crosshair.Y,
						Settings.LineThickness, NOFLAG)) != NULL)
				{
					addedLines++;
					AddObjectToCreateUndoList(LINE_TYPE, CURRENT, line, line);
					IncrementUndoSerialNumber();
					DrawLine(CURRENT, line, 0);
					SetChangedFlag(True);
						/* move to new start point */
					Crosshair.AttachedLine.Point1.X = Crosshair.X;
					Crosshair.AttachedLine.Point1.Y = Crosshair.Y;
					Crosshair.AttachedLine.Point2.X = Crosshair.X;
					Crosshair.AttachedLine.Point2.Y = Crosshair.Y;
				}
				Draw();
			}
			break;

		case RECTANGLE_MODE:
				/* do update of position */
			NotifyBlock();

				/* create rectangle if both corners are determined 
				 * and width, height are != 0
				 */
			if (Crosshair.AttachedBox.State == STATE_THIRD &&
				Crosshair.AttachedBox.Point1.X != Crosshair.AttachedBox.Point2.X &&
				Crosshair.AttachedBox.Point1.Y != Crosshair.AttachedBox.Point2.Y)
			{
				PolygonTypePtr	polygon;

				if ((polygon = CreateNewPolygonFromRectangle(CURRENT, 
						Crosshair.AttachedBox.Point1.X,
						Crosshair.AttachedBox.Point1.Y,
						Crosshair.AttachedBox.Point2.X,
						Crosshair.AttachedBox.Point2.Y,
						CLEARPOLYFLAG)) != NULL)
				{
					AddObjectToCreateUndoList(POLYGON_TYPE, CURRENT,
						polygon, polygon);
					UpdatePIPFlags(NULL, NULL, CURRENT, True);
					IncrementUndoSerialNumber();
					DrawPolygon(CURRENT, polygon, 0);
					Draw();
					SetChangedFlag(True);
				}

					/* reset state to 'first corner' */
				Crosshair.AttachedBox.State = STATE_FIRST;
			}
			break;

		case TEXT_MODE:
		{
			char	*string;

			if ((string = GetUserInput("Enter text:", "")) != NULL)
			{
				TextTypePtr	text;
				int		flag = NOFLAG;

				if (GetLayerGroupNumberByNumber(INDEXOFCURRENT) ==
				    GetLayerGroupNumberByNumber(MAX_LAYER + SOLDER_LAYER))
					flag = ONSOLDERFLAG;
				if ((text = CreateNewText(CURRENT, &PCB->Font, Crosshair.X,
						Crosshair.Y, 0, Settings.TextScale,
						string, flag)) != NULL)
				{
					AddObjectToCreateUndoList(TEXT_TYPE, CURRENT, text, text);
					IncrementUndoSerialNumber();
					DrawText(CURRENT, text, 0);
					Draw();
					SetChangedFlag(True);
				}

					/* free memory allocated by GetUserInput() */
				SaveFree(string);
			}
			break;
		}

		case POLYGON_MODE:
		{
			PointTypePtr	points = Crosshair.AttachedPolygon.Points;
			Cardinal		n = Crosshair.AttachedPolygon.PointN;
			
				/* do update of position; use the 'LINE_MODE' mechanism */
			NotifyLine();

				/* check if this is the last point of a polygon */
			if (n >= 3 &&
				points->X == Crosshair.AttachedLine.Point2.X &&
				points->Y == Crosshair.AttachedLine.Point2.Y)
			{
				CopyAttachedPolygonToLayer();
				Draw();
				break;
			}

				/* create new point if it's the first one or if it's
				 * different to the last one
				 */
			if (!n ||
				points[n-1].X != Crosshair.AttachedLine.Point2.X ||
				points[n-1].Y != Crosshair.AttachedLine.Point2.Y)
			{
				CreateNewPointInPolygon(&Crosshair.AttachedPolygon,
					Crosshair.AttachedLine.Point2.X,
					Crosshair.AttachedLine.Point2.Y);

					/* copy the coordinates */
				Crosshair.AttachedLine.Point1.X=Crosshair.AttachedLine.Point2.X;
				Crosshair.AttachedLine.Point1.Y=Crosshair.AttachedLine.Point2.Y;
			}
			break;
		}

		case PASTEBUFFER_MODE:	
			if (CopyPastebufferToLayout(Crosshair.X, Crosshair.Y))
				SetChangedFlag(True);
			break;

		case REMOVE_MODE:
			if ((type = SearchObjectByPosition(REMOVE_TYPES,&ptr1,&ptr2,&ptr3,
				Crosshair.X, Crosshair.Y, TO_PCB(1))) != NO_TYPE)
			{
				RemoveObject(type, ptr1, ptr2, ptr3);
				SetChangedFlag(True);
			}
			break;

		case ROTATE_MODE:
			Crosshair.AttachedObject.RubberbandN = 0;
			if ((type = SearchObjectByPosition(ROTATE_TYPES,&ptr1,&ptr2,&ptr3,
				Crosshair.X, Crosshair.Y, TO_PCB(1))) != NO_TYPE)
			{
				if (TEST_FLAG(RUBBERBANDFLAG, PCB))
					LookupRubberbandLines(type,ptr1,ptr2,ptr3);
				else if (type == ELEMENT_TYPE)
					LookupRatLines((ElementTypePtr) ptr1);
				RotateObject(type,ptr1,ptr2,ptr3, Crosshair.X, Crosshair.Y, 1);
				SetChangedFlag(True);
			}
			break;

			/* both are almost the same */
		case COPY_MODE:
		case MOVE_MODE:
		case RUBBERBANDMOVE_MODE:
			switch(Crosshair.AttachedObject.State)
			{
					/* first notify, lookup object */
				case STATE_FIRST:
				{
					int	types = (Settings.Mode == COPY_MODE ) ?
									COPY_TYPES : MOVE_TYPES;

					Crosshair.AttachedObject.RubberbandN = 0;
					Crosshair.AttachedObject.Type= SearchObjectByPosition(types,
						&Crosshair.AttachedObject.Ptr1,
						&Crosshair.AttachedObject.Ptr2,
						&Crosshair.AttachedObject.Ptr3,
						Crosshair.X, Crosshair.Y,TO_PCB(1));
					if (Crosshair.AttachedObject.Type != NO_TYPE)
					{
						BoxTypePtr	box;

							/* change to next state and save start position */
						if (Crosshair.AttachedObject.Type == POLYGONPOINT_TYPE ||
							Crosshair.AttachedObject.Type == LINEPOINT_TYPE)
						{
							Crosshair.AttachedObject.X = ((PointTypePtr) 
								Crosshair.AttachedObject.Ptr3)->X;
							Crosshair.AttachedObject.Y = ((PointTypePtr) 
								Crosshair.AttachedObject.Ptr3)->Y;
						}
						else
						{
							Crosshair.AttachedObject.X = Crosshair.X;
							Crosshair.AttachedObject.Y = Crosshair.Y;
						}
						Crosshair.AttachedObject.State = STATE_SECOND;

							/* get boundingbox of object and set cursor range */
						box= GetObjectBoundingBox(Crosshair.AttachedObject.Type,
							Crosshair.AttachedObject.Ptr1,
							Crosshair.AttachedObject.Ptr2,
							Crosshair.AttachedObject.Ptr3);
						SetCrosshairRange(Crosshair.X -box->X1,
							Crosshair.Y -box->Y1,
							PCB->MaxWidth -(box->X2 -Crosshair.X),
							PCB->MaxHeight -(box->Y2 -Crosshair.Y));

							/* get all attached objects if necessary */
                                                if ((Settings.Mode != COPY_MODE) &&
                                                    XOR(Settings.Mode == RUBBERBANDMOVE_MODE,
                                                        TEST_FLAG(RUBBERBANDFLAG, PCB)))
							LookupRubberbandLines(Crosshair.AttachedObject.Type,
								Crosshair.AttachedObject.Ptr1,
								Crosshair.AttachedObject.Ptr2,
								Crosshair.AttachedObject.Ptr3);
						else if (Settings.Mode != COPY_MODE &&
							Crosshair.AttachedObject.Type == ELEMENT_TYPE)
								LookupRatLines((ElementTypePtr)
									Crosshair.AttachedObject.Ptr1);
					}
					break;
				}

					/* second notify, move or copy object */
				case STATE_SECOND:
					if (Settings.Mode == COPY_MODE)
						CopyObject(Crosshair.AttachedObject.Type,
							Crosshair.AttachedObject.Ptr1,
							Crosshair.AttachedObject.Ptr2,
							Crosshair.AttachedObject.Ptr3,
							Crosshair.X -Crosshair.AttachedObject.X,
							Crosshair.Y -Crosshair.AttachedObject.Y);
					else
						MoveObjectAndRubberband(Crosshair.AttachedObject.Type,
							Crosshair.AttachedObject.Ptr1,
							Crosshair.AttachedObject.Ptr2,
							Crosshair.AttachedObject.Ptr3,
							Crosshair.X -Crosshair.AttachedObject.X,
							Crosshair.Y -Crosshair.AttachedObject.Y);
					SetChangedFlag(True);

						/* reset identifiers */
					Crosshair.AttachedObject.Type = NO_TYPE;
					Crosshair.AttachedObject.State = STATE_FIRST;
					break;
			}
			break;

			/* insert a point into a polygon/line/... */
		case INSERTPOINT_MODE:
			switch(Crosshair.AttachedObject.State)
			{
					/* first notify, lookup object */
				case STATE_FIRST:
					Crosshair.AttachedObject.Type =
						SearchObjectByPosition(INSERT_TYPES,
						&Crosshair.AttachedObject.Ptr1,
						&Crosshair.AttachedObject.Ptr2,
						&Crosshair.AttachedObject.Ptr3,
						Crosshair.X, Crosshair.Y, TO_PCB(1));

					if (Crosshair.AttachedObject.Type != NO_TYPE)
					{
							/* get starting point of nearest segment */
						if (Crosshair.AttachedObject.Type == POLYGON_TYPE)
						{
                                                        fake.poly = (PolygonTypePtr)
                                                                       Crosshair.AttachedObject.Ptr2;
                                                        polyIndex = GetLowestDistancePolygonPoint(
                                                                       fake.poly, Crosshair.X, Crosshair.Y);
                                                        fake.line.Point1 = fake.poly->Points[polyIndex];
                                                        fake.line.Point2 = (polyIndex) ?
                                                                          fake.poly->Points[polyIndex-1]
                                                                          : fake.poly->Points[fake.poly->PointN-1];
                                                        Crosshair.AttachedObject.Ptr2 = &fake.line;

						}
						Crosshair.AttachedObject.State = STATE_SECOND;
                                                AdjustInsertPoint();
					}
					break;

					/* second notify, insert new point into object */
				case STATE_SECOND:
                                        if (Crosshair.AttachedObject.Type == POLYGON_TYPE)
                                                InsertPointIntoObject(POLYGON_TYPE,
                                                        Crosshair.AttachedObject.Ptr1, fake.poly,
                                                        &polyIndex,
                                                        InsertedPoint.X, InsertedPoint.Y, False);
                                        else    
					InsertPointIntoObject(Crosshair.AttachedObject.Type,
						Crosshair.AttachedObject.Ptr1,
						Crosshair.AttachedObject.Ptr2,
						&polyIndex,
                                                InsertedPoint.X, InsertedPoint.Y, False);
					SetChangedFlag(True);

						/* reset identifiers */
					Crosshair.AttachedObject.Type = NO_TYPE;
					Crosshair.AttachedObject.State = STATE_FIRST;
					break;
			}
			break;
	}
}
