
/*  A Bison parser, made from parse_y.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUMBER	258
#define	CHAR_CONST	259
#define	STRING	260
#define	T_PCB	261
#define	T_LAYER	262
#define	T_VIA	263
#define	T_LINE	264
#define	T_RECTANGLE	265
#define	T_TEXT	266
#define	T_ELEMENTLINE	267
#define	T_ELEMENT	268
#define	T_PIN	269
#define	T_PAD	270
#define	T_GRID	271
#define	T_FLAGS	272
#define	T_SYMBOL	273
#define	T_SYMBOLLINE	274
#define	T_CURSOR	275
#define	T_ELEMENTARC	276
#define	T_MARK	277
#define	T_GROUPS	278
#define	T_POLYGON	279

#line 1 "parse_y.y"

/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */

static	char	*rcsid = "$Id: parse_y.y,v 145.1 1997/07/26 12:56:25 nau Exp $";

/* grammar to parse ASCII input of PCB description
 */

#include "global.h"
#include "create.h"
#include "data.h"
#include "error.h"
#include "mymem.h"
#include "misc.h"
#include "parse_l.h"
#include "remove.h"

static	LayerTypePtr	Layer;
static	PolygonTypePtr	Polygon;
static	SymbolTypePtr	Symbol;
static	Boolean			LayerFlag[MAX_LAYER];

extern	char			*yytext;		/* defined by LEX */
extern	PCBTypePtr		yyPCB;
extern	DataTypePtr		yyData;
extern	ElementTypePtr	yyElement;
extern	FontTypePtr		yyFont;
extern	int				yylineno;		/* linenumber */
extern	char			*yyfilename;	/* in this file */


#line 57 "parse_y.y"
typedef union									/* define YYSTACK type */
{
	unsigned	number;
	char		*string;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		239
#define	YYFLAG		-32768
#define	YYNTBASE	27

#define YYTRANSLATE(x) ((unsigned)(x) <= 279 ? yytranslate[x] : 76)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    25,
    26,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     4,     6,     8,     9,    18,    20,    21,    22,
    25,    26,    29,    34,    41,    48,    49,    56,    57,    62,
    63,    68,    69,    71,    72,    74,    77,    79,    81,    82,
    85,    87,    89,    91,   101,   110,   111,   121,   123,   124,
   126,   129,   139,   148,   150,   152,   153,   162,   171,   181,
   183,   186,   191,   193,   195,   197,   198,   211,   212,   228,
   229,   246,   248,   251,   253,   255,   257,   266,   277,   283,
   293,   302,   313,   315,   318,   319,   329,   331,   333,   335,
   336,   338,   341
};

static const short yyrhs[] = {    28,
     0,    33,     0,    31,     0,     1,     0,     0,    29,    35,
    36,    37,    38,    39,    30,    40,     0,    31,     0,     0,
     0,    32,    69,     0,     0,    34,    57,     0,     6,    25,
     5,    26,     0,     6,    25,     5,     3,     3,    26,     0,
    16,    25,     3,     3,     3,    26,     0,     0,    20,    25,
     3,     3,     3,    26,     0,     0,    17,    25,     3,    26,
     0,     0,    23,    25,     5,    26,     0,     0,    41,     0,
     0,    42,     0,    41,    42,     0,    44,     0,    47,     0,
     0,    43,    57,     0,     1,     0,    45,     0,    46,     0,
     8,    25,     3,     3,     3,     3,     5,     3,    26,     0,
     8,    25,     3,     3,     3,     5,     3,    26,     0,     0,
     7,    25,     3,     5,    26,    25,    48,    49,    26,     0,
    50,     0,     0,    51,     0,    50,    51,     0,     9,    25,
     3,     3,     3,     3,     3,     3,    26,     0,    10,    25,
     3,     3,     3,     3,     3,    26,     0,    54,     0,    53,
     0,     0,    24,    25,     3,    26,    25,    52,    55,    26,
     0,    11,    25,     3,     3,     3,     5,     3,    26,     0,
    11,    25,     3,     3,     3,     3,     5,     3,    26,     0,
    56,     0,    55,    56,     0,    25,     3,     3,    26,     0,
    58,     0,    60,     0,    62,     0,     0,    13,    25,     5,
     5,     3,     3,     3,    26,    25,    59,    64,    26,     0,
     0,    13,    25,     3,     5,     5,     3,     3,     3,     3,
     3,    26,    25,    61,    64,    26,     0,     0,    13,    25,
     3,     5,     5,     5,     3,     3,     3,     3,     3,    26,
    25,    63,    64,    26,     0,    65,     0,    64,    65,     0,
    66,     0,    67,     0,    68,     0,    12,    25,     3,     3,
     3,     3,     3,    26,     0,    21,    25,     3,     3,     3,
     3,     3,     3,     3,    26,     0,    22,    25,     3,     3,
    26,     0,    14,    25,     3,     3,     3,     3,     5,     3,
    26,     0,    14,    25,     3,     3,     3,     5,     3,    26,
     0,    15,    25,     3,     3,     3,     3,     3,     5,     3,
    26,     0,    70,     0,    69,    70,     0,     0,    18,    25,
    72,     3,    26,    25,    71,    73,    26,     0,     3,     0,
     4,     0,    74,     0,     0,    75,     0,    74,    75,     0,
    19,    25,     3,     3,     3,     3,     3,    26,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    75,    76,    77,    78,    82,    99,   108,   109,   113,   128,
   134,   143,   146,   152,   161,   167,   171,   177,   181,   185,
   189,   197,   201,   202,   206,   207,   211,   212,   213,   221,
   221,   225,   226,   231,   241,   258,   276,   280,   281,   285,
   286,   291,   296,   301,   302,   304,   308,   326,   336,   344,
   345,   350,   357,   358,   359,   366,   373,   383,   390,   400,
   408,   415,   416,   420,   421,   422,   424,   429,   434,   443,
   455,   472,   479,   480,   484,   500,   504,   505,   509,   510,
   514,   515,   520
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUMBER",
"CHAR_CONST","STRING","T_PCB","T_LAYER","T_VIA","T_LINE","T_RECTANGLE","T_TEXT",
"T_ELEMENTLINE","T_ELEMENT","T_PIN","T_PAD","T_GRID","T_FLAGS","T_SYMBOL","T_SYMBOLLINE",
"T_CURSOR","T_ELEMENTARC","T_MARK","T_GROUPS","T_POLYGON","'('","')'","parse",
"parsepcb","@1","pcbfont","parsefont","@2","parseelement","@3","pcbname","pcbgrid",
"pcbcursor","pcbflags","pcbgroups","pcbdata","pcbdefinitions","pcbdefinition",
"@4","via","via_newformat","via_oldformat","layer","@5","layerdata","layerdefinitions",
"layerdefinition","@6","text_oldformat","text_newformat","polygonpoints","polygonpoint",
"element","element_oldformat","@7","element_1.3.4_format","@8","element_newformat",
"@9","elementdefinitions","elementdefinition","pin_newformat","pin_oldformat",
"pad","symbols","symbol","@10","symbolid","symboldata","symboldefinitions","symboldefinition", NULL
};
#endif

static const short yyr1[] = {     0,
    27,    27,    27,    27,    29,    28,    30,    30,    32,    31,
    34,    33,    35,    35,    36,    36,    37,    37,    38,    38,
    39,    39,    40,    40,    41,    41,    42,    42,    43,    42,
    42,    44,    44,    45,    46,    48,    47,    49,    49,    50,
    50,    51,    51,    51,    51,    52,    51,    53,    54,    55,
    55,    56,    57,    57,    57,    59,    58,    61,    60,    63,
    62,    64,    64,    65,    65,    65,    65,    65,    65,    66,
    67,    68,    69,    69,    71,    70,    72,    72,    73,    73,
    74,    74,    75
};

static const short yyr2[] = {     0,
     1,     1,     1,     1,     0,     8,     1,     0,     0,     2,
     0,     2,     4,     6,     6,     0,     6,     0,     4,     0,
     4,     0,     1,     0,     1,     2,     1,     1,     0,     2,
     1,     1,     1,     9,     8,     0,     9,     1,     0,     1,
     2,     9,     8,     1,     1,     0,     8,     8,     9,     1,
     2,     4,     1,     1,     1,     0,    12,     0,    15,     0,
    16,     1,     2,     1,     1,     1,     8,    10,     5,     9,
     8,    10,     1,     2,     0,     9,     1,     1,     1,     0,
     1,     2,     8
};

static const short yydefact[] = {     0,
     4,     1,     0,     3,     0,     2,     0,     0,    16,     0,
    10,    73,     0,    12,    53,    54,    55,     0,     0,    18,
     0,    74,     0,     0,     0,     0,    20,    77,    78,     0,
     0,     0,     0,    13,     0,     0,     0,    22,     0,     0,
     0,     0,     0,     0,     0,     0,     8,     0,     0,     0,
    14,     0,     0,     0,     0,     0,     7,    75,     0,     0,
     0,    15,     0,    19,     0,    31,     0,     0,     6,     0,
    25,     0,    27,    32,    33,    28,    80,     0,     0,     0,
    17,    21,     0,     0,    26,    30,     0,     0,    79,    81,
     0,     0,     0,     0,     0,     0,    76,    82,     0,     0,
    56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    62,    64,
    65,    66,    36,     0,     0,     0,    58,     0,     0,     0,
     0,     0,     0,    57,    63,    39,     0,     0,     0,     0,
    60,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    38,    40,    45,    44,     0,    35,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
    41,    34,    83,    59,     0,     0,     0,     0,     0,    69,
     0,     0,     0,     0,    61,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    46,    67,     0,    71,     0,     0,     0,     0,
     0,     0,     0,    70,     0,     0,     0,     0,     0,     0,
     0,     0,    50,    72,    68,     0,    43,     0,    48,     0,
    47,    51,    42,    49,     0,    52,     0,     0,     0
};

static const short yydefgoto[] = {   237,
     2,     3,    56,     4,     5,     6,     7,     9,    20,    27,
    38,    47,    69,    70,    71,    72,    73,    74,    75,    76,
   136,   151,   152,   153,   213,   154,   155,   222,   223,    14,
    15,   107,    16,   140,    17,   160,   118,   119,   120,   121,
   122,    11,    12,    77,    30,    88,    89,    90
};

static const short yypact[] = {     2,
-32768,-32768,    15,-32768,    -4,-32768,    17,    -8,    28,    31,
    -4,-32768,    36,-32768,-32768,-32768,-32768,    48,    43,    49,
    39,-32768,     4,    -2,    67,    51,    56,-32768,-32768,    71,
    70,    72,    75,-32768,    76,    77,    57,    58,    59,    78,
    81,    60,    84,    85,    86,    65,    73,    68,     7,    89,
-32768,    69,    91,    74,    92,    27,-32768,-32768,    93,    95,
    96,-32768,    79,-32768,    80,-32768,    82,    83,-32768,    47,
-32768,    17,-32768,-32768,-32768,-32768,    90,    98,    99,    87,
-32768,-32768,   100,   101,-32768,-32768,    94,    88,    90,-32768,
   107,   108,    97,   110,   109,   113,-32768,-32768,   114,   115,
-32768,   102,   117,   118,   103,   120,    50,   105,     8,   121,
   106,   111,   116,   119,   122,   123,   124,    11,-32768,-32768,
-32768,-32768,-32768,   127,   130,   131,-32768,   125,   132,   133,
   135,   136,   137,-32768,-32768,    -5,   139,   126,   140,    50,
-32768,   142,   143,   148,   150,   151,   134,   138,   141,   144,
   129,    -5,-32768,-32768,-32768,   145,-32768,   146,    24,    50,
   153,   154,   155,   157,   147,   158,   159,   161,   162,-32768,
-32768,-32768,-32768,-32768,    37,   164,    13,   165,   167,-32768,
   171,   172,   173,   152,-32768,   174,   175,   176,   178,   179,
   180,   181,   182,   163,   160,   184,   166,   185,   186,   188,
   190,    26,-32768,-32768,   168,-32768,   192,   193,   194,   195,
   196,   197,   177,-32768,   183,   187,   200,   189,   201,   191,
   202,    41,-32768,-32768,-32768,   198,-32768,   199,-32768,   203,
-32768,-32768,-32768,-32768,   204,-32768,   207,   208,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,   169,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,    55,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,   -26,-32768,-32768,-32768,-32768,   -95,   149,
-32768,-32768,-32768,-32768,-32768,-32768,  -138,  -118,-32768,-32768,
-32768,-32768,   209,-32768,-32768,-32768,-32768,   156
};


#define	YYLAST		245


static const short yytable[] = {   135,
    33,   159,     1,   147,   148,   149,    31,    -5,    32,    59,
   124,    60,   125,    10,   -11,   187,    18,   188,   150,    -9,
     8,   175,   113,    34,   114,   115,   -24,    66,   211,    13,
   212,   116,   117,    67,    68,   113,   134,   114,   115,   -29,
   135,    28,    29,    19,   116,   117,   -23,    66,   113,   174,
   114,   115,    24,    67,    68,    21,   135,   116,   117,   -29,
    23,   113,   185,   114,   115,   221,   231,    25,    26,    35,
   116,   117,    37,    39,    40,    36,    41,    42,    43,    44,
    46,    45,    49,    50,    48,    51,    52,    53,    54,    55,
    -9,    61,    58,    63,    62,    78,    65,    79,    80,    64,
    91,    92,    94,    95,    81,    82,    83,    84,    87,    99,
   100,   103,    93,    97,   102,   104,   105,   106,    96,   109,
   110,   101,   112,   126,    85,   171,   232,   108,   111,   123,
   127,   137,   138,   139,   142,   143,   128,   144,   145,   146,
   129,   156,   158,   130,   161,   162,   131,   132,   133,   141,
   163,   157,   164,   165,   170,   176,   177,   178,   166,   179,
   181,   182,   167,   183,   184,   168,   186,   189,   169,   190,
   172,   173,   180,   191,   192,   193,   195,   194,   197,   196,
   198,   199,   200,   201,   202,   204,   205,   203,   208,   207,
   209,   206,   210,   214,   215,   216,   217,   218,     0,   220,
   219,   221,   226,   228,   230,   235,   238,   239,   224,     0,
     0,     0,   225,     0,   227,    57,   229,     0,     0,    22,
    86,     0,     0,   233,   234,     0,     0,     0,     0,   236,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    98
};

static const short yycheck[] = {   118,
     3,   140,     1,     9,    10,    11,     3,     6,     5,     3,
     3,     5,     5,    18,    13,     3,    25,     5,    24,    18,
     6,   160,    12,    26,    14,    15,     0,     1,     3,    13,
     5,    21,    22,     7,     8,    12,    26,    14,    15,    13,
   159,     3,     4,    16,    21,    22,     0,     1,    12,    26,
    14,    15,     5,     7,     8,    25,   175,    21,    22,    13,
    25,    12,    26,    14,    15,    25,    26,    25,    20,     3,
    21,    22,    17,     3,     5,    25,     5,     3,     3,     3,
    23,    25,     5,     3,    26,    26,     3,     3,     3,    25,
    18,     3,    25,     3,    26,     3,     5,     3,     3,    26,
     3,     3,     3,     3,    26,    26,    25,    25,    19,     3,
     3,     3,    26,    26,     5,     3,     3,     3,    25,     3,
     3,    25,     3,     3,    70,   152,   222,    26,    26,    25,
    25,     5,     3,     3,     3,     3,    26,     3,     3,     3,
    25,     3,     3,    25,     3,     3,    25,    25,    25,    25,
     3,    26,     3,     3,    26,     3,     3,     3,    25,     3,
     3,     3,    25,     3,     3,    25,     3,     3,    25,     3,
    26,    26,    26,     3,     3,     3,     3,    26,     3,     5,
     3,     3,     3,     3,     3,    26,     3,    25,     3,     5,
     3,    26,     3,    26,     3,     3,     3,     3,    -1,     3,
     5,    25,     3,     3,     3,     3,     0,     0,    26,    -1,
    -1,    -1,    26,    -1,    26,    47,    26,    -1,    -1,    11,
    72,    -1,    -1,    26,    26,    -1,    -1,    -1,    -1,    26,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    89
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 4:
#line 78 "parse_y.y"
{ YYABORT; ;
    break;}
case 5:
#line 82 "parse_y.y"
{
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyPCB)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER; i++)
					LayerFlag[i] = False;
				yyFont = &yyPCB->Font;
				yyData = yyPCB->Data;
			;
    break;}
case 9:
#line 114 "parse_y.y"
{
					/* mark all symbols invalid */
				int	i;

				if (!yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				yyFont->Valid = False;
				for (i = 0; i <= MAX_FONTPOSITION; i++)
					yyFont->Symbol[i].Valid = False;
			;
    break;}
case 10:
#line 128 "parse_y.y"
{
				yyFont->Valid = True;
		  		SetFontInfo(yyFont);
			;
    break;}
case 11:
#line 135 "parse_y.y"
{
				if (!yyElement)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
			;
    break;}
case 13:
#line 147 "parse_y.y"
{
				yyPCB->Name = yyvsp[-1].string;
				yyPCB->MaxWidth = MAX_COORD;
				yyPCB->MaxHeight = MAX_COORD;
			;
    break;}
case 14:
#line 153 "parse_y.y"
{
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number;
				yyPCB->MaxHeight = yyvsp[-1].number;
			;
    break;}
case 15:
#line 162 "parse_y.y"
{
				yyPCB->Grid = yyvsp[-3].number;
				yyPCB->GridOffsetX = yyvsp[-2].number;
				yyPCB->GridOffsetY = yyvsp[-1].number;
			;
    break;}
case 17:
#line 172 "parse_y.y"
{
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].number;
			;
    break;}
case 19:
#line 182 "parse_y.y"
{
				yyPCB->Flags = yyvsp[-1].number & PCB_FLAGS;
			;
    break;}
case 21:
#line 190 "parse_y.y"
{
				if (ParseGroupString(yyvsp[-1].string, &yyPCB->LayerGroups))
				{
					Message("illegal layer-group string\n");
					YYABORT;
				}
			;
    break;}
case 29:
#line 214 "parse_y.y"
{
					/* clear pointer to force memory allocation by 
					 * the appropriate subroutine
					 */
				yyElement = NULL;
			;
    break;}
case 31:
#line 221 "parse_y.y"
{ YYABORT; ;
    break;}
case 34:
#line 232 "parse_y.y"
{
				CreateNewVia(yyData, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			;
    break;}
case 35:
#line 242 "parse_y.y"
{
				Dimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE)/100;

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				CreateNewVia(yyData, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, hole, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			;
    break;}
case 36:
#line 259 "parse_y.y"
{
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_LAYER)
				{
					yyerror("Layernumber out of range");
					YYABORT;
				}
				if (LayerFlag[yyvsp[-3].number-1])
				{
					yyerror("Layernumber used twice");
					YYABORT;
				}
				Layer = &yyData->Layer[yyvsp[-3].number-1];

					/* memory for name is alread allocated */
				Layer->Name = yyvsp[-2].string;
				LayerFlag[yyvsp[-3].number-1] = True;
			;
    break;}
case 42:
#line 292 "parse_y.y"
{
				CreateNewLineOnLayer(Layer, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number & OBJ_FLAGS);
			;
    break;}
case 43:
#line 297 "parse_y.y"
{
				CreateNewPolygonFromRectangle(Layer,
					yyvsp[-5].number, yyvsp[-4].number, yyvsp[-5].number+yyvsp[-3].number, yyvsp[-4].number+yyvsp[-2].number, yyvsp[-1].number & OBJ_FLAGS);
			;
    break;}
case 46:
#line 305 "parse_y.y"
{
				Polygon = CreateNewPolygon(Layer, yyvsp[-2].number & OBJ_FLAGS);
			;
    break;}
case 47:
#line 309 "parse_y.y"
{
					/* ignore junk */
				if (Polygon->PointN >= 3)
					SetPolygonBoundingBox(Polygon);
				else
				{
					Message("WARNING parsing file '%s'\n"
						"    line:        %i\n"
						"    description: 'ignored polygon (< 3 points)'\n",
						yyfilename, yylineno);
					DestroyObject(PCB->Data, POLYGON_TYPE, Layer, Polygon, Polygon);
				}
			;
    break;}
case 48:
#line 327 "parse_y.y"
{
					/* use a default scale of 100% */
				CreateNewText(Layer,yyFont,yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, 100, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				SaveFree(yyvsp[-2].string);
			;
    break;}
case 49:
#line 337 "parse_y.y"
{
				CreateNewText(Layer,yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				SaveFree(yyvsp[-2].string);
			;
    break;}
case 52:
#line 351 "parse_y.y"
{
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number, yyvsp[-1].number);
			;
    break;}
case 56:
#line 367 "parse_y.y"
{
				yyElement = CreateNewElement(yyData, yyElement, yyFont, 0x0000,
					yyvsp[-6].string, yyvsp[-5].string, NULL, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, 100, 0x0000);
				SaveFree(yyvsp[-6].string);
				SaveFree(yyvsp[-5].string);
			;
    break;}
case 57:
#line 374 "parse_y.y"
{
				SetElementBoundingBox(yyElement);
			;
    break;}
case 58:
#line 384 "parse_y.y"
{
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-9].number,
					yyvsp[-8].string, yyvsp[-7].string, NULL, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
			;
    break;}
case 59:
#line 391 "parse_y.y"
{
				SetElementBoundingBox(yyElement);
			;
    break;}
case 60:
#line 401 "parse_y.y"
{
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-10].number,
					yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number);
				SaveFree(yyvsp[-9].string);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
			;
    break;}
case 61:
#line 409 "parse_y.y"
{
				SetElementBoundingBox(yyElement);
			;
    break;}
case 67:
#line 425 "parse_y.y"
{
				CreateNewLineInElement(yyElement, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			;
    break;}
case 68:
#line 430 "parse_y.y"
{
				CreateNewArcInElement(yyElement, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			;
    break;}
case 69:
#line 435 "parse_y.y"
{
				yyElement->MarkX = yyvsp[-2].number;
				yyElement->MarkY = yyvsp[-1].number;
			;
    break;}
case 70:
#line 444 "parse_y.y"
{
				CreateNewPin(yyElement, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-2].string);
			;
    break;}
case 71:
#line 456 "parse_y.y"
{
				Dimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE)/100;

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				CreateNewPin(yyElement, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, hole, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-2].string);
			;
    break;}
case 72:
#line 473 "parse_y.y"
{
				CreateNewPad(yyElement,yyvsp[-7].number,yyvsp[-6].number,yyvsp[-5].number,yyvsp[-4].number,yyvsp[-3].number,yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS));
			;
    break;}
case 75:
#line 485 "parse_y.y"
{
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number;
			;
    break;}
case 83:
#line 521 "parse_y.y"
{
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 526 "parse_y.y"


/* ---------------------------------------------------------------------------
 * error routine called by parser library
 */
int yyerror(s)
char *s;
{
	Message("ERROR parsing file '%s'\n"
		"    line:        %i\n"
		"    description: '%s'\n",
		yyfilename, yylineno, s);
	return(0);
}

