/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 *  RCS: $Id: set.h,v 145.1 1997/07/26 12:56:29 nau Exp $
 */

/* prototypes for update routines
 */

#ifndef	__UPDATE_INCLUDED__
#define	__UPDATE_INCLUDED__

#include "global.h"

void		SetCursorStatusLine(void);
void		SetStatusLine(void);
void		SetGrid(int);
void		SetZoom(int);
void		SetLineSize(Dimension);
void		SetViaSize(Dimension, Boolean);
void		SetViaDrillingHole(Dimension, Boolean);
void		SetTextScale(Dimension);
void		SetChangedFlag(Boolean);
void		UpdateSettingsOnScreen(void);
void		SetBufferNumber(int);
void		SetMode(int);

#endif
