/* scanner for a PIC Assembler language */

%s cfg

%{

#include "picpar.tab.h"

extern int maclookup();
extern int hex2i();
extern int bin2i();
extern int oct2i();
extern int dec2i();

int line_number;

%}

%%

("0x"|"0X")[0-9a-fA-F]+	{ yylval.integer = hex2i(yytext); return NUM; }
"0"[0-7]+		{ yylval.integer = oct2i(yytext); return NUM; }
("0b"|"0B")[0-1]+	{ yylval.integer = bin2i(yytext); return NUM; }
[0-9]+			{ yylval.integer = dec2i(yytext); return NUM; }
"$"[0-9]+		{ yylval.integer = dec2i(yytext+1); return DOLLAR; }

">>"|"<<"|">="|"<="|"=="|">"|"<"|"!="|"="|"equ"|"&"|"|"|"^"|"&&"|"||"|"^^"|"++"|"--"|"+"|"-"|"*"|"/"|"%"|"~"|"("|")"|"."|":" {
				strcpy(yylval.string, yytext);
				return SYMBOL;
			}

"#"			{ return HASH;  }
","			{ return COMMA; }
"macro"|"MACRO"		{ return MACRO; }
"endm"|"ENDM"		{ return ENDM; }
"config"|"CONFIG"	{ BEGIN(cfg); return CONFIG; }


<cfg>"clk"		{ return CLOCK; }
<cfg>"rc"		{ yylval.integer = 3; return OSC; }
<cfg>"hs"		{ yylval.integer = 2; return OSC; }
<cfg>"xt"		{ yylval.integer = 1; return OSC; }
<cfg>"lp"		{ yylval.integer = 0; return OSC; }
<cfg>"id"		{ return ID; }
<cfg>"pic"		{ return PIC; }
<cfg>"cp"		{ return CP; }
<cfg>"wdt"		{ return WDT; }
<cfg>"pwrup"		{ return PWRUP; }

<cfg>"enabled"		{ yylval.integer = 1; return FLAG; }
<cfg>"on"		{ yylval.integer = 1; return FLAG; }
<cfg>"disabled"		{ yylval.integer = 0; return FLAG; }
<cfg>"off"		{ yylval.integer = 0; return FLAG; }
<cfg>";"[^\n]*		{ BEGIN(INITIAL);     return ENDCFG; /* and remove any comment */ }


";"[^\n]*		{ /* comment */ }

[A-Za-z_][A-Za-z0-9_]*	{	int i;

				strcpy(yylval.string, yytext);

				i = 0;
				while(yylval.string[i])
				{
					yylval.string[i] = tolower(yylval.string[i]);
					i++;
				}

				if (maclookup(yylval.string))
					return MAC_USE;
				else
					return ID;
			}

[ \t]+			/* eat up whitespace */

\n			{ line_number++; yylval.integer = line_number; return NEWLINE; }

\"[^\"\n]*\"		{ strcpy(yylval.string, yytext); return STRING; }

<<EOF>>			{ return 0; }

.			printf("Unrecognized character: %s\n", yytext);

%%
