/* macro.c */

#include "picasm.h"

void definemacro()
{
	SYMBOL *p;
	SYMBOL *param;
	int numparams;
	int numsyms;
	char macroname[BSIZE];

	match(MACRO);

	if(current_symbol.token != ID)
		error("macro needs a name","","","");

	p = lookup(current_symbol.lexptr);

	p->type = MACRO_DEF;
	p->value = last_macro;

	strcpy(macroname,p->lexptr);

	numparams = 0;

	getanother();	/* parameter list */

	while(current_symbol.token == COMMA)
	{
		getanother();

		if(current_symbol.token != ID)
			error("Macro parameters are identifiers","","","");

		param = lookup(current_symbol.lexptr);
		param->type = MACRO_ARG;	/* actual value filled in at */
						/* macro expansion time */

		macros[last_macro].params[numparams] = param;

		numparams++;
		if(numparams > MAXPARAMS)
			error("Too many parameters for macro","","","");

		getanother();
	}

	macros[last_macro].numparams = numparams;
	macros[last_macro].startsym  = last_macrostore;

	numsyms = 0;

	while(current_symbol.token != ENDM)
	{
		cpsym(&macrostore[last_macrostore], &current_symbol);
		numsyms++;
		last_macrostore++;
		if(last_macrostore > MAXMACROSTORE)
			error("Too many too large macros","","","");
		getanother();	/* not finished yet */
	}
	match(ENDM);

	macros[last_macro].numsyms = numsyms;

	last_macro++;
	if(last_macro > MAXMACROS)
		error("Too many macros","","","");
}

/* ... The End ... */

