/* lex_nums.c */

#include "picasm.h"

void donumber()
{
	int build_num;
	int ch;

	build_num = 0;
	ch = lexgetchar();
	if (ch == '0')
	{
		ch = lexgetchar();
		if (tolower(ch) == 'x')
		{				/* hex */
			ch = lexgetchar();
			while(isxdigit(ch))
			{
				build_num *= 16;
				if (isdigit(ch))
					build_num += ch - '0';
				else
					build_num += tolower(ch) - 'a' + 10;
				ch = lexgetchar();
			}
			lexungetc(ch);
		}
		else
		if (tolower(ch) == 'b')
		{				/* binary */
			ch = lexgetchar();
			while((ch == '0') || (ch == '1'))
			{
				build_num *= 2;
				build_num += ch - '0';
				ch = lexgetchar();
			}
			lexungetc(ch);
		}
		else
		{				/* octal */
			while((ch >= '0') && (ch <= '7'))
			{
				build_num *= 8;
				build_num += ch - '0';
				ch = lexgetchar();
			}
			lexungetc(ch);
		}
	}
	else
	{					/* decimal */
		while(isdigit(ch))
		{
			build_num *= 10;
			build_num += ch - '0';
			ch = lexgetchar();
		}
		lexungetc(ch);
	}

	current_symbol.token = NUM;
	current_symbol.value = build_num;
}

/* ... The End ... */
