;;
;; FILE: m6811-local.md
;; RSC:  $Revision: 1.8 $ $Date: 93/02/23 21:29:01 $
;;-------------------------------------------------------------------
;;- Machine description file for Motorola HC6811C for GNU C compiler
;;-
;;- Contributed by Otto Lind (otto@coactive.com)
;;- Based on original 6809 port by Tom Jones (jones@sal.wisc.edu)
;;-
;;   Copyright (C) 1987, 1993 Free Software Foundation, Inc.

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;;- Instruction patterns.  When multiple patterns apply,
;;- the first one in the file is chosen.
;;-
;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;-
;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

;;--------------------------------------------------------------------
;;-  Test
;;--------------------------------------------------------------------

(define_insn "tstsi"
  [(set (cc0)
	(match_operand:SI 0 "nonimmediate_operand" "g"))]
  ""
 "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\t%0\", operands);
    return \"ADDD\\t#0\\t; tstsi: R:%0\";
}")

(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "nonimmediate_operand" "g"))]
  ""
 "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\t%0\", operands);
    return \"ADDD\\t#0\\t; tsthi: R:%0\";
}")

(define_insn "tstqi"
  [(set (cc0)
	(match_operand:QI 0 "nonimmediate_operand" "g"))]
  ""
 "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
	return \"TST\\t%0\\t; tstqi: MEM:%0\";
    }
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	output_asm_insn(\"LDAB\\t%0\", operands);
    }
    return \"TSTB\\t\\t; tstqi: R:%0\";
}")

;;--------------------------------------------------------------------
;;- Compare
;;--------------------------------------------------------------------

;;- cmpsi for register to memory or register compares
(define_insn "cmpsi"
  [(set (cc0)
	(compare (match_operand:SI 0 "nonimmediate_operand" "g")
		 (match_operand:SI 1 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\t%0\", operands);
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    return \"CPD\\t%1\\t; cmpsi %0 with %1\";
}")

(define_insn "cmphi"
  [(set (cc0)
	(compare (match_operand:HI 0 "nonimmediate_operand" "g")
		 (match_operand:HI 1 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\t%0\", operands);
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    return \"CPD\\t%1\\t; cmphi %0 with %1\";
}")

(define_insn "cmpqi"
  [(set (cc0)
        (compare (match_operand:QI 0 "nonimmediate_operand" "g")
                 (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }
    if (REG_P(operands[1]) && !Q_REGNO_P(REGNO(operands[1])))
    {
	return \"CMPB\\t%1+1\\t; cmpqi %0 with %1\";
    }
    else
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	return \"CMPB\\t%1\\t; cmpqi %0 with %1\";
    }
}")


;;--------------------------------------------------------------------
;;-  Move
;;--------------------------------------------------------------------

(define_insn "movdi"
  [(set (match_operand:DI 0 "memory_operand" "=m")
	(match_operand:DI 1 "memory_operand"  "m"))]
  ""
  "*
{
    return \".bogus\\t; movdi: %1 -> %0\";
}")

(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(match_operand:SI 1 "general_operand"  "g"))]
  ""
  "*
{
    if ((GET_CODE(operands[0]) == MEM) &&
	(GET_CODE(XEXP(operands[0], 0)) == PRE_DEC))
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	output_asm_insn(\"LDD\\t%1\", operands);
	return \"PSHB\\n\\tPSHA\\t\\t; movsi: %1 -> %0\";
    }

    if (REG_P(operands[0]) && (REGNO(operands[0]) == HARD_SP_REGNUM))
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	return \"LDX\\t%1\\n\\tTXS\\t\\t; movsi: %1 -> %0\";
    }
    if (REG_P(operands[1]) && (REGNO(operands[1]) == HARD_SP_REGNUM))
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	return \"TSX\\n\\tSTX\\t%0\\t; movsi: %1 -> %0\";
    }
    if (REG_P(operands[0]) && REGNO(operands[0]) == HARD_Y_REGNUM)
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	return \"LDY\\t%1\\t; movsi: %1 -> %0\";
    }			    
    if (REG_P(operands[1]) && REGNO(operands[1]) == HARD_Y_REGNUM)
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	return \"STY\\t%0\\t; movsi: %1 -> %0\";
    }			    

    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDD\\t%1\", operands);
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"STD\\t%0\\t; movsi: %1 -> %0\", operands);

    return \"\";
}")

;;- movhi
(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(match_operand:HI 1 "general_operand" "g"))]
  ""
  "*
{
    if ((GET_CODE(operands[0]) == MEM) &&
	(GET_CODE(XEXP(operands[0], 0)) == PRE_DEC))
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	output_asm_insn(\"LDD\\t%1\", operands);
	return \"PSHB\\n\\tPSHA\\t\\t; movhi: %1 -> %0\";
    }

    if (REG_P(operands[0]) && (REGNO(operands[0]) == HARD_SP_REGNUM))
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	return \"LDX\\t%1\\n\\tTXS\\t\\t; movhi: %1 -> %0\";
    }
    if (REG_P(operands[1]) && (REGNO(operands[1]) == HARD_SP_REGNUM))
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	return \"TSX\\n\\tSTX\\t%0\\t; movhi: %1 -> %0\";
    }
    if (REG_P(operands[0]) && REGNO(operands[0]) == HARD_Y_REGNUM)
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	return \"LDY\\t%1\\t; movhi: %1 -> %0\";
    }			    
    if (REG_P(operands[1]) && REGNO(operands[1]) == HARD_Y_REGNUM)
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	return \"STY\\t%0\\t; movhi: %1 -> %0\";
    }			    

    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDD\\t%1\", operands);
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"STD\\t%0\\t; movhi: %1 -> %0\", operands);

    return \"\";
}")

;;- movqi
(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(match_operand:QI 1 "general_operand"  "g"))]
  ""
  "*
{
    if ((GET_CODE(operands[0]) == MEM) &&
	(GET_CODE(XEXP(operands[0], 0)) == PRE_DEC))
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	return \"LDAB\\t%1\\n\\tPSHB\\t\\t; movqi: %1 -> %0\";
    }

    if (REG_P(operands[1]) && !Q_REGNO_P(REGNO(operands[1])))
    {
	output_asm_insn(\"LDAB\\t%1+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[1]) == MEM)
	{
	    output_swap_regx(operands[1]);
	}
	output_asm_insn(\"LDAB\\t%1\", operands);
    }

    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"CLRA\\t\", operands);
	output_asm_insn(\"STD\\t%0\\t; movqi: %1 -> %0\", operands);
    }
    else
    {
	output_asm_insn(\"STAB\\t%0\\t; movqi: %1 -> %0\", operands);
    }

    return \"\";
}")

;;--------------------------------------------------------------------
;;-  Swap registers
;;--------------------------------------------------------------------
;;(define_insn "swapsi"
;;  [(set (match_operand:SI 0 "register_operand" "+r")
;;	(match_operand:SI 1 "register_operand" "+r"))
;;   (set (match_dup 1) (match_dup 0))]
;;  ""
;;  "exg\\t%1,%0\\t;swapsi: R:%1 <-> R:%0")
;;
;;(define_insn "swaphi"
;;  [(set (match_operand:HI 0 "byte_reg_operand" "+q")
;;	(match_operand:HI 1 "byte_reg_operand" "+q"))
;;   (set (match_dup 1) (match_dup 0))]
;;  ""
;;  "exg\\t%1,%0\\t;swaphi: R:%1 <-> R:%0")
;;
;;--------------------------------------------------------------------
;;-  Extension and truncation insns.
;;--------------------------------------------------------------------
;; Those for integer source operand
;; are ordered widest source type first.

(define_insn "truncsiqi2"
  [(set (match_operand:QI 0 "register_operand" "=d,a")
	(truncate:QI (match_operand:SI 1 "register_operand" "d,a")))]
  ""
  ".bogus\\t; truncsiqi2: %1 to %0")

(define_insn "truncsihi2"
  [(set (match_operand:HI 0 "register_operand" "=d,a")
	(truncate:HI (match_operand:SI 1 "register_operand" "d,a")))]
  ""
  ".bogus\\t; truncsihi2: %1 to %0")

(define_insn "trunchiqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(truncate:QI (match_operand:HI 1 "register_operand" "0")))]
  ""
  ".bogus\\t; trunchiqi2: %1 to %0")

(define_insn "truncdisi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(truncate:SI (match_operand:DI 1 "register_operand" "d")))]
  ""
  ".bogus\\t; truncdisi2: %1 to %0")

(define_insn "extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(sign_extend:DI (match_operand:SI 1 "register_operand" "d")))]
  ""
  ".bogus\\t; extendsidi2: %1 to %0")

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,a")
	(sign_extend:SI (match_operand:HI 1 "register_operand" "d,a")))]
  ""
  ".bogus\\t; extendhisi2: %1 to %0")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "general_operand" "qmi")))]
  ""
  "*
{
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDAB\\t%1\", operands);
    output_asm_insn(\"CLRA\", operands);
    output_asm_insn(\"TSTB\", operands);
    output_asm_insn(\"BGE\\t*+3\", operands);

    output_asm_insn(\"DECA\", operands);
    output_asm_insn(\"STD\\t%0\\t; extendqisi2: %1 to %0\", operands);

    return \"\";
}")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI (match_operand:QI 1 "general_operand" "qmi")))]
  ""
  "*
{
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDAB\\t%1\", operands);
    output_asm_insn(\"CLRA\", operands);
    output_asm_insn(\"TSTB\", operands);
    output_asm_insn(\"BGE\\t*+3\", operands);

    output_asm_insn(\"DECA\", operands);
    output_asm_insn(\"STD\\t%0\\t; extendqihi2: %1 to %0\", operands);

    return \"\";
}")

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=d")
	(float_extend:DF (match_operand:SF 1 "register_operand" "d")))]
  ""
  ".bogus\\t; extendsfdf2: %1 to %0")

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "register_operand" "=d")
	(float_truncate:SF (match_operand:DF 1 "register_operand" "d")))]
  ""
  ".bogus\\t; truncdfsf2: %1 to %0")

(define_insn "zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(zero_extend:DI (match_operand:SI 1 "register_operand" "0")))]
  ""
  ".bogus\\t; zero_extendsidi2 %1 to %0")

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI (match_operand:HI 1 "register_operand" "0")))]
  ""
  ".bogus\\t; zero_extendhisi2: %1 to %0")

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI (match_operand:QI 1 "general_operand" "qmi")))]
  ""
 "*
{
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDAB\\t%1\", operands);
    output_asm_insn(\"CLRA\", operands);
    output_asm_insn(\"STD\\t%0\\t; zero_extendqisi2: %1 to %0\", operands);

    return \"\";
}")

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI (match_operand:QI 1 "general_operand" "qmi")))]
  ""
 "*
{
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDAB\\t%1\", operands);
    output_asm_insn(\"CLRA\", operands);
    output_asm_insn(\"STD\\t%0\\t; zero_extendqihi2: %1 to %0\", operands);

    return \"\";
}")

;;--------------------------------------------------------------------
;;-  Fix-to-float conversion insns.
;;--------------------------------------------------------------------
;; Don't do floats for now


;;--------------------------------------------------------------------
;;-  Float-to-fix conversion insns.
;;--------------------------------------------------------------------
;; Don't do floats for now


;;--------------------------------------------------------------------
;;- Add instructions.
;;--------------------------------------------------------------------

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_operand:SI 1 "register_operand" "0")
		 (match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    output_asm_insn(\"LDD\\t%0\", operands);
    if (REG_P(operands[2]) && REGNO(operands[2]) == HARD_Y_REGNUM)
    {
	output_asm_insn(\"STY\\tZXT\", operands);
	output_asm_insn(\"ADDD\\tZXT\", operands);
    }			    
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"ADDD\\t%2\", operands);
    }
    output_asm_insn(\"STD\\t%0\\t; addsi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "addhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=md,r")
	(plus:HI (match_operand:HI 1 "general_operand" "%0,0")
		 (match_operand:HI 2 "general_operand" "dmi,mi")))]
  ""
  "*
{
    if (REG_P(operands[0]) && (REGNO(operands[0]) == HARD_SP_REGNUM))
    {
	if ((GET_CODE(operands[2]) == CONST_INT) &&
	    (INTVAL(operands[2]) < 9))
	{
	    int	i;
	    for (i = 0; i < (INTVAL(operands[2]) - 1)/2; i++)
	    {
		output_asm_insn(\"PULX\", operands);
	    }
	    if ((INTVAL(operands[2]) % 2) == 0)
	    {
		output_asm_insn(\"PULX\\t\\t; addhi3: %0 by %2\", operands);
	    }
	    else
	    {
		output_asm_insn(\"PULB\\t\\t; addhi3: %0 by %2\", operands);
	    }
	}
	else
	{
	    output_asm_insn(\"TSX\", operands);
	    output_asm_insn(\"XGDX\", operands);
	    if (GET_CODE(operands[2]) == MEM)
	    {
		output_swap_regx(operands[2]);
	    }
	    output_asm_insn(\"ADDD\\t%2\", operands);
	    output_asm_insn(\"TXS\\t\\t; addhi3: %0 by %2\", operands);
	}
	return \"\";
    }

    output_asm_insn(\"LDD\\t%0\", operands);

    if (REG_P(operands[2]) && REGNO(operands[2]) == HARD_Y_REGNUM)
    {
	output_asm_insn(\"STY\\tZXT\", operands);
	output_asm_insn(\"ADDD\\tZXT\", operands);
    }			    
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"ADDD\\t%2\", operands);
    }
    output_asm_insn(\"STD\\t%0\\t; addhi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "addqi3"
  [(set (match_operand:QI 0 "general_operand" "=g")
        (plus:QI (match_operand:QI 1 "general_operand" "0")
                 (match_operand:QI 2 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }

    if (REG_P(operands[2]) && !Q_REGNO_P(REGNO(operands[2])))
    {
	output_asm_insn(\"ADDB\\t%2+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"ADDB\\t%2\", operands);
    }

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"STAB\\t%0+1\\t; addqi3: %0 by %2\", operands);
    }
    else
    {
	output_asm_insn(\"STAB\\t%0\\t; addqi3: %0 by %2\", operands);
    }

    return \"\";
}")

;;--------------------------------------------------------------------
;;- Subtract instructions.
;;--------------------------------------------------------------------

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(minus:SI (match_operand:SI 1 "register_operand" "0")
		 (match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    output_asm_insn(\"LDD\\t%0\", operands);
    if (REG_P(operands[2]) && REGNO(operands[2]) == HARD_Y_REGNUM)
    {
	output_asm_insn(\"STY\\tZXT\", operands);
	output_asm_insn(\"SUBD\\tZXT\", operands);
    }			    
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"SUBD\\t%2\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; subsi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "subhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=md")
	(minus:HI (match_operand:HI 1 "general_operand" "%0")
		  (match_operand:HI 2 "general_operand" "dmi")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\t%0\", operands);

    if (REG_P(operands[2]) && REGNO(operands[2]) == HARD_Y_REGNUM)
    {
	output_asm_insn(\"STY\\tZXT\", operands);
	output_asm_insn(\"SUBD\\tZXT\", operands);
    }			    
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"SUBD\\t%2\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; subhi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "subqi3"
  [(set (match_operand:QI 0 "general_operand" "=g")
        (minus:QI (match_operand:QI 1 "general_operand" "0")
                  (match_operand:QI 2 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }

    if (REG_P(operands[2]) && !Q_REGNO_P(REGNO(operands[2])))
    {
	output_asm_insn(\"SUBB\\t%2+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"SUBB\\t%2\", operands);
    }
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"STAB\\t%0+1\\t; subqi3: %0 by %2\", operands);
    }
    else
    {
	output_asm_insn(\"STAB\\t%0\\t; subqi3: %0 by %2\", operands);
    }

    return \"\";
}")

;;--------------------------------------------------------------------
;;- Multiply instructions.
;;--------------------------------------------------------------------

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (mult:SI (match_operand:SI 1 "register_operand" "0")
                 (match_operand:SI 2 "register_operand" "r")))]
  ""
  "*
{
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"LDAB\\t1+%0\", operands);
    output_asm_insn(\"LDAA\\t1+%2\", operands);
    output_asm_insn(\"MUL\", operands);
    output_asm_insn(\"STD\\tZXT\", operands);
    output_asm_insn(\"LDAB\\t%0\", operands);
    output_asm_insn(\"LDAA\\t1+%2\", operands);
    output_asm_insn(\"MUL\", operands);
    output_asm_insn(\"TBA\", operands);
    output_asm_insn(\"CLRB\", operands);
    output_asm_insn(\"ADDD\\tZXT\", operands);
    output_asm_insn(\"STD\\tZXT\", operands);
    output_asm_insn(\"LDAB\\t1+%0\", operands);
    output_asm_insn(\"LDAA\\t%2\", operands);
    output_asm_insn(\"MUL\", operands);
    output_asm_insn(\"TBA\", operands);
    output_asm_insn(\"CLRB\", operands);
    output_asm_insn(\"ADDD\\tZXT\", operands);
    output_asm_insn(\"STD\\t%0\\t; mulsi3: %0 by %2\", operands);

    return \"\";
}")

;;
;; NOTE: It would be better to make this a function call.
;;

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(mult:HI (match_operand:HI 1 "register_operand" "0")
		 (match_operand:HI 2 "nonimmediate_operand" "rm")))]
  ""
  "*
{
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"LDAB\\t1+%0\", operands);
    output_asm_insn(\"LDAA\\t1+%2\", operands);
    output_asm_insn(\"MUL\", operands);
    output_asm_insn(\"STD\\tZXT\", operands);
    output_asm_insn(\"LDAB\\t%0\", operands);
    output_asm_insn(\"LDAA\\t1+%2\", operands);
    output_asm_insn(\"MUL\", operands);
    output_asm_insn(\"TBA\", operands);
    output_asm_insn(\"CLRB\", operands);
    output_asm_insn(\"ADDD\\tZXT\", operands);
    output_asm_insn(\"STD\\tZXT\", operands);
    output_asm_insn(\"LDAB\\t1+%0\", operands);
    output_asm_insn(\"LDAA\\t%2\", operands);
    output_asm_insn(\"MUL\", operands);
    output_asm_insn(\"TBA\", operands);
    output_asm_insn(\"CLRB\", operands);
    output_asm_insn(\"ADDD\\tZXT\", operands);
    output_asm_insn(\"STD\\t%0\\t; mulhi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "mulqi3"
  [(set (match_operand:QI 0 "general_operand" "=g")
        (mult:QI (match_operand:QI 1 "general_operand" "0")
                 (match_operand:QI 2 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }
    if (REG_P(operands[2]) && !Q_REGNO_P(REGNO(operands[2])))
    {
	output_asm_insn(\"LDAA\\t%2+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDAA\\t%2\", operands);
    }
    output_asm_insn(\"MUL\", operands);

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	return \"STAB\\t%0+1\\t; mulqi3: %0 by %2\";
    }
    else
    {
	return \"STAB\\t%0\\t; mulqi3: %0 by %2\";
    }
}")

;;--------------------------------------------------------------------
;;- Divide instructions.
;;--------------------------------------------------------------------

(define_insn "udivmodsi4"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(udiv:SI (match_operand:SI 1 "register_operand" "0")
		(match_operand:SI 2 "general_operand" "dami")))
   (set (match_operand:SI 3 "register_operand" "=r")
	(umod:SI (match_dup 1) (match_dup 2)))]
  ""
  "*
{
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"XGDX\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);
    output_asm_insn(\"IDIV\", operands);
    output_asm_insn(\"STX\\t%0\", operands);
    return \"STD\\t%3\\t; udivmodsi4: %0 by %2, RMDR -> %3\";
}")

(define_insn "udivmodhi4"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(udiv:HI (match_operand:HI 1 "register_operand" "0")
		(match_operand:HI 2 "general_operand" "dami")))
   (set (match_operand:HI 3 "register_operand" "=r")
	(umod:HI (match_dup 1) (match_dup 2)))]
  ""
  "*
{
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"XGDX\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);
    output_asm_insn(\"IDIV\", operands);
    output_asm_insn(\"STX\\t%0\", operands);
    return \"STD\\t%3\\t; udivmodhi4: %0 by %2, RMDR -> %3\";
}")

(define_insn "udivmodqi4"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(udiv:QI (match_operand:QI 1 "register_operand" "0")
		(match_operand:QI 2 "general_operand" "dami")))
   (set (match_operand:QI 3 "register_operand" "=r")
	(umod:QI (match_dup 1) (match_dup 2)))]
  ""
  "*
{
    if (REG_P(operands[2]) && !Q_REGNO_P(REGNO(operands[2])))
    {
	output_asm_insn(\"LDAB\\t%2+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDAB\\t%2\", operands);
    }
    output_asm_insn(\"XGDX\", operands);
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }
    output_asm_insn(\"IDIV\", operands);
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"STX\\t%0+1\", operands);
    }
    else
    {
	output_asm_insn(\"STX\\t%0\", operands);
    }
    if (REG_P(operands[3]) && !Q_REGNO_P(REGNO(operands[3])))
    {
	return \"STD\\t%3+1\\t; udivmodqi4: %0 by %2, RMDR -> %3\";
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	return \"STD\\t%3\\t; udivmodqi4: %0 by %2, RMDR -> %3\";
    }
}")

;;--------------------------------------------------------------------
;;- and instructions.
;;--------------------------------------------------------------------

(define_insn "andsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(and:SI (match_operand:SI 1 "general_operand" "0")
		(match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM || GET_CODE(operands[2]) == CONST_INT)
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STD\\tZXT\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ANDA\\tZXT\", operands);
	output_asm_insn(\"ANDB\\tZXT+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }
    else
    {
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ANDA\\t%2\", operands);
	output_asm_insn(\"ANDB\\t%2+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; andsi3: %0 with %2\", operands);

    return \"\";
}")

(define_insn "andhi3"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(and:HI (match_operand:HI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM || GET_CODE(operands[2]) == CONST_INT)
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STD\\tZXT\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ANDA\\tZXT\", operands);
	output_asm_insn(\"ANDB\\tZXT+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }
    else
    {
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ANDA\\t%2\", operands);
	output_asm_insn(\"ANDB\\t%2+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; andhi3: %0 with %2\", operands);

    return \"\";
}")

(define_insn "andqi3"
  [(set (match_operand:QI 0 "general_operand" "=g")
        (and:QI (match_operand:QI 1 "general_operand" "0")
                (match_operand:QI 2 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"ANDB\\t%2\", operands);

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	return \"STAB\\t%0+1\\t; andqi3: %0 with %2\";
    }
    else
    {
	return \"STAB\\t%0\\t; andqi3: %0 with %2\";
    }
}")

;;--------------------------------------------------------------------
;;- Bit set or instructions.
;;--------------------------------------------------------------------

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(ior:SI (match_operand:SI 1 "general_operand" "0")
		(match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM || GET_CODE(operands[2]) == CONST_INT)
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STD\\tZXT\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ORAA\\tZXT\", operands);
	output_asm_insn(\"ORAB\\tZXT+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }
    else
    {
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ORAA\\t%2\", operands);
	output_asm_insn(\"ORAB\\t%2+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; iorsi3: %0 with %2\", operands);

    return \"\";
}")

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(ior:HI (match_operand:HI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM || GET_CODE(operands[2]) == CONST_INT)
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STD\\tZXT\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ORAA\\tZXT\", operands);
	output_asm_insn(\"ORAB\\tZXT+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }
    else
    {
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"ORAA\\t%2\", operands);
	output_asm_insn(\"ORAB\\t%2+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; iorhi3: %0 with %2\", operands);

    return \"\";
}")

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(ior:QI (match_operand:QI 1 "general_operand" "0")
		(match_operand:QI 2 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"ORAB\\t%2\", operands);

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	return \"STAB\\t%0+1\\t; iorqi3: %0 with %2\";
    }
    else
    {
	return \"STAB\\t%0\\t; iorqi3: %0 with %2\";
    }
}")

;;--------------------------------------------------------------------
;;- xor instructions.
;;--------------------------------------------------------------------

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(xor:SI (match_operand:SI 1 "general_operand" "0")
		(match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STD\\tZXT\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"EORA\\tZXT\", operands);
	output_asm_insn(\"EORB\\tZXT+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }
    else
    {
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"EORA\\t%2\", operands);
	output_asm_insn(\"EORB\\t%2+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; eorsi3: %0 with %2\", operands);

    return \"\";
}")

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(xor:HI (match_operand:HI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM || GET_CODE(operands[2]) == CONST_INT)
    {
	if (GET_CODE(operands[2]) == MEM)
	{
	    output_swap_regx(operands[2]);
	}
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STD\\tZXT\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"EORA\\tZXT\", operands);
	output_asm_insn(\"EORB\\tZXT+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }
    else
    {
	output_asm_insn(\"LDD\\t%0\", operands);
	output_asm_insn(\"EORA\\t%2\", operands);
	output_asm_insn(\"EORB\\t%2+1\", operands);
	output_asm_insn(\"ADDD\\t#0\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; eorhi3: %0 with %2\", operands);

    return \"\";
}")

(define_insn "xorqi3"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(xor:QI (match_operand:QI 1 "general_operand" "0")
		(match_operand:QI 2 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }

    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }
    output_asm_insn(\"EORB\\t%2\", operands);

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	return \"STAB\\t%0+1\\t; xorqi3: %0 with %2\";
    }
    else
    {
	return \"STAB\\t%0\\t; xorqi3: %0 with %2\";
    }
}")

;;--------------------------------------------------------------------
;;-  Complements
;;--------------------------------------------------------------------

(define_insn "negsi2"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(neg:SI (match_operand:SI 1 "general_operand" "0")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }

    output_asm_insn(\"LDD\\t#0\", operands);
    output_asm_insn(\"SUBD\\t%0\", operands);
    output_asm_insn(\"STD\\t%0\\t; negsi2: %0\", operands);

    return \"\";
}")

(define_insn "neghi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(neg:HI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }

    output_asm_insn(\"LDD\\t#0\", operands);
    output_asm_insn(\"SUBD\\t%0\", operands);
    output_asm_insn(\"STD\\t%0\\t; neghi2: %0\", operands);

    return \"\";
}")

(define_insn "negqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(neg:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }

    output_asm_insn(\"NEGB\\t%0\", operands);

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	return \"STAB\\t%0+1\\t; negqi2: %0\";
    }
    else
    {
	return \"STAB\\t%0\\t; negqi2: %0\";
    }
}")

;;--------------------------------------------------------------------
;;-  
;;--------------------------------------------------------------------

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(not:SI (match_operand:SI 1 "general_operand" "0")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }

    output_asm_insn(\"LDD\\t%0\", operands);
    output_asm_insn(\"COMA\", operands);
    output_asm_insn(\"COMB\", operands);
    output_asm_insn(\"ADDD\\t#0\", operands);
    output_asm_insn(\"STD\\t%0\\t; one_cmplsi2: %0\", operands);

    return \"\";
}")

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(not:HI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }

    output_asm_insn(\"LDD\\t%0\", operands);
    output_asm_insn(\"COMA\", operands);
    output_asm_insn(\"COMB\", operands);
    output_asm_insn(\"ADDD\\t#0\", operands);
    output_asm_insn(\"STD\\t%0\\t; one_cmplhi2: %0\", operands);

    return \"\";
}")

(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(not:QI (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	output_asm_insn(\"LDAB\\t%0+1\", operands);
    }
    else
    {
	if (GET_CODE(operands[0]) == MEM)
	{
	    output_swap_regx(operands[0]);
	}
	output_asm_insn(\"LDAB\\t%0\", operands);
    }

    output_asm_insn(\"COMB\", operands);

    if (REG_P(operands[0]) && !Q_REGNO_P(REGNO(operands[0])))
    {
	return \"STAB\\t%0+1\\t; one_cmplqi2: %0\";
    }
    else
    {
	return \"STAB\\t%0\\t; one_cmplqi2: %0\";
    }
}")

;;--------------------------------------------------------------------
;;- arithmetic shifts
;;--------------------------------------------------------------------

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(ashift:SI (match_operand:SI 1 "general_operand" "0")
	           (match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+12\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"ASLD\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-4\", operands);

    output_asm_insn(\"STD\\t%0\\t; ashlsi3: %0 by %2\", operands);

    return \"\";
}")

;;
;; NOTE: I don't know why a simple general_operand can't work here, but
;;	 allocate_reload_reg() fails when I try it.
;;
(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=mr")
	(ashift:HI (match_operand:HI 1 "nonimmediate_operand" "%0")
	           (match_operand:HI 2 "general_operand" "dmi")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    if ((GET_CODE(operands[2]) == CONST_INT) && (INTVAL(operands[2]) < 8))
    {
	int	i;
	output_asm_insn(\"LDD\\t%0\", operands);
	for (i = 0; i < INTVAL(operands[2]); i++)
	{
	    output_asm_insn(\"ASLD\", operands);
	}
    }
    else
    {
	output_asm_insn(\"LDD\\t%2\", operands);
	output_asm_insn(\"STAB\\tZXT\", operands);
	output_asm_insn(\"BLE\\t*+12\", operands);
	output_asm_insn(\"LDD\\t%0\", operands);

	output_asm_insn(\"ASLD\", operands);
	output_asm_insn(\"DEC\\tZXT\", operands);
	output_asm_insn(\"BNE\\t*-4\", operands);
    }

    output_asm_insn(\"STD\\t%0\\t; ashlhi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(ashiftrt:SI (match_operand:SI 1 "general_operand" "0")
	             (match_operand:SI 2 "general_operand" "g")))
   (clobber (match_dup  2))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+13\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"ASRA\", operands);
    output_asm_insn(\"RORA\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-5\", operands);

    output_asm_insn(\"STD\\t%0\\t; ashrsi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "ashrhi3"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(ashiftrt:HI (match_operand:HI 1 "general_operand" "0")
	             (match_operand:HI 2 "general_operand" "g")))
   (clobber (match_dup  2))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+13\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"ASRA\", operands);
    output_asm_insn(\"RORB\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-5\", operands);

    output_asm_insn(\"STD\\t%0\\t; ashrhi3: %0 by %2\", operands);

    return \"\";
}")

;;--------------------------------------------------------------------
;; logical shift instructions
;;--------------------------------------------------------------------

(define_insn "lshlsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(lshift:SI (match_operand:SI 1 "general_operand" "0")
	           (match_operand:SI 2 "general_operand" "g")))
   (clobber (match_dup  2))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+12\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"LSLD\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-4\", operands);

    output_asm_insn(\"STD\\t%0\\t; lshlsi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "lshlhi3"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(lshift:HI (match_operand:HI 1 "general_operand" "0")
		   (match_operand:HI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+12\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"LSLD\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-4\", operands);

    output_asm_insn(\"STD\\t%0\\t; lshlhi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(lshiftrt:SI (match_operand:SI 1 "general_operand" "0")
		     (match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+12\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"LSRD\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-4\", operands);

    output_asm_insn(\"STD\\t%0\\t; lshrsi3: %0 by %2\", operands);

    return \"\";
}")

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(lshiftrt:HI (match_operand:HI 1 "general_operand" "0")
		     (match_operand:HI 2 "general_operand" "g")))]
  ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    if (GET_CODE(operands[2]) == MEM)
    {
	output_swap_regx(operands[2]);
    }

    output_asm_insn(\"LDD\\t%2\", operands);
    output_asm_insn(\"STAB\\tZXT\", operands);
    output_asm_insn(\"BLE\\t*+12\", operands);
    output_asm_insn(\"LDD\\t%0\", operands);

    output_asm_insn(\"LSRD\", operands);
    output_asm_insn(\"DEC\\tZXT\", operands);
    output_asm_insn(\"BNE\\t*-4\", operands);

    output_asm_insn(\"STD\\t%0\\t; lshrhi3: %0 by %2\", operands);

    return \"\";
}")

;;--------------------------------------------------------------------
;;-  Jumps and transfers
;;--------------------------------------------------------------------
(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"BRA\\t%l0\", operands);
    else
	output_asm_insn (\"JMP\\t%l0\", operands);
    return \"\";
}")

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BEQ\\t%l0\\t; (beq) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BNE\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (beq) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BNE\\t%l0\\t; (bne) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BEQ\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bne) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BGT\\t%l0\\t; (bgt) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLE\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bgt) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BHI\\t%l0\\t; (bgtu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLS\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bgtu) long branch\", operands);
    }
    return \"\";
}")

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLT\\t%l0\\t; (blt) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BGE\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (blt) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLO\\t%l0\\t; (bltu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BHS\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bltu) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BGE\\t%l0\\t; (bge) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLT\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bge) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BHS\\t%l0\\t; (bgeu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLO\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bgeu) long branch\", operands);
    }
    return \"\";
}")

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLE\\t%l0\\t; (ble) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BGT\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (ble) long branch\", operands);
    }
    return \"\";
}")

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLS\\t%l0\\t; (bleu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BHI\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (bleu) long branch\", operands);
    }
    return \"\";
}")

;;--------------------------------------------------------------------
;;- Negative test and branch
;;--------------------------------------------------------------------
(define_insn ""
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BNE\\t%l0\\t; (rev beq) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BEQ\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev beq) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BEQ\\t%l0\\t; (rev bne) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BNE\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bne) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLE\\t%l0\\t; (rev bgt) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BGT\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bgt) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLS\\t%l0\\t; (rev bgtu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BHI\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bgtu) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BGE\\t%l0\\t; (rev blt) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLT\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev blt) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BHS\\t%l0\\t; (rev bltu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLO\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bltu) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLT\\t%l0\\t; (rev bge) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BGE\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bge) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BLO\\t%l0\\t; (rev bgeu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BHS\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bgeu) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BGT\\t%l0\\t; (rev ble) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLE\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev ble) long branch\", operands);
    }
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
    {
	output_asm_insn (\"BHI\\t%l0\\t; (rev bleu) short branch\", operands);
    }
    else
    {
	output_asm_insn (\"BLS\\t*+5\", operands);
	output_asm_insn (\"JMP\\t%l0\\t; (rev bleu) long branch\", operands);
    }
    return \"\";
}")

;;--------------------------------------------------------------------
;;-  Calls
;;--------------------------------------------------------------------
;;
;; arg count word may be omitted to save a push and let gcc try to
;; combine the arg list pop.  RETURN_POPS_ARGS from tm.h decides this.

;;
;; Note: The load and store into ZD0 is a temp workaround for interfacing to
;;	 other compilers.
;;
;;- Call a function that returns no value.
(define_insn "call"
  [(call (match_operand:HI 0 "general_operand" "g")
	 (match_operand:SI 1 "general_operand" "g"))]
  ""
 "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\tZD0\", operands);
    output_asm_insn(\"JSR\\t%0\\t; CALL: (VOIDmode) %0 (%a1 bytes)\", operands);
    output_asm_insn(\"STD\\tZD0\", operands);

    return \"\";
}")

(define_insn "call_value"
  [(set (match_operand 0 "" "=g")
	(call (match_operand:HI 1 "general_operand" "g")
	      (match_operand:SI 2 "general_operand" "g")))]
  ""
 "*
{
    if (GET_CODE(operands[1]) == MEM)
    {
	output_swap_regx(operands[1]);
    }
    output_asm_insn(\"LDD\\tZD0\", operands);
    output_asm_insn(\"JSR\\t%1\\t; CALL: R:%0 = %1 (%a2 bytes)\", operands);
    output_asm_insn(\"STD\\tZD0\", operands);

    return \"\";
}")

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")
    
;;
;; I have no idea, stole it from m68k.md
;;
(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "a"))]
  ""
  "*
  return \"JMP %0@\";
")

;;--------------------------------------------------------------------
;;-  Table jump
;;--------------------------------------------------------------------
;;
;; Operand 0 is the address of the table element to use
;; operand 1 is the CODE_LABEL for the table
;;--------------------------------------------------------------------
(define_insn "tablejump"
   [(parallel [
	(set (pc) (match_operand 0 "general_operand" "g"))
	(use (label_ref (match_operand 1 "" "")))])]
   ""
  "*
{
    if (GET_CODE(operands[0]) == MEM)
    {
	output_swap_regx(operands[0]);
    }
    output_asm_insn(\"LDD\\t%0\", operands);
    output_asm_insn(\"XGDX\\t\", operands);
    return \"JMP\\t0,X\\t; tablejump (table name %1, addr %0)\";
}")

;;--------------------------------------------------------------------
;;- Peepholes
;;- TBD
;;--------------------------------------------------------------------

;; Optimize the case of following a register load with a test
;; of reg just moved.

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "memory_operand" "m"))
   (set (cc0) (match_operand:SI 2 "register_operand" "r"))]
  "operands[2] == operands[0]"
    ".bogus\\t\\t; (peephole) movsi: %1 -> R:%0 w/ implied test of %2")

;; Optimize the case of following a register store with a test
;; of reg or mem just moved.

(define_peephole
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(match_operand:HI 1 "register_operand" "r"))
   (set (cc0) (match_operand:HI 2 "general_operand" "g"))]
  "operands[2] == operands[0] || operands[2] == operands[1]"
    ".bogus\\t\\t; (peephole) movhi: R:%1 -> %0 w/ implied test of %2")
    
;; Optimize the (strange) case of following an SI register store
;; with a load of the reg just moved.
(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "register_operand" "r"))
  (set (match_operand:SI 2 "register_operand" "=r")
	(match_operand:SI 3 "memory_operand" "m"))]
  "operands[0] == operands[3] && operands[1] == operands[2]"
    ".bogus\\t\\t; (peephole) movsi: R:%1 -> %0 w/ redundant move of %3 -> %2")
    
;; Optimize the (strange) case of following an HI register store
;; with a load of the reg just moved.
(define_peephole
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(match_operand:HI 1 "register_operand" "r"))
  (set (match_operand:HI 2 "register_operand" "=r")
	(match_operand:HI 3 "memory_operand" "m"))]
  "operands[0] == operands[3] && operands[1] == operands[2]"
    ".bogus\\t\\t; (peephole) movhi: R:%1 -> %0 w/ redundant move of %3 -> %2")
    
;;- Local variables:
;;- mode:emacs-lisp
;;- comment-start: ";;- "
;;- eval: (set-syntax-table (copy-sequence (syntax-table)))
;;- eval: (modify-syntax-entry ?[ "(]")
;;- eval: (modify-syntax-entry ?] ")[")
;;- eval: (modify-syntax-entry ?{ "(}")
;;- eval: (modify-syntax-entry ?} "){")
;;- End:
