%{
#undef input()
%}
%%
;[\t\40-\176]*$	return(COMMENT);
nop		return(NOP);
adc		return(ADC);
add		return(ADD);
and		return(AND);
call		return(CALL);
jp		return(JP);
byte		return(BYTE);

[a-z][a-z0-9]*  {
			if(is_symb(yytext))
			{ 
				if (symb_has(yytext))
				{
					yylval = symb_val(yytext);
					return(NUMBER);
				}
				else
				{
					yylval = symb_to_indx(yytext);
					return(NAME);
				}
			}
			yylval = add_symb(yytext);
			return(NAME);
		}
[ \t]	;
[\n]		{
			linenum++ ;
			return('\n');
		}
0[0-7]+		{
			yylval = aton(yytext,8);
			return(NUMBER);
		}
[1-9][0-9]*	{
			yylval = aton(yytext,10);
			return(NUMBER);	
		}
0[x][0-9a-f]+	{
			yylval = aton(yytext+2,16);
			return(NUMBER);
		}
"."		return(DOT);
":"		return(':');
"+"		return('+');
","		return(',');
"="		return('=');
"@"		return('@');
"#"		return('#');
%%
input()
{
	return(((yytchar=yysptr>yysbuf?U(*--yysptr):mygetc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar);
}

mygetc(ptr)
FILE *ptr;
{
	linebuf[linelen++] = getc(ptr);
	linebuf[linelen] = '\0';
	return(linebuf[linelen-1]);
}

aton(ptr,radix)
char *ptr;
int radix;
{
	int tmp = 0;
	while (*ptr != '\0')
	{
		switch (*ptr)
		{
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				tmp = (tmp*radix)+  (*ptr - '0');
				break;
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
				tmp = (tmp*radix) + (*ptr - 'a');
				break;
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
				tmp = (tmp*radix) + (*ptr - 'A');
				break;
			default:
				fprintf(stderr,
					"panic - weird char in number\n");
		}
		ptr++;
	}
	return(tmp);
}
