;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : LOGIC.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : Logic Probe Code
;**           :
;****************************************************************
;
	SEG REGS
TIMER:	 .DS 1		;utility countdown timer
WV_TIME: .DS 1		;trace timer

	SEG CODE
;**********************************************************************
;* 
;* Pseudo-interrupt called from the TICKER interrupt process
;* 
;**********************************************************************

I_LOGIC:
	btfss	B.NEWLOGIC	;execute only on first logic cycle
	GOTO	_il_020		;not first state
	clb	B.NEWLOGIC	;clear logic bit
	decfsz	TIMER		;delay
	GOTO	TICK_EXIT	;tick interrupt exit code
	clb	B.PULSE2	;timeout pulse detect
	GOTO	TICK_EXIT	;tick interrupt exit code

_il_020:		;not first state
	movfw	VSENSE		;get voltage
	btfsc	B.CLOCK		;check clock phase
	goto	_il_030		;Clock is HIGH
	addwf	VSENSEL		;average into result
	rrf	VSENSEL         ;OLD+NEW/2
	GOTO	_il_tick	;logic tick
	
_il_030:			;Clock is HIGH
	addwf	VSENSEH		;average into result
	rrf	VSENSEH		;OLD+NEW/2

_il_tick:	;logic tick - process pattern
	bbc	B.PULSE,_il_wtrig ;wait for trigger
	decfsz	WV_TIME		;wait 1 sample period
	goto	TICK_EXIT	;done!

_il_wtrig:
	movfw	VALUE+0		;setup delay for next samp
	movwf	WV_TIME		;sample timer
	rrf	port(B.PROBE),w	;get data bit into CY
	btfsc	B.SLOPE		;skip if slope is POSITIVE
	comf    LOGICPAT        ;invert internal pattern for neg slope
	rlf	LOGICPAT	;make pattern of last 8 samples
	movfw	LOGICPAT	;check pattern
	btfsc	B.SLOPE		;skip if slope is POSITIVE
	comf    LOGICPAT        ;invert internal pattern for neg slope
	skpnz
	GOTO	_il_steady	;constant 0
	xorlw	$FF		;check for 1
	skpnz
	GOTO	_il_steady	;constant 1
	SEB	B.PULSE		;FLAG PULSE DETECT
	SEB	B.PULSE2	;FLAG PULSE DETECT
	clrf	TIMER		;reset time since last pulse
	GOTO	TICK_EXIT


_il_steady:	;constant level
	btfss	B.PULSE2		;if we have been steady for a while...
	clb	B.PULSE		;cancel 'PULSE'
	goto	TICK_EXIT	;done






