/*
 * time.h
 * 
 * Struct and function declarations for dealing with time.
 */

#ifndef __TIME_H
#define __TIME_H
#include <_ansi.h>

#ifndef NULL
#define	NULL	0
#endif
#define CLOCKS_PER_SEC 1000		/* Machine dependent */

#define __need_size_t
#include <stddef.h>

#include <machine/types.h>

#ifdef	_CLOCK_T_
#ifndef __clock_t_defined
typedef	_CLOCK_T_ clock_t;
#define __clock_t_defined
#endif
#undef	_CLOCK_T_
#endif

#ifdef	_TIME_T_
typedef	_TIME_T_ time_t;
#undef	_TIME_T_
#endif

struct tm
{
  int	tm_sec;
  int	tm_min;
  int	tm_hour;
  int	tm_mday;
  int	tm_mon;
  int	tm_year;
  int	tm_wday;
  int	tm_yday;
  int	tm_isdst;
};


clock_t	   _EXFUN(clock,    (void));
double	   _EXFUN(difftime, (time_t time2, time_t time1));
time_t	   _EXFUN(mktime,   (struct tm *timeptr));
time_t	   _EXFUN(time,     (time_t *timer));
char	  *_EXFUN(asctime,  (const struct tm *tblock));
char	  *_EXFUN(ctime,    (const time_t *time));
struct tm *_EXFUN(gmtime,    (const time_t *timer));
struct tm *_EXFUN(localtime, (const time_t *timer));
size_t	   _EXFUN(strftime,  (char *s, size_t maxsize, const char *fmt, const struct tm *t));

#endif
