;;-------------------------------------------------------------------
;; FILE: m6809.md
;; SCCS: @(#)m6809.md	1.2 SAL 1/22/92
;;-------------------------------------------------------------------
;;- Machine description for GNU compiler
;;-
;;- MC6809 Version by Tom Jones (jones@sal.wisc.edu)
;;- Space Astronomy Laboratory
;;- University of Wisconsin at Madison
;;-
;;   Copyright (C) 1989 Free Software Foundation, Inc.

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;;- Instruction patterns.  When multiple patterns apply,
;;- the first one in the file is chosen.
;;-
;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;-
;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

;; Put tstsi first among test insns so it matches a CONST_INT operand.

;;--------------------------------------------------------------------
;;-  Test
;;--------------------------------------------------------------------

(define_insn "tstsi"
  [(set (cc0)
	(match_operand:SI 0 "register_operand" "r"))]
  ""
 "cmp%0\\t#0\\t;tstsi: R:%0")

(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "byte_operand" "qm"))]
  ""
 "*
{
    if (GET_CODE (operands[0]) == MEM)
	return \"tst\\t%0\\t;tsthi: MEM:%0\";
    else
	return \"tst%0\\t\\t;tsthi: R:%0\";
}")

;;--------------------------------------------------------------------
;;- Compare
;;--------------------------------------------------------------------
;; Put cmpsi first among compare insns so it matches two CONST_INT operands.


;;- cmpsi for register to memory or register compares
(define_insn "cmpsi"
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r,g,??r")
		 (match_operand:SI 1 "general_operand" "g,r,r")))]
  ""
  "*
{
    if ((REG_P (operands[0])) && (REG_P (operands[1]))) {
	output_asm_insn (\"pshs\\t%1\\t;cmpsi: R:%1 with R:%0\", operands);
	return \"cmp%0\\t,s++\\t;cmpsi:\";
    }
    if (GET_CODE (operands[0]) == REG)
	return \"cmp%0\\t%1\\t;cmpsi:\";
    else {
	cc_status.flags |= CC_REVERSED;
	return \"cmp%1\\t%0\\t;cmpsi:(R)\";
    }
}")

(define_insn "cmphi"
  [(set (cc0)
	(compare (match_operand:HI 0 "byte_operand" "q,mK")
		 (match_operand:HI 1 "byte_operand" "mK,q")))]
  ""
  "*
{
    if (GET_CODE (operands[0]) == REG)
      return \"cmp%0\\t%1\\t;cmphi:\";
    else {
      cc_status.flags |= CC_REVERSED;
      return \"cmp%1\\t%0\\t;cmphi:(R)\";
    }
}")

;;--------------------------------------------------------------------
;;-  Move
;;--------------------------------------------------------------------

(define_insn "movdi"
  [(set (match_operand:DI 0 "memory_operand" "=m")
	(match_operand:DI 1 "memory_operand"  "m"))]
  ""
  "*
{
    return \".bogus ;movdi: %1 -> %0\";
}")

(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=r,r,mi")
	(match_operand:SI 1 "general_operand"  "r,mi,r"))]
  ""
  "*
{
    if (REG_P (operands[0])) {

	if (REG_P (operands[1])) {
	    if (REGNO (operands[0]) != REGNO (operands[1]))
		return \"tfr\\t%1,%0\\t;movsi: R:%1 -> R:%0\";
	    else
		return \";redundant movsi: R:%1 -> R:%0\";
	}

	if ((operands[1] == const0_rtx) && (D_REG_P (operands[0])))
	    return \"clra\\t\\t;movsi: ZERO -> R:%0\;clrb\";
	else
	    return \"ld%0\\t%1\\t;movsi: %1 -> R:%0\";
    }

    if ((push_operand (operands[0], SImode))
	&& (REG_P (operands[1])))
	    return \"pshs\\t%1\\t;movsi: push R:%1\";

    if (REG_P (operands[1]))
	return \"st%1\\t%0\\t;movsi: R:%1 -> %0\";

    return \".bogus ;movsi: %1 -> %0\";
}")

;;- set high byte of 16-bit word
(define_insn ""
  [(set (match_operand:HI 0 "byte_operand" "=q,q,m")
      (subreg:HI (match_operand:SI 1 "general_operand" "d,m,d") 1))]
  ""
  "*
{
  if (REG_P (operands[0]) && (operands[1] == const0_rtx))
    return \"clr%0\\t\\t;movmsb:\";
  if ((REG_P (operands[0])) && (D_REG_P (operands[1])))
    return \"tfr\\ta,%0\\t;movmsb:\";
  if (D_REG_P (operands[1]) && (GET_CODE (operands[0]) == MEM))
    return \"sta\\t%0\\t;movmsb:\";
  if (REG_P (operands[0]) && (GET_CODE (operands[1]) == MEM))
    return \"ld%0\\t%1\\t;movmsb:\";
  else
    return \".bogus ;movmsb: %1 -> %0\";
}")

;;- set low byte of 16-bit word
(define_insn ""
  [(set (match_operand:HI 0 "byte_operand" "=q,q,m")
      (subreg:HI (match_operand:SI 1 "general_operand" "d,m,d") 0))]
  ""
  "*
{
  if (REG_P (operands[0])) {
	if (operands[1] == const0_rtx)
	    return \"clr%0\\t\\t;movlsb: ZERO -> R:%0\";
	if (D_REG_P (operands[1]))
	    return \"tfr\\tb,%0\\t;movlsb: R:%1 -> R:%0\";
	if (GET_CODE (operands[1]) == MEM)
	    return \"ld%0\\t%L1\\t;movlsb: %1 -> R:%0\";
  }
  if (D_REG_P (operands[1]) && (GET_CODE (operands[0]) == MEM))
    return \"stb\\t%0\\t;movlsb: R:%1 -> %0\";
  else
    return \".bogus ;movlsb: %1 -> %0\";
}")

(define_insn "movstricthi"
  [(set (strict_low_part
      (subreg:HI (match_operand:SI 0 "general_operand" "d,m,d") 0))
	(match_operand:HI 1 "byte_operand" "q,q,m"))]
  ""
  "*
{
  if (REG_P (operands[0])) {
    if (operands[1] == const0_rtx)
	return \"clrb\\t\\t;movstricthi: ZERO -> R:%0\";
    if (REG_P (operands[1]))
	return \"tfr\\t%1,b\\t;movstricthi: R:%1 -> R:%0\";
    else
	return \"ldb\\t%L1\\t;movstricthi: %1 -> R:%0\";
  }
  if (REG_P (operands[1]) && (GET_CODE (operands[0]) == MEM))
    return \"stb\\t%L0\\t;movstricthi: R:%1 -> %0\";
  else
    return \".bogus ;movstricthi: %1 -> %0\";
}")

;;- movhi
(define_insn "movhi"
  [(set (match_operand:HI 0 "byte_operand" "=q,q,mi")
	(match_operand:HI 1 "byte_operand" "q,mi,q"))]
  ""
  "*
{
    if (REG_P (operands[0])) {
	if (REG_P (operands[1])) {
	    if (REGNO (operands[0]) != REGNO (operands[1]))
		return \"tfr\\t%1,%0\\t;movhi: R:%1 -> R:%0\";
	    else
		return \";redundant movhi: R:%1 -> R:%0\";
	}

	if (operands[1] == const0_rtx)
	    return \"clr%0\\t\\t;movhi: ZERO -> R:%0\";
	else
	    return \"ld%0\\t%1\\t;movhi: %1 -> R:%0\";
    }

    if (GET_CODE (operands[1]) == REG)
	return \"st%1\\t%0\\t;movhi: R:%1 -> %0\";

    if ((push_operand (operands[0], HImode))
	&& (GET_CODE (operands[1]) == REG))
	return \"pshs\\t%0\\t;movhi: push R:%0\";
    else
	return \".bogus ;movhi: %1 -> %0\";
}")

(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(match_operand:QI 1 "general_operand"  "g"))]
  ""
  "*
{
    return \".bogus ;movqi: %1 -> %0\";
}")

;;--------------------------------------------------------------------
;;-  Swap registers
;;--------------------------------------------------------------------
(define_insn "swapsi"
  [(set (match_operand:SI 0 "register_operand" "+r")
	(match_operand:SI 1 "register_operand" "+r"))
   (set (match_dup 1) (match_dup 0))]
  ""
  "exg\\t%1,%0\\t;swapsi: R:%1 <-> R:%0")

(define_insn "swaphi"
  [(set (match_operand:HI 0 "byte_reg_operand" "+q")
	(match_operand:HI 1 "byte_reg_operand" "+q"))
   (set (match_dup 1) (match_dup 0))]
  ""
  "exg\\t%1,%0\\t;swaphi: R:%1 <-> R:%0")

;;--------------------------------------------------------------------
;;-  Extension and truncation insns.
;;--------------------------------------------------------------------
;; Those for integer source operand
;; are ordered widest source type first.

;;- Use this pattern to match the insn for variable subscripts.

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "=d,g")
	(sign_extend:SI (match_operand:HI 1 "general_operand" "q,g")))]
    ""
    "
{
    rtx breg;
    rtx dreg;
    rtx sint;

    breg = gen_rtx (REG, HImode, 0);
    dreg = gen_rtx (REG, SImode, 0);
    emit_insn (gen_rtx (SET, HImode, breg, operands[1]));
    sint = (gen_rtx (SIGN_EXTEND, SImode, breg));
    emit_insn (gen_rtx (SET, SImode, dreg, sint));

    /*** assume extended value is in R0 ***/
    if (!D_REG_P (operands[0])) {
	emit_move_insn (operands[0], gen_rtx (REG, SImode, 0));
    }
    DONE;
}")

(define_insn ""
  [(set (match_operand:SI 0 "data_reg_operand" "=d")
	(sign_extend:SI (match_operand:HI 1 "byte_reg_operand" "q")))]
  ""
  "*
{
    if (REG_P (operands[1])) {
	if (REGNO (operands[1]) == 8)
	    output_asm_insn (\"tfr\\ta,b\\t;extendhisi: R:%1 -> R:%0\;sex\", operands);
	else
	    output_asm_insn (\"sex\\t\\t;extendhisi: R:%1 -> R:%0\", operands);
    }
    else {
	output_asm_insn (\"ldb\\t%1\\t;extendhisi: %1 -> R:%0\;sex\", operands);
    }
    return \"\";
}")

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "=d,m,?m")
	(const_int 0))
   (set (strict_low_part (subreg:HI (match_dup 0) 0))
	(match_operand:HI 1 "general_operand" "qm,q,m"))]
  ""
  "*
{
    if (D_REG_P (operands[0])) {
	if (REG_P (operands[1])) {
	    if (REGNO (operands[1]) == 8)
		output_asm_insn (\"tfr\\ta,b\", operands);
	    return \"clra\\t\\t;zero_extendhisi: R:%1 -> R:%0\";
	}
	if (GET_CODE (operands[1]) == MEM)
	    return \"ldb\\t%1\\t;zero_extendhisi: %1 -> R:d\;clra\";
    }

    if ((REG_P (operands[1])) && (GET_CODE (operands[0]) == MEM))
	return \"clr\\t%0\\t;zero_extendhisi: R:%1 -> %0\;st%1\\t%L0\";

    if ((GET_CODE (operands[0]) == MEM) && (GET_CODE (operands[1]) == MEM)) {
	return \"clr\\t%0\\t;zero_extendhisi: R:%1 -> %0\;lda\\t%1\;sta\\t%L0\";
    }
    else
	return \".bogus ;zero_extendhisi: %1 -> %0\";
}")

;;--------------------------------------------------------------------
;;-  Fix-to-float conversion insns.
;;--------------------------------------------------------------------
;; Note that the ones that start with SImode come first.
;; That is so that an operand that is a CONST_INT
;; (and therefore lacks a specific machine mode).
;; will be recognized as SImode (which is always valid)
;; rather than as HImode or QImode.


;;--------------------------------------------------------------------
;;-  Float-to-fix conversion insns.
;;--------------------------------------------------------------------


;;--------------------------------------------------------------------
;;- All kinds of add instructions.
;;--------------------------------------------------------------------

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,a")
	(plus:SI (match_operand:SI 1 "register_operand" "%0,a")
		 (match_operand:SI 2 "general_operand" "mi,id")))]
  ""
  "*
{
    if (D_REG_P (operands[0])) {
	return \"add%0\\t%2\\t;addsi: R:%0 += %2\";
    }
    if ((A_REG_P (operands[0])) && (D_REG_P (operands[2])))
	return \"lea%0\\t%2,%1\\t;addsi: R:%0 = R:%1 + R:%2\";
    else
	return \"lea%0\\t%a2,%1\\t;addsi: R:%0 = R:%1 + %2\";
}")

(define_insn "addhi3"
  [(set (match_operand:HI 0 "byte_operand" "=q,m")
	(plus:HI (match_operand:HI 1 "byte_operand" "%0,0")
		 (match_operand:HI 2 "general_operand" "mi,I")))]
  ""
  "*
{
    if ((GET_CODE (operands[0]) == MEM) && (operands[2] == const1_rtx))
	return \"inc\\t%0\\t;addhi: %0 += 1\";
    if ((GET_CODE (operands[0]) == REG) && (operands[2] == const1_rtx))
	return \"inc%0\\t\\t;addhi: R:%0 += 1\";
    else
	return \"add%0\\t%2\\t;addhi: R:%0 += %2\";
}")

;;--------------------------------------------------------------------
;;- Subtract instructions.
;;--------------------------------------------------------------------
(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,a")
	(minus:SI (match_operand:SI 1 "register_operand" "0,0")
		 (match_operand:SI 2 "general_operand" "mi?r,i")))]
  ""
  "*
{
    if ((D_REG_P (operands[0])) && (REG_P (operands[2]))) {
	output_asm_insn (\"pshs\\t%2\\t;subsi: R:%0 -= R:%2\", operands);
	return \"sub%0\\t,s++\";
    }
    if (D_REG_P (operands[0])) {
	return \"sub%0\\t%2\\t;subsi: R:%0 -= %2\";
    }
    else
	return \"lea%0\\t%n2,%1\\t;subsi: R:%0 = R:%1 + %n2\";
}")


(define_expand "subgen"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(minus:SI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:SI 2 "general_operand" "g")))]
    ""
    "
{
    rtx sum;

    sum = (gen_rtx (PLUS, SImode, operands[1],
	negate_rtx (SImode, operands[2])));
    emit_insn (gen_rtx (SET, SImode, operands[0], sum));
    DONE;
}")
    
(define_expand "subhi3"
  [(set (match_operand:HI 0 "register_operand" "=d")
	(minus:HI (match_operand:HI 1 "register_operand" "0")
		 (match_operand:HI 2 "address_operand" "min")))]
    ""
    "
{
    rtx sum;

    if ((D_REG_P (operands[0])) && (GET_CODE (operands[2]) == MEM)) {
	emit_insn (gen_subq (operands[0], operands[1], operands[2]));
    }
    else {
	sum = (gen_rtx (PLUS, HImode, operands[1],
	    negate_rtx (HImode, operands[2])));
	emit_insn (gen_rtx (SET, HImode, operands[0], sum));
    }
    DONE;
}")
    
(define_insn "subq"
  [(set (match_operand:HI 0 "register_operand" "=q")
	(minus:HI (match_operand:HI 1 "register_operand" "0")
		  (match_operand:HI 2 "address_operand" "min")))]
  ""
  "*
{
    if (operands[2] == const1_rtx)
	return \"dec%0\\t\\t;subhi: R:%0 -= 1\";
    else
      return \"sub%0\\t%2\\t;subhi: R:%0 -= %2\";
}")

;;--------------------------------------------------------------------
;;- Multiply instructions.
;;--------------------------------------------------------------------

;;-(define_expand "mulsi3"
;;-  [(set (match_operand:SI 0 "register_operand" "=d")
;;-	(mult:SI (match_operand:SI 1 "register_operand" "0")
;;-		(match_operand:SI 2 "register_operand" "a")))]
;;-  ""
;;-  "
;;-{
;;-    emit_insn (gen_call_lib (
;;-	gen_rtx (SYMBOL_REF, Pmode, \"mul_si\"),
;;-	operands[0], operands[1], operands[2]));
;;-    DONE;
;;-}")

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "=q")
	(mult:HI (match_operand:HI 1 "register_operand" "%0")
		 (match_operand:HI 2 "byte_operand" "m")))]
  ""
  "*
{
    output_asm_insn (\"lda\\t%2\\t;mulhi: R:%0 = R:%0 * %2\", operands);
    return \"mul\";
}")

;;--------------------------------------------------------------------
;;- Divide instructions.
;;--------------------------------------------------------------------

;;-(define_expand "divsi3"
;;-  [(set (match_operand:SI 0 "data_reg_operand" "=d")
;;-	(div:SI (match_operand:SI 1 "data_reg_operand" "0")
;;-		(match_operand:SI 2 "register_operand" "a")))]
;;-  ""
;;-  "
;;-{
;;-    emit_insn (gen_call_lib (
;;-	gen_rtx (SYMBOL_REF, Pmode, \"div_si\"),
;;-	operands[0], operands[1], operands[2]));
;;-    DONE;
;;-}")

(define_insn "divhi3"
  [(set (match_operand:HI 0 "byte_reg_operand" "=q,g")
	(div:HI (match_operand:HI 1 "byte_reg_operand" "0,0")
		(match_operand:HI 2 "byte_operand" "qm,g")))]
  ""
  ".divhi3 %2,%0")

;;--------------------------------------------------------------------
;;- mod
;;--------------------------------------------------------------------

;;-(define_expand "modsi3"
;;-  [(set (match_operand:SI 0 "data_reg_operand" "=d")
;;-	(mod:SI (match_operand:SI 1 "data_reg_operand" "0")
;;-		(match_operand:SI 2 "register_operand" "a")))]
;;-  ""
;;-  "
;;-{
;;-    emit_insn (gen_call_lib (
;;-	gen_rtx (SYMBOL_REF, Pmode, \"mod_si\"),
;;-	operands[0], operands[1], operands[2]));
;;-    DONE;
;;-}")

(define_insn "modhi3"
  [(set (match_operand:HI 0 "byte_reg_operand" "=q")
	(mod:HI (match_operand:HI 1 "byte_reg_operand" "0")
		(match_operand:HI 2 "byte_operand" "g")))]
  ""
  ".modhi3 %2,%0")

;;--------------------------------------------------------------------
;;- and, or, xor
;;--------------------------------------------------------------------

(define_insn "andsi3"
  [(set (match_operand:SI 0 "data_reg_operand" "=d")
	(and:SI (match_operand:SI 1 "data_reg_operand" "%0")
		(match_operand:SI 2 "address_operand" "min")))]
  ""
  "*
{
    int n;
    rtx xoperands[4];

    if (GET_CODE (operands[2]) == CONST_INT) {
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	xoperands[3] = operands[2];
	xoperands[2] =
	    gen_rtx (CONST_INT, SImode,
	    (INTVAL (operands[2]) >> 8) & 0xff);
	output_asm_insn (\"anda\\t%2\\t;andsi: R:%0 AND %3\", xoperands);
	xoperands[2] =
	    gen_rtx (CONST_INT, SImode, INTVAL (operands[2]) & 0xff);
	output_asm_insn (\"andb\\t%2\", xoperands);
    }
    else {
	output_asm_insn (\"anda\\t%2\\t;andsi: R:%0 AND %2\", operands);
	output_asm_insn (\"andb\\t%L2\", operands);
    }
    return \"\";
}")

(define_insn "andhi3"
  [(set (match_operand:HI 0 "byte_reg_operand" "=q")
	(and:HI (match_operand:HI 1 "byte_reg_operand" "%0")
		(match_operand:HI 2 "address_operand" "min")))]
  ""
  "and%0\\t%2\\t;andhi: R:%0 &= %2")

;;--------------------------------------------------------------------
;;- Bit set instructions.
;;--------------------------------------------------------------------

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "data_reg_operand" "=d")
	(ior:SI (match_operand:SI 1 "data_reg_operand" "%0")
		(match_operand:SI 2 "address_operand" "min")))]
  ""
  "*
{
    int n;
    rtx xoperands[3];

    if (GET_CODE (operands[2]) == CONST_INT) {
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	xoperands[2] =
	    gen_rtx (CONST_INT, SImode,
	    (INTVAL (operands[2]) >> 8) & 0xff);
	output_asm_insn (\"ora\\t%2\\t;iorsi: %0 OR %2\", xoperands);
	xoperands[2] =
	    gen_rtx (CONST_INT, SImode, INTVAL (operands[2]) & 0xff);
	output_asm_insn (\"orb\\t%2\", xoperands);
    }
    else {
	output_asm_insn (\"ora\\t%2\\t;iorsi: %0 OR %2\", operands);
	output_asm_insn (\"orb\\t%L2\", operands);
    }
    return \"\";
}")

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "byte_reg_operand" "=q")
	(ior:HI (match_operand:HI 1 "byte_reg_operand" "%0")
		(match_operand:HI 2 "address_operand" "min")))]
  ""
  "or%0\\t%2\\t;iorhi:")

;;--------------------------------------------------------------------
;;- xor instructions.
;;--------------------------------------------------------------------

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "data_reg_operand" "=d")
	(xor:SI (match_operand:SI 1 "data_reg_operand" "%0")
		(match_operand:SI 2 "address_operand" "min")))]
  ""
  "*
{
    int n;
    rtx xoperands[3];

    if (GET_CODE (operands[2]) == CONST_INT) {
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	xoperands[2] =
	    gen_rtx (CONST_INT, SImode,
	    (INTVAL (operands[2]) >> 8) & 0xff);
	output_asm_insn (\"eora\\t%2\\t;xorsi: %0 XOR %2\", xoperands);
	xoperands[2] =
	    gen_rtx (CONST_INT, SImode, INTVAL (operands[2]) & 0xff);
	output_asm_insn (\"eorb\\t%2\", xoperands);
    }
    else {
	output_asm_insn (\"eora\\t%2\\t;xorsi: %0 XOR %2\", operands);
	output_asm_insn (\"eorb\\t%L2\", operands);
    }
    return \"\";
}")

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "byte_reg_operand" "=q")
	(xor:HI (match_operand:HI 1 "byte_reg_operand" "%0")
		(match_operand:HI 2 "byte_operand" "mK")))]
  ""
  "*
{
    return \"eor%0\\t%2\\t;xorhi:\";
}")

;;--------------------------------------------------------------------
;;-  Complements
;;--------------------------------------------------------------------

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=d,a,?m")
	(neg:SI (match_operand:SI 1 "register_operand" "0,0,0")))]
  ""
  "*
{
    if (D_REG_P (operands[0])) {
	return \"coma\\t\\t;negsi: R:%0\;comb\;addd\\t#1\";
    }
    else if (A_REG_P (operands[0])) {
	output_asm_insn (\"exg\\td,%0\\t;negsi: R:%0 = -(R:%0)\", operands);
	return \"coma\;comb\;addd\\t#1\;exg\\td,%0\";
    }
    else {
	output_asm_insn (\"com\\t%0\\t;negsi: %0\;com\\t%L0\", operands);
	output_asm_insn (\"inc\\t%L0\", operands);
	output_asm_insn (\"bne\\t%l0\", operands);
	output_asm_insn (\"inc\\t%0\", operands);
	ASM_OUTPUT_INTERNAL_LABEL (asm_out_file, \"LI\",
	    CODE_LABEL_NUMBER (operands[0]));
	return \"\";
    }
}")

(define_insn "neghi2"
  [(set (match_operand:HI 0 "byte_operand" "=qm")
	(neg:HI (match_operand:HI 1 "byte_operand" "0")))]
  ""
  "*
{
    if (REG_P (operands[0]))
	return \"neg%0\\t\\t;neghi: R:%0\";
    else
	return \"neg\\t%0\\t;neghi: %0\";
}")

;;--------------------------------------------------------------------
;;-  
;;--------------------------------------------------------------------

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "data_reg_operand" "=d")
	(not:SI (match_operand:SI 1 "data_reg_operand" "0")))]
  ""
  "coma\\t\\t;one_cmplsi:\;comb")

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "byte_operand" "=qm")
	(not:HI (match_operand:HI 1 "byte_operand" "0")))]
  ""
  "*
{
    if (REG_P (operands[0]))
	return \"com%0\\t\\t;comhi: R:%0\";
    else
	return \"com\\t%0\\t;comhi: %0\";
}")

;;--------------------------------------------------------------------
;;- arithmetic shifts
;;--------------------------------------------------------------------
;;

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "general_operand" "=dm,d")
	(ashift:SI (match_operand:SI 1 "general_operand" "0,0")
	     (match_operand:SI 2 "nonmemory_operand" "nI,a")))]
  ""
  "*
{
    int n;

    output_asm_insn (\"\\t\\t;ashlsi: %0 by %2\", operands);
    if (GET_CODE (operands[2]) == CONST_INT) {
	n = INTVAL (operands[2]) & 0x0f;
	while (n-- > 0) {
	    if (D_REG_P (operands[0]))
		output_asm_insn (\"aslb\;rola\", operands);
	    else
		output_asm_insn (\"asl\\t%L0\;rol\\t%0\", operands);
	}
    }
    else {
	output_asm_insn (\"aslb\;rola\", operands);
	output_asm_insn (\"lea%2\\t-1,%2\\t;decr shift count\", operands);
	output_asm_insn (\"bne .-4\\t;loop\", operands);
    }
    return \"\";
}")

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "byte_operand" "=qm")
	(ashift:HI (match_operand:HI 1 "byte_operand" "0")
	     (match_operand:HI 2 "nonmemory_operand" "nI")))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x07;
    output_asm_insn (\"\\t\\t;ashlhi: %0 by %2\", operands);
    while (n-- > 0) {
	if (REG_P (operands[0]))
	    output_asm_insn (\"aslb\", operands);
	else
	    output_asm_insn (\"asl\\t%0\", operands);
    }
     return \"\";
}")

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "general_operand" "=dm,d")
	(ashiftrt:SI (match_operand:SI 1 "general_operand" "0,0")
	     (match_operand:SI 2 "nonmemory_operand" "nI,a")))
   (clobber (match_dup  2))]
  ""
  "*
{
    int n;

    output_asm_insn (\"\\t\\t;ashrsi: %0 by %2\", operands);
    if (GET_CODE (operands[2]) == CONST_INT) {
	n = INTVAL (operands[2]) & 0x0f;
	while (n-- > 0) {
	    if (D_REG_P (operands[0]))
		output_asm_insn (\"asra\;rorb\", operands);
	    else
		output_asm_insn (\"asr\\t%0\;ror\\t%L0\", operands);
	}
    }
    else {
	output_asm_insn (\"aslb\;rola\", operands);
	output_asm_insn (\"lea%2\\t-1,%2\\t;decr shift count\", operands);
	output_asm_insn (\"bne .-4\\t;loop\", operands);
    }
     return \"\";
}")

(define_insn "ashrhi3"
  [(set (match_operand:HI 0 "byte_operand" "=qm")
	(ashiftrt:HI (match_operand:HI 1 "general_operand" "0")
	     (match_operand:HI 2 "nonmemory_operand" "rnI")))
   (clobber (match_dup  2))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x07;
    output_asm_insn (\"\\t\\t;ashrhi: %0 by %2\", operands);
    while (n-- > 0) {
	if (Q_REG_P (operands[0]))
	    output_asm_insn (\"asrb\", operands);
	else
	    output_asm_insn (\"asr\\t%0\", operands);
    }
     return \"\";
}")

;;--------------------------------------------------------------------
;; logical shift instructions
;;--------------------------------------------------------------------

(define_insn "lshlsi3"
  [(set (match_operand:SI 0 "general_operand" "=dm,d")
	(lshift:SI (match_operand:SI 1 "general_operand" "0,0")
	     (match_operand:SI 2 "nonmemory_operand" "nI,a")))
   (clobber (match_dup  2))]
  ""
  "*
{
    int n;

    output_asm_insn (\"\\t\\t;lshlsi: %0 by %2\", operands);
    if (GET_CODE (operands[2]) == CONST_INT) {
	n = INTVAL (operands[2]) & 0x0f;
	while (n-- > 0) {
	    if (D_REG_P (operands[0]))
		output_asm_insn (\"lslb\;rola\", operands);
	    else
		output_asm_insn (\"lsl\\t%L0\;rol\\t%0\", operands);
	}
    }
    else {
	output_asm_insn (\"lslb\;rola\", operands);
	output_asm_insn (\"lea%2\\t-1,%2\\t;decr shift count\", operands);
	output_asm_insn (\"bne .-4\\t;loop\", operands);
    }
    return \"\";
}")

(define_insn "lshlhi3"
  [(set (match_operand:HI 0 "byte_operand" "=qm")
	(lshift:HI (match_operand:HI 1 "general_operand" "0")
		   (match_operand:HI 2 "nonmemory_operand" "rnI")))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x07;
    output_asm_insn (\"\\t\\t;lshlhi: %0 by %2\", operands);
    while (n-- > 0) {
	if (Q_REG_P (operands[0]))
	    output_asm_insn (\"lslb\", operands);
	else
	    output_asm_insn (\"lsl\\t%0\", operands);
    }
     return \"\";
}")

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(lshiftrt:SI (match_operand:SI 1 "general_operand" "0")
		     (match_operand:SI 2 "nonmemory_operand" "rnI")))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x0f;
    output_asm_insn (\"\\t\\t;lshrsi: %0 by %2\", operands);
    while (n-- > 0) {
	if (D_REG_P (operands[0]))
	    output_asm_insn (\"lsra\;rorb\", operands);
	else
	    output_asm_insn (\"lsr\\t%0\;ror\\t%L0\", operands);
    }
     return \"\";
}")

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "general_operand" "=qm")
	(lshiftrt:HI (match_operand:HI 1 "general_operand" "0")
		     (match_operand:HI 2 "nonmemory_operand" "rnI")))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x07;
    output_asm_insn (\"\\t\\t;lshrhi: %0 by %2\", operands);
    while (n-- > 0) {
	if (Q_REG_P (operands[0]))
	    output_asm_insn (\"lsrb\", operands);
	else
	    output_asm_insn (\"lsr\\t%0\", operands);
    }
     return \"\";
}")

;;--------------------------------------------------------------------
;; rotate instructions
;;--------------------------------------------------------------------

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(rotate:SI (match_operand:SI 1 "general_operand" "0")
		   (match_operand:SI 2 "nonmemory_operand" "rnI")))]
  ""
  "rol.w %2,%0")

(define_insn "rotlhi3"
  [(set (match_operand:HI 0 "general_operand" "=qm")
	(rotate:HI (match_operand:HI 1 "general_operand" "0")
		   (match_operand:HI 2 "nonmemory_operand" "rnI")))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x07;
    output_asm_insn (\"\\t\\t;rotlhi: %0 by %2\", operands);
    while (n-- > 0) {
	if (Q_REG_P (operands[0]))
	    output_asm_insn (\"rolb\", operands);
	else
	    output_asm_insn (\"rol\\t%0\", operands);
    }
     return \"\";
}")

(define_insn "rotrsi3"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(rotatert:SI (match_operand:SI 1 "general_operand" "0")
		     (match_operand:SI 2 "nonmemory_operand" "rnI")))]
  ""
  "ror.w %2,%0")

(define_insn "rotrhi3"
  [(set (match_operand:HI 0 "byte_operand" "=qm")
	(rotatert:HI (match_operand:HI 1 "byte_operand" "0")
		     (match_operand:HI 2 "nonmemory_operand" "rnI")))]
  ""
  "*
{
    int n;

    n = INTVAL (operands[2]) & 0x07;
    output_asm_insn (\"\\t\\t;rotrhi: %0 by %2\", operands);
    while (n-- > 0) {
	if (Q_REG_P (operands[0]))
	    output_asm_insn (\"rorb\", operands);
	else
	    output_asm_insn (\"ror\\t%0\", operands);
    }
     return \"\";
}")

;;--------------------------------------------------------------------
;;-  Jumps and transfers
;;--------------------------------------------------------------------
(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bra\\t%l0\", operands);
    else
	output_asm_insn (\"jmp\\t%l0\", operands);
    return \"\";
}")

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"beq\\t%l0\", operands);
    else
	output_asm_insn (\"lbeq\\t%l0\", operands);
    return \"\";
}")

(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bne\\t%l0\", operands);
    else
	output_asm_insn (\"lbne\\t%l0\", operands);
    return \"\";
}")

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bgt\\t%l0\", operands);
    else
	output_asm_insn (\"lbgt\\t%l0\", operands);
    return \"\";
}")

(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bhi\\t%l0\", operands);
    else
	output_asm_insn (\"lbhi\\t%l0\", operands);
    return \"\";
}")

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"blt\\t%l0\", operands);
    else
	output_asm_insn (\"lblt\\t%l0\", operands);
    return \"\";
}")

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"blo\\t%l0\", operands);
    else
	output_asm_insn (\"lblo\\t%l0\", operands);
    return \"\";
}")

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bge\\t%l0\", operands);
    else
	output_asm_insn (\"lbge\\t%l0\", operands);
    return \"\";
}")

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bhs\\t%l0\", operands);
    else
	output_asm_insn (\"lbhs\\t%l0\", operands);
    return \"\";
}")

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"ble\\t%l0\", operands);
    else
	output_asm_insn (\"lble\\t%l0\", operands);
    return \"\";
}")

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bls\\t%l0\", operands);
    else
	output_asm_insn (\"lbls\\t%l0\", operands);
    return \"\";
}")

;;--------------------------------------------------------------------
;;- Negative test and branch
;;--------------------------------------------------------------------
(define_insn ""
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bne\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbne\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"beq\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbeq\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"ble\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lble\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bls\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbls\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bge\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbge\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bhs\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbhs\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"blt\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lblt\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"blo\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lblo\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bgt\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbgt\\t%l0\\t;rev\", operands);
    return \"\";
}")

(define_insn ""
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
    if (TARGET_SHORT_BRANCH)
	output_asm_insn (\"bhi\\t%l0\\t;rev\", operands);
    else
	output_asm_insn (\"lbhi\\t%l0\\t;rev\", operands);
    return \"\";
}")

;;--------------------------------------------------------------------
;;-  Calls
;;--------------------------------------------------------------------
;;
;; arg count word may be omitted to save a push and let gcc try to
;; combine the arg list pop.  RETURN_POPS_ARGS from tm.h decides this.

;;- Call a function that returns no value.
(define_insn "call"
  [(call (match_operand:HI 0 "general_operand" "g")
	 (match_operand:SI 1 "general_operand" "g"))]
  ""
  "*
      return \"jsr\\t%0\\t;CALL: (VOIDmode) %0 (%a1 bytes)\";
  ")

(define_insn "call_value"
  [(set (match_operand 0 "" "=g")
	(call (match_operand:HI 1 "general_operand" "g")
	      (match_operand:SI 2 "general_operand" "g")))]
  ""
  "*
      return \"jsr\\t%1\\t;CALL: R:%0 = %1 (%a2 bytes)\";
  ")

;;- return insn not needed -- tej
;;-(define_insn "return"
;;-  [(return)]
;;-  ""
;;-  "rts")

;;--------------------------------------------------------------------
;;-  Library call
;;--------------------------------------------------------------------
;; Produce a variant of the `call' insns that is used to call a
;; library routine.
;;
;; Operands are as follows:
;;	0 -- name of function (as SYMBOL_REF)
;;	1 -- output argument
;;	2 -- first input argument
;;	3 -- second input argument
;;--------------------------------------------------------------------
;;
;; The pattern given below just exists to show that we have 3 operands.
(define_expand "call_lib"
 [(use (match_operand 0 "" ""))
 (use (match_operand 3 "" ""))]
 ""
 "
{
    emit_library_call (operands[0], 0, SImode,
	2, operands[2], SImode, operands[3], SImode);

    /*** assume library function returns value in R0 ***/
    emit_move_insn (operands[1], gen_rtx (REG, SImode, 0));
    DONE;
}")

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")
    
;;--------------------------------------------------------------------
;;-  Table jump
;;--------------------------------------------------------------------
;; Operand 0 is the address of the table element to use
;; operand 1 is the CODE_LABEL for the table
;;--------------------------------------------------------------------
(define_insn "tablejump"
   [(parallel [
	(set (pc) (match_operand:SI 0 "general_operand" "g"))
	(use (label_ref (match_operand 1 "" "")))])]
   ""
  "*
{
    if (A_REG_P (operands[0]))
       return \"jmp\\t[,%0]\\t;tablejump R:%0 (table %1)\";
    else if (D_REG_P (operands[0]))
       return \"pshs %0\;jmp\\t[,s++]\\t;tablejump R:%0 (table %1)\";
    else
       return \"jmp\\t[%0]\\t;tablejump %0 (table %1)\";
}")

;;--------------------------------------------------------------------
;;- Peepholes
;;- TBD
;;--------------------------------------------------------------------

;; Optimize the case of following a register load with a test
;; of reg just moved.

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "memory_operand" "m"))
   (set (cc0) (match_operand:SI 2 "register_operand" "r"))]
  "operands[2] == operands[0]"
    "ld%0\\t%1\\t;movsi: %1 -> R:%0 w/ implied test of %2")

;; Optimize the case of following a register store with a test
;; of reg or mem just moved.

(define_peephole
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(match_operand:HI 1 "register_operand" "r"))
   (set (cc0) (match_operand:HI 2 "general_operand" "g"))]
  "operands[2] == operands[0] || operands[2] == operands[1]"
    "st%1\\t%0\\t;movhi: R:%1 -> %0 w/ implied test of %2")
    
;; Optimize the (strange) case of following an SI register store
;; with a load of the reg just moved.
(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "register_operand" "r"))
  (set (match_operand:SI 2 "register_operand" "=r")
	(match_operand:SI 3 "memory_operand" "m"))]
  "operands[0] == operands[3] && operands[1] == operands[2]"
    "st%1\\t%0\\t;movsi: R:%1 -> %0 w/ redundant move of %3 -> %2")
    
;; Optimize the (strange) case of following an HI register store
;; with a load of the reg just moved.
(define_peephole
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(match_operand:HI 1 "register_operand" "r"))
  (set (match_operand:HI 2 "register_operand" "=r")
	(match_operand:HI 3 "memory_operand" "m"))]
  "operands[0] == operands[3] && operands[1] == operands[2]"
    "st%1\\t%0\\t;movhi: R:%1 -> %0 w/ redundant move of %3 -> %2")
    
;;- Local variables:
;;- mode:emacs-lisp
;;- comment-start: ";;- "
;;- eval: (set-syntax-table (copy-sequence (syntax-table)))
;;- eval: (modify-syntax-entry ?[ "(]")
;;- eval: (modify-syntax-entry ?] ")[")
;;- eval: (modify-syntax-entry ?{ "(}")
;;- eval: (modify-syntax-entry ?} "){")
;;- End:

