/*
    GCC5616 -- GCC 1.40 machine description for DSP5616 processors
    Copyright (C) 1991,1992 Andrew Sterian and Bell-Northern Research

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GCC distribution; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	Contact the author at 'asterian@bnr.ca' or post to the 'comp.dsp'
	newsgroup.
*/

/* This define triggers some changes in the core GCC code */
#define DSP5616

/* The compiler crashes in a very unintrusive manner. This is bad. */
/* This define gives us a little more info when a crash occurs. */
#define abort fancy_abort

#define TARGET_VERSION \
	fprintf(stderr," (GCC5616 v0.2)")

#define CPP_PREDEFINES "-Ddsp5616"

/* #define CC1_SPEC */

/* Bits 1 and 2 are unused (leftovers from GCC56K) */
/* If bit 3 is set, no SECTION/ENDSEC directives will be output */
/* If bit 4 is set, accumulator registers will be properly extended */
/*					before a test or compare instruction */
extern int target_flags;
#define TARGET_DEFAULT 0x8	/* Enable safe compares by default */

#define TARGET_SWITCHES {\
	{ "no-sect", 4}, 			\
	{ "safe-compare", 8},		\
	{ "no-safe-compare", -8},	\
    { "", TARGET_DEFAULT} }

#define TARGET_NOSECT (target_flags & 0x4)
#define TARGET_SAFECOMPARE (target_flags & 0x8)

/* Added this to decode some nifty switches */
#define LANG_SPECIFIC_SWITCH_DECODE(name) mswitch_decode(name)

/* No bitfield instructions currently defined so this is irrelevant */
/* #define BITS_BIG_ENDIAN */

#define BYTES_BIG_ENDIAN

#define WORDS_BIG_ENDIAN

#define BITS_PER_UNIT 		16 /* 16 */
#define BITS_PER_WORD 		16 /* 16 */
#define UNITS_PER_WORD 		 1 /* 1 */
#define POINTER_SIZE 		16 /* 16 */
#define POINTER_BOUNDARY 	16 /* 16 */
#define PARM_BOUNDARY		16 /* 16 */
/* #define MAX_PARM_BOUNDARY	 */
/* #define STACK_BOUNDARY */
#define FUNCTION_BOUNDARY 	16 /* 16 */
#define BIGGEST_ALIGNMENT	16 /* 16 */
/* #define CONSTANT_ALIGNMENT(CODE, TYPEALIGN) */
#define EMPTY_FIELD_BOUNDARY	16 /* 16 */
/* #define STRUCTURE_SIZE_BOUNDARY */
/* #define STRICT_ALIGNMENT */
/* #define PCC_BITFIELD_TYPE_MATTERS */
#define MAX_FIXED_MODE_SIZE	32 /* 32 */

#if 0 /* We allow this so we may write (1.0/2.0) */
#define CHECK_FLOAT_VALUE(MODE, VALUE) \
	if (((VALUE) < -1.0) || ((VALUE) >= 1.0)) { \
		error("Float value out of bounds"); \
	}
#endif

/* We really have only 18 registers but I like to be similar to GCC56K */
#define FIRST_PSEUDO_REGISTER 27

/*
X1 X0 Y1 Y0 A2 A1 A0 B2 B1 B0 R0 R1 R2 R3 R4 R5 R6 R7 N0 N1 N2 N3 N4 N5 N6 N7 D
*/
#define FIXED_REGISTERS { \
0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,1}
#define CALL_USED_REGISTERS { \
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,1}
#define DEFAULT_CALLER_SAVES
/* #define CONDITIONAL_REGISTER_USAGE */
/* #define OVERLAPPING_REGNO_P(REGNO) */
#define INSN_CLOBBERS_REGNO_P(INSN, REGNO) \
	insn_clobbers_regno_p(INSN, REGNO)
/* #define PRESERVE_DEATH_INFO_REGNO_P(REGNO) */
#define HARD_REGNO_NREGS(REGNO, MODE) \
	((((MODE) == DImode) || ((MODE) == DFmode)) ? 2 : 1)
#define HARD_REGNO_MODE_OK(REGNO, MODE) \
	hard_regno_mode_ok(REGNO, MODE)
#define MODES_TIEABLE_P(MODE1, MODE2) 0
/* #define PC_REGNUM */
#define STACK_POINTER_REGNUM 13	/* R3 */
#define FRAME_POINTER_REGNUM 12 /* R2 */
#define FRAME_POINTER_REQUIRED 1
#define ARG_POINTER_REGNUM 12	/* R2 */
#define STATIC_CHAIN_REGNUM 26	/* Dummy register */
#define STRUCT_VALUE_REGNUM 10	/* R0 */
/* #define STRUCT_VALUE */
/* #define STRUCT_VALUE_INCOMING_REGNUM */
/* #define STRUCT_VALUE_INCOMING */

/*

/* I'm sure that there can be much discussion about the optimal */
/* ordering of this sequence */
#define REG_ALLOC_ORDER \
{ 1, 0, 3, 2, 5, 8, 10, 11 }

/* GENERAL_REGS2 is no longer needed ... should be taken out I guess */
/*
   Class 0  : NO_REGS
   Class 1  : ALU_DATA_REGS0 == X0, Y0
   Class 2  : ALU_DATA_REGS1 == X1, Y1
   Class 3  : ALU_DATA_REGSX == X0, X1
   Class 4  : ALU_DATA_REGSY == Y0, Y1
   Class 5  : ACC_REGS_LO == A0, B0
   Class 6  : ACC_REGS_HI == A1, B1
   Class 7  : ACC_REGS    == A1, B1, A0, B0
   Class 8  : ALU_DATA_REGS2 == X0, Y1, Y0
   Class 9  : ALU_DATA_REGS == X1, X0, Y1, Y0
   Class 10 : MATHOP_REGS   == X1, X0, Y1, Y0, A1, B1
   Class 11 : ADDRESS_REGS == R0..R3
   Class 12 : INDEX_REGS   == N0..N3
   Class 13 : AGU_REGS     == R0..R3, N0..N3
   Class 14 : BASE_REGS    == R0..R3, A1, B1
   Class 15 : ALU_REGS     == X1, X0, Y1, Y0, A1, B1, A0, B0
   Class 16 : GENERAL_REGS == A1, B1, X1, X0, Y1, Y0, R0..R3
   Class 17 : GENERAL_REGS2 = A1, A0, B1, B0, X1, X0, Y1, Y0, R0..R3
   Class 18 : ALL_REGS
*/
enum reg_class { NO_REGS, ALU_DATA_REGS0, ALU_DATA_REGS1, ALU_DATA_REGSX, 
		ALU_DATA_REGSY, ACC_REGS_LO, ACC_REGS_HI, ACC_REGS, ALU_DATA_REGS2, 
		ALU_DATA_REGS, MATHOP_REGS, ADDRESS_REGS, INDEX_REGS, AGU_REGS, 
		BASE_REGS, ALU_REGS, GENERAL_REGS, GENERAL_REGS2,
		ALL_REGS, LIM_REG_CLASSES };
#define N_REG_CLASSES ((int)LIM_REG_CLASSES)

#define REG_CLASS_NAMES \
	{ "NoRegs", "AluDataRegs0", "AluDataRegs1", "AluDataRegsX", \
	  "AluDataRegsY", "AccRegsLo", "AccRegsHi", "AccRegs", "AluDataRegs2", \
      "AluDataRegs",  "MathOpRegs", "AddressRegs", "IndexRegs", "AguRegs", \
      "BaseRegs", "AluRegs", "GeneralRegs", "GeneralRegs2", \
	  "AllRegs" };

/* A0 and B0 have to be included in ACC_REGS for address calculations */
/* Perhaps, however, there is still a bug in the machine description */
/* (or in GCC) that does not properly recognize that A and B can */
/* hold a DI or DF in *one* register */
#define REG_CLASS_CONTENTS \
	{ 0x00000000,  		/* NoRegs */		\
	  0x0000000A,		/* AluDataRegs0 */	\
	  0x00000005,		/* AluDataRegs1 */	\
	  0x00000003,		/* AluDataRegsX */	\
	  0x0000000C,		/* AluDataRegsY */	\
	  0x00000240,       /* AccRegsLo */		\
	  0x00000120,		/* AccRegsHi */		\
	  0x00000360,  		/* AccRegs */		\
	  0x0000000E,  		/* AluDataRegs2 */	\
	  0x0000000F,  		/* AluDataRegs */	\
	  0x0000012F,		/* MathOpRegs */	\
	  0x00003C00,  		/* AddressRegs */	\
	  0x003C0000,  		/* IndexRegs */		\
	  0x003C3C00,  		/* AguRegs */		\
	  0x00003D20,       /* BaseRegs */		\
	  0x0000036F,		/* AluRegs */		\
	  0x00003D2F,		/* GeneralRegs */	\
	  0x00003F6F,		/* GeneralRegs2 */	\
	  0x07FFFF6F };		/* AllRegs */
#define REGNO_REG_CLASS(REGNO) \
	regno_reg_class(REGNO)
#define BASE_REG_CLASS ADDRESS_REGS
#define INDEX_REG_CLASS MATHOP_REGS
#define REG_CLASS_FROM_LETTER(C) \
	reg_class_from_letter(C)

/* We really should allow ACC_REGS_HI but the compiler tries to */
/* generate X:(A1+N) even though GO_IF_LEGITIMATE_ADDRESS tells */
/* it it can't. We lose. */
#define REGNO_OK_FOR_BASE_P(NUM) \
	((regno_reg_class(NUM) == ADDRESS_REGS) || \
	 /* (regno_reg_class(NUM) == ACC_REGS_HI)  || */ \
	 (regno_reg_class(reg_renumber[NUM]) == ADDRESS_REGS) || \
	 /* (regno_reg_class(reg_renumber[NUM]) == ACC_REGS_HI) || */ 0)
#define REGNO_OK_FOR_INDEX_P(NUM) \
	((regno_reg_class(NUM) == MATHOP_REGS) || \
	(regno_reg_class(reg_renumber[NUM]) == MATHOP_REGS))
#define PREFERRED_RELOAD_CLASS(X, CLASS) CLASS
#define CLASS_MAX_NREGS(CLASS, MODE) \
	class_max_nregs(CLASS, MODE)

/* I don't think these are used anywhere (except for J) but...why not! */
/* 'I' : 1 or -1 only (for add and subtract becoming INC/DEC) */
/* 'J' : 8-bit numbers (that fit in a QI) */
/* 'K' : 12-bit numbers (for REP, DO, etc.) */
/* 'L' : 16-bit numbers (for addresses, etc.) */
#define CONST_OK_FOR_LETTER_P(VALUE, C) \
	((C) == 'I' ? ((VALUE==1) || (VALUE==-1)): \
     (C) == 'J' ? ((VALUE >=0) && (VALUE <256)) : \
     (C) == 'K' ? ((VALUE >=0) && (VALUE <4096)) : \
     (C) == 'L' ? ((VALUE >=0) && (VALUE <65536)) : 0)

/* No restrictions on floating point */
#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C) \
		const_double_ok_for_letter_p(VALUE, C)

/* It would be *really* nice to have stack grow upward but to gain */
/* any efficiency advantages we would need to modify the stack pointer */
/* from pointing to last-used stack location to pointing to first-free */
/* stack location. Currently, this requires major mods to the GCC core. */
#define STACK_GROWS_DOWNWARD
#define FRAME_GROWS_DOWNWARD
#define STARTING_FRAME_OFFSET -1 
#define PUSH_ROUNDING(NPUSHED) NPUSHED
#define FIRST_PARM_OFFSET(FUNDECL) 1
/* #define FIRST_PARM_CALLER_OFFSET(FUNDECL) */
/* #define REG_PARM_STACK_SPACE */
/* #define STACK_ARGS_ADJUST(SIZE) */
#define RETURN_POPS_ARGS(FUNTYPE) 0
#define FUNCTION_VALUE(VALTYPE, FUNC) \
	gen_rtx(REG, TYPE_MODE(VALTYPE), 5)	/* A1 is return reg. */
/* #define FUNCTION_OUTGOING_VALUE(VALTYPE, FUNC) */
/* #define RETURN_IN_MEMORY(TYPE) */
#define LIBCALL_VALUE(MODE) \
	gen_rtx(REG, MODE, 5)
#define FUNCTION_VALUE_REGNO_P(REGNO) \
	(REGNO==5)
#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED) 0
/* #define FUNCTION_INCOMING_ARG(CUM, MODE, TYPE, NAMED)  */
#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED) 0
#define CUMULATIVE_ARGS int
#define INIT_CUMULATIVE_ARGS(CUM, FNTYPE) ((CUM)=0)
#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED) \
	((CUM) += ((MODE) != BLKmode \
		? GET_MODE_SIZE(MODE) : int_size_in_bytes(TYPE)))
#define FUNCTION_ARG_REGNO_P(REGNO) 0
/* #define FUNCTION_ARG_PADDING(MODE, SIZE) */

#define FUNCTION_PROLOGUE(filePtr, SIZE) \
	function_prologue(filePtr, SIZE)
#define FUNCTION_PROFILER(filePtr, LABELNO)
#define FUNCTION_BLOCK_PROFILER(filePtr, LABELNO)
#define BLOCK_PROFILER(filePtr, BLOCKNO)
#define EXIT_IGNORE_STACK 1
#define FUNCTION_EPILOGUE(filePtr, SIZE) \
	function_epilogue(filePtr, SIZE)
#define FIX_FRAME_POINTER_ADDRESS(ADDR, DEPTH)
/* #define LONGJMP_RESTORE_FROM_STACK */

/* #define MULSI3_LIBCALL */
/* #define UMULSI3_LIBCALL */
#define DIVSI3_LIBCALL	"divsi3"
#define UDIVSI3_LIBCALL	"udivsi3"
#define MODSI3_LIBCALL	"modsi3"
#define UMODSI3_LIBCALL "umodsi3"
/* #define TARGET_MEM_FUNCTIONS */
/* #define GNULIB_NEEDS_DOUBLE */

#define HAVE_POST_INCREMENT
/* #define HAVE_PRE_INCREMENT */
#define HAVE_POST_DECREMENT
#define HAVE_PRE_DECREMENT
#define CONSTANT_ADDRESS_P(X) \
		constant_address_p(X)

#define MAX_REGS_PER_ADDRESS 1

/* Again, it would be nice to allow ACC_REGS_HI as base address registers */
/* but GCC tries to generate X:(A1+N). We still lose. */
#ifndef REG_OK_STRICT
#define REG_OK_FOR_BASE_P(X) \
	(REG_OK_FOR_BASE2_P(X) /* || (regno_reg_class(REGNO(X)) == ACC_REGS_HI) */)
#define REG_OK_FOR_BASE2_P(X) \
    ((REGNO(X) >=27) || (regno_reg_class(REGNO(X)) == ADDRESS_REGS))
#define REG_OK_FOR_INDEX_P(X) \
	((REGNO(X) >=27) || (REGNO(X) <= 9))
#else
#define REG_OK_FOR_BASE_P(X) \
	(REG_OK_FOR_BASE2_P(X) /* || (regno_reg_class(REGNO(X)) == ACC_REGS_HI) */)
#define REG_OK_FOR_BASE2_P(X) \
    (regno_reg_class(REGNO(X)) == ADDRESS_REGS)
#define REG_OK_FOR_INDEX_P(X) \
	(REGNO(X) <= 9)
#endif /* REG_OK_STRICT */

/* We allow:
     X:(Rn+Reg) where Reg is not another R-register
	 X:(Rn+int)
	 X:(Rn+const)
	 X:(Rn+addr)
   Of course, only X:(Rn+Nn) is allowed but we transparently generate
   code to load the offset into Nn.
*/
#define VALID_OFFSET(x) \
	((GET_CODE(x)==REG && REG_OK_FOR_INDEX_P(x)) || GET_CODE(x)==CONST_INT || \
	 GET_CODE(x)==CONST || GET_CODE(x)==SYMBOL_REF)

/*
  A legitimate address is:
    * A constant symbol reference
	* X:(Rn)
	* X:-(Rn), X:(Rn)+, X:(Rn)-
	* X:(Rn+offset)
	* X:(offset+Rn)
*/
#define GO_IF_LEGITIMATE_ADDRESS(MODE, x, LABEL) \
{ \
    if (CONSTANT_ADDRESS_P(x)) goto LABEL;	\
    if ((GET_CODE(x) == REG) && REG_OK_FOR_BASE_P(x)) goto LABEL; \
    if (((GET_CODE(x) == PRE_DEC) || (GET_CODE(x) == POST_INC) || \
		(GET_CODE(x) == POST_DEC)) && \
            REG_P(XEXP(x,0)) && \
            REG_OK_FOR_BASE2_P(XEXP(x,0)) ) goto LABEL; \
	if ((GET_CODE(x) == PLUS) && \
		((REG_P(XEXP(x,0)) && REG_OK_FOR_BASE2_P(XEXP(x,0)) && \
			VALID_OFFSET(XEXP(x,1))) || \
		(VALID_OFFSET(XEXP(x,0)) && REG_P(XEXP(x,1)) && \
							REG_OK_FOR_BASE2_P(XEXP(x,1))))) \
	goto LABEL; \
}

#define LEGITIMIZE_ADDRESS(X, OLDX, MODE, WIN) \
    if (legitimize_address(X, OLDX, MODE)) goto WIN;

/* The size of increment or decrement is dependent upon the size */
/* of what we're addressing */
#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR, LABEL) \
	if (GET_CODE(ADDR)==POST_INC || GET_CODE(ADDR)==POST_DEC || \
		GET_CODE(ADDR)==PRE_DEC) goto LABEL

#define LEGITIMATE_CONSTANT_P(X) 1

/* #define HAVE_DELAYED_BRANCH */

/* #define CC_STATUS_MDEP */
/* #define CC_STATUS_MDEP_INIT */

/* This should be orders of magnitude more intelligent but I'm not */
/* sure I quite understand it. */
/* For now, trap all instructions of the form 'cmp A,A' and set */
/* the OPERANDS_THE_SAME flag to turn the next branch into a 'bra' */
#define NOTICE_UPDATE_CC(exp, insn) \
	{ CC_STATUS_INIT; \
		if (GET_CODE(insn) == INSN && \
			GET_CODE(body) == SET && \
			SET_DEST(body) == cc0_rtx && \
			GET_CODE(SET_SRC(body)) == COMPARE && \
			rtx_equal_p(XEXP(SET_SRC(body),0), XEXP(SET_SRC(body),1))) \
				cc_status.flags |= CC_OPERANDS_THE_SAME; \
	}

/* #define REAL_VALUE_TYPE  */
/* #define REAL_VALUES_EQUAL(X, Y) */
/* #define REAL_VALUES_LESS(X, Y) */
/* #define REAL_VALUE_LDEXP(X, SCALE) */
/* #define REAL_VALUE_ATOF(STRING) */
/* #define REAL_ARITHMETIC(OUTPUT, CODE, X, Y) */
/* #define REAL_VALUE_NEGATE(X) */
/* #define REAL_VALUE_TO_INT(LOW, HIGH, X) */
/* #define REAL_VALUE_FROM_INT(X, LOW, HIGH) */

#define CASE_VECTOR_MODE Pmode
/* #define CASE_VECTOR_PC_RELATIVE */
/* #define CASE_DROPS_THROUGH */
#define IMPLICIT_FIX_EXPR FIX_ROUND_EXPR	/* ??? */
#define FIXUNS_TRUNC_LIKE_FIX_TRUNC			/* ??? */
#define EASY_DIV_EXPR ROUND_DIV_EXPR		/* ??? */
#define DEFAULT_SIGNED_CHAR 0
#define SCCS_DIRECTIVE
/* #define HAVE_VPRINTF */
#define MOVE_MAX 0
#define CHAR_TYPE_SIZE 			16 /* 16 */
#define SHORT_TYPE_SIZE 		16 /* 16 */
#define INT_TYPE_SIZE 			16 /* 16 */
#define LONG_TYPE_SIZE 			32 /* 32 */
#define LONG_LONG_TYPE_SIZE 	32 /* 32 */
#define FLOAT_TYPE_SIZE 		16 /* 16 */
#define DOUBLE_TYPE_SIZE 		32 /* 32 */
#define LONG_DOUBLE_TYPE_SIZE 	32 /* 32 */
#define SLOW_BYTE_ACCESS 0
/* #define SLOW_ZERO_EXTEND  */
/* #define SHIFT_COUNT_TRUNCATED */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1
/* #define NO_FUNCTION_CSE */
/* #define PROMOTE_PROTOTYPES */
/* #define STORE_FLAG_VALUE */
#define Pmode SImode
#define FUNCTION_MODE SImode
/* #define INSN_MACHINE_INFO */
/* #define DEFAULT_MACHINE_INFO */
#define CONST_COSTS(X, CODE) \
	case CONST_INT: return 1; \
    case CONST: case LABEL_REF: case SYMBOL_REF:  return 2; \
    case CONST_DOUBLE: return 3;
/* #define DOLLARS_IN_IDENTIFIERS */

/* #define ASM_SPEC */
/* #define LINK_SPEC */
/* #define LIB_SPEC */
/* #define LIBG_SPEC */
/* #define STARTFILE_SPEC */
/* #define STANDARD_EXEC_PREFIX */
/* #define STANDARD_STARTFILE_PREFIX */
#define ASM_FILE_START(filePtr) \
	do { time_t theTime; theTime=time((long *)0); \
	fprintf(filePtr, "; DSP5616 code generated by GCC5616 %s \t%s\n", \
	version_string, ctime(&theTime)); \
	if (!TARGET_NOSECT) fprintf(filePtr, "\n\tSECTION %s%s\n", \
	(use_section_prefix ? section_prefix : ""), \
	(use_section_name ? section_name : remove_punct(main_input_filename))); \
	if (!TARGET_NOSECT) fprintf(filePtr, "\n\tINCLUDE 'gcc_mac'\n"); \
	} while(0)
#define ASM_FILE_END(filePtr) \
	if (!TARGET_NOSECT) fprintf(filePtr, "\n\tENDSEC\n")
#define ASM_IDENTIFY_GCC(filePtr)
#define ASM_APP_ON ""
#define ASM_APP_OFF ""
#define TEXT_SECTION_ASM_OP "\tTEXT_SECTION\n"
#define DATA_SECTION_ASM_OP "\tDATA_SECTION\n"
#define EXTRA_SECTIONS \
	in_x_d_section, in_x_c_section
#define SELECT_SECTION(EXP) \
    select_section(EXP)
#define SELECT_RTX_SECTION(MODE, RTX) \
    select_rtx_section(MODE, RTX)
#define EXTRA_SECTION_FUNCTIONS \
void x_data_section() { \
  if (in_section != in_x_d_section) { \
      fprintf (asm_out_file, "\n\tX_DATA_SECTION\n"); \
      in_section = in_x_d_section; } } \
void x_const_section() { \
  if (in_section != in_x_c_section) { \
      fprintf (asm_out_file, "\n\tX_CONST_SECTION\n"); \
      in_section = in_x_c_section; } } 


#define REGISTER_NAMES { \
 "X1", "X0", "Y1", "Y0", "A2", "A1", "A0", "B2", "B1", "B0", \
 "R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", \
 "N0", "N1", "N2", "N3", "N4", "N5", "N6", "N7", "Dummy" }

#define DBX_REGISTER_NUMBER(REGNO) REGNO
/* #define DBX_DEBUGGING_INFO */
#define SDB_DEBUGGING_INFO
#define PUT_SDB_SCL(a)
#define PUT_SDB_INT_VAL(a)
#define PUT_SDB_VAL(a)
#define PUT_SDB_DEF(a)
#define PUT_SDB_PLAIN_DEF(a)
#define PUT_SDB_ENDEF
#define PUT_SDB_TYPE(a)
#define PUT_SDB_SIZE(a)
#define PUT_SDB_START_DIM
#define PUT_SDB_NEXT_DIM(a)
#define PUT_SDB_LAST_DIM(a)
#define PUT_SDB_TAG(a)
#define PUT_SDB_BLOCK_START(a)
#define PUT_SDB_BLOCK_END(a)
#define PUT_SDB_FUNCTION_START(a)
#define PUT_SDB_FUNCTION_END(a)
#define PUT_SDB_EPILOGUE_END(a)
/* #define SDB_GENERATE_FAKE */
/* #define DBX_NO_XREFS */
/* #define DBX_CONTIN_LENGTH */
/* #define DBX_CONTIN_CHAR */
/* #define DBX_STATIC_STAB_DATA_SECTION */

#define ASM_OUTPUT_LABEL(filePtr, NAME) \
    assemble_name(filePtr, NAME), fprintf(filePtr, "\n")
#define ASM_DECLARE_FUNCTION_NAME(filePtr, NAME, DECL) \
    assemble_name(filePtr, NAME), fprintf(filePtr, "\n")
#define ASM_GLOBALIZE_LABEL(filePtr, NAME) \
    fprintf(filePtr, "\tGLOBAL\t"), assemble_name(filePtr, NAME), \
	fprintf(filePtr, "\n")
#define ASM_OUTPUT_EXTERNAL(filePtr, DECL, NAME) \
    fprintf(filePtr, "\t;XREF\t"), assemble_name(filePtr, NAME), \
	fprintf(filePtr, "\n")
#define ASM_OUTPUT_LABELREF(filePtr, NAME) \
	asm_output_labelref(filePtr, NAME)
#define ASM_GENERATE_INTERNAL_LABEL(STRING, PREFIX, NUM) \
	sprintf(STRING, "%sgcc%u", PREFIX, NUM)
#define ASM_OUTPUT_INTERNAL_LABEL(filePtr, PREFIX, NUM) \
	fprintf(filePtr,"%sgcc%u\n", PREFIX, NUM)
#define ASM_OUTPUT_CASE_LABEL(filePtr, PREFIX, NUM, TABLE) \
	{ x_const_section(); ASM_OUTPUT_INTERNAL_LABEL(filePtr, PREFIX, NUM); }
#define ASM_OUTPUT_CASE_END(filePtr, NUM, TABLE) \
	text_section()
/* #define ASM_OUTPUT_ALIGN_CODE(filePtr) */
#define ASM_FORMAT_PRIVATE_NAME(OUTVAR, NAME, NUMBER) \
    OUTVAR = alloca(80), sprintf(OUTVAR, "%s__%04X", NAME, NUMBER)
#define ASM_OUTPUT_REG_PUSH(filePtr, REGNO) \
	fprintf(filePtr, "\tmove %s,X:-(R3)\n",reg_names[REGNO])
#define ASM_OUTPUT_REG_POP(filePtr, REGNO) \
	fprintf(filePtr, "\tmove X:(R3)+,%s\n",reg_names[REGNO])

#define ASM_OUTPUT_ADDR_DIFF_ELT(filePtr, VALUE, REL) \
	fprintf(filePtr,"\tdc\tLgcc%u-Lgcc%u\n",VALUE,REL)
#define ASM_OUTPUT_ADDR_VEC_ELT(filePtr, VALUE) \
    fprintf(filePtr,"\tdc\tLgcc%u\n", VALUE)
#define ASM_OUTPUT_DOUBLE(filePtr, VALUE) \
	asm_output_double(filePtr, VALUE)
#define ASM_OUTPUT_FLOAT(filePtr, VALUE) \
	asm_output_float(filePtr, VALUE)
#define ASM_OUTPUT_INT(filePtr, EXP) \
    fprintf(filePtr,"\tdc\t"), output_addr_const(filePtr, (EXP)), \
    fprintf(filePtr, "\n")
#define ASM_OUTPUT_SHORT(filePtr, EXP) ASM_OUTPUT_INT(filePtr, EXP)
#define ASM_OUTPUT_CHAR(filePtr, EXP) ASM_OUTPUT_INT(filePtr, EXP)
#define ASM_OUTPUT_BYTE(filePtr, EXP) ASM_OUTPUT_INT(filePtr, EXP)
#define ASM_OUTPUT_DOUBLE_INT(filePtr, EXP) \
	asm_output_double_int(filePtr, EXP)
#define ASM_OUTPUT_ASCII(filePtr, PTR, LEN) \
	asm_output_ascii(filePtr, PTR, LEN)
#define ASM_OUTPUT_SKIP(filePtr, NBYTES) \
    fprintf(filePtr, "\tds\t%u\n", NBYTES)
#define ASM_OUTPUT_ALIGN(filePtr, POWER) \
    fprintf(stderr,"ASM_OUTPUT_ALIGN: ???\n")
#define ASM_OUTPUT_COMMON(filePtr, NAME, SIZE, ROUNDED, DECL) \
	fprintf(filePtr,"\tGLOBAL\t%s\n", NAME), \
    assemble_name(filePtr, NAME), fprintf(filePtr, "\tds\t%u\n", ROUNDED)
#define ASM_OUTPUT_LOCAL(filePtr, NAME, SIZE, ROUNDED, DECL) \
	assemble_name(filePtr, NAME), \
	fprintf(filePtr, "\tds\t%u\n", ROUNDED)
#define ASM_OUTPUT_SOURCE_FILENAME(filePtr, NAME) \
	fprintf(filePtr,"\n; File: %s\n",NAME)
#define ASM_OUTPUT_SOURCE_LINE(filePtr, LINE) \
	fprintf(filePtr,"\n; Line: %u\n",LINE)
#define ASM_OUTPUT_IDENT(filePtr, STRING) \
    fprintf(filePtr,"\tCOBJ\t'%s'\n", STRING)

#define TARGET_BELL     7
#define TARGET_BS       8
#define TARGET_TAB      9
#define TARGET_NEWLINE  10
#define TARGET_VT       11
#define TARGET_FF       12
#define TARGET_CR       13
/* #define ASM_OUTPUT_OPCODE(filePtr, PTR) */
/* #define FINAL_PRESCAN_INSN(INSN, OPVEC, NOPERANDS)  */
#define PRINT_OPERAND(filePtr, X, CODE) \
    print_operand(filePtr, X, CODE)
#define PRINT_OPERAND_PUNCT_VALID_P(CODE) \
    (((CODE)=='p') || ((CODE)=='q') || ((CODE)=='w') || ((CODE)=='x') || \
     ((CODE)=='y') || ((CODE)=='Z') || ((CODE)=='r') || ((CODE)=='z') || \
	 ((CODE)=='s') || ((CODE)=='M') || ((CODE)=='N'))
#define PRINT_OPERAND_ADDRESS(filePtr, X) \
    print_operand_address(filePtr, X, 0)

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"

/* These are my own additions */
extern char *version_string;
extern char section_prefix[];
extern int use_section_prefix;
extern char section_name[];
extern int use_section_name;
extern char *remove_punct(char *name);




