#include <stddef.h>
#include <math.h>

/*
 * Generate a sine table of N samples with amplitude A and normalized 
 * frequency f where -0.5 <= f < 0.5.  The table is stored in memory 
 * beginning at 'loc'. If 'cosine' is nonzero, a cosine table is generated.
*/

void 
SinTab(fract A, fract f, size_t N, fract *loc, int cosine)
{
	register int counter;
	register fract angle=(fract)0.0;
	register fract inc;

	inc = flshift(f*(fract)M_PI_4, 1);		/* inc = (2*Pi*f) / 4 */
	for (counter=0; counter<N; counter++) {
		angle += inc;
		if (angle > (fract)M_PI_4) {
			angle -= (fract)M_PI_4;
			angle -= (fract)M_PI_4;
		}
		*loc++ = (cosine ? A*cos(angle) : A*sin(angle));
	}
}

