;====================================================================
;
; MODULE:
;        sin
;
; FUNCTION:
;        Calculate sine of an argument which is in the range [-Pi/4,Pi/4]
;        and is 1/4 the value of which the sine is desired.
;
; C INTERFACE:
;        fract sin(fract arg_by_four)
;
; RETURN VALUE:
;        sin(4*arg_by_four)
;
;====================================================================
                        SECTION LIBM_sin_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; fract sin(fract arg_by_four)
;         -Pi/4 <= arg_by_four <= Pi/4
;
            X_CONST_SECTION
SinTrigCompares
            dc    M_PI_16
            dc    M_PI_8
            dc    M_PI_3_16

            TEXT_SECTION

                GLOBAL sin
sin
                move R2,X:-(R3)
                lea  (R3)+,R2
                move #SinTrigCompares,R0        ;R0<--compare table
                move #M_PI_4,X1                 ;X1<--Pi/4
                move X:(R2),A                   ;A<--arg_by_four

                ;Since sin(-arg)=-sin(arg), calculate sin(|arg|)
                ;and figure out the sign at the end
                abs  A    X:(R0)+,X0            ;A<--|arg_by_four|
                                                ;X0<--Pi/16
_test1
                ;If (arg_by_four < Pi/16) then
                ;retval=sin(arg)
                cmp  X0,A X:(R0)+,X0            ;X0<--Pi/8
                bgt     _test2
                asl  A                          ;A<--4*arg_by_four=arg
                asl  A
                move A,X:-(R3)
                jsr  fsin                       ;A<--sin(arg)
                bra  _return
_test2
                ;If (arg_by_four < Pi/8) then
                ;retval=cos(Pi/2 - arg)
                cmp  X0,A X:(R0)+,X0            ;X0<--(3/16)Pi
                bgt     _test3
                asl     A                       ;A<--arg_by_two
                sub  X1,A                       ;A<--arg_by_two - Pi/4
                neg  A                          ;A<--Pi/4 - arg_by_two
                asl  A                          ;A<--Pi/2 - arg
                move A,X:-(R3)
                jsr  fcos                       ;A<--cos(Pi/2 - arg)
                bra  _return
_test3
                ;If (arg_by_four < (3/16)Pi) then
                ;retval=cos(arg - Pi/2)
                cmp  X0,A
                bgt  _test4
                asl  A                           ;A<--arg_by_two
                sub  X1,A                        ;A<--arg_by_two - Pi/4
                asl  A                           ;A<--arg - Pi/2
                move A,X:-(R3)
                jsr  fcos                        ;A<--cos(arg - Pi/2)
                bra  _return
_test4
                ;If (arg_by_four < Pi/4) then
                ;retval=sin(Pi - arg)
                sub  X1,A                        ;A<--arg_by_four - Pi/4
                neg  A                           ;A<--Pi/4 - arg_by_four
                asl  A                           ;A<--Pi/2 - arg_by_two
                asl  A                           ;A<--Pi - arg
                move A,X:-(R3)
                jsr  fsin                        ;A<--sin(Pi - arg)
_return
                move X:(R2),B                    ;B<--arg
                tst  B                           ;If arg is negative, then...
                bpl  _nonNegative                ;A<-- -result
                neg  A
_nonNegative
                move X:(R3)+,X0        ;Clear stack push for fsin
                move X:(R3)+,R2
                rts
                
                ENDSEC

