#ifndef _MEMORY_H_
#define _MEMORY_H_

#include <stddef.h>

static inline void *memcpy(void *dest, const void *src, size_t count) {
	register int temp;
	register void *retval=dest;
	if (count) {
		asm volatile ("\n\
			 do  %3,_endLoop		\n\
			  move X:(%0)+,%2		\n\
			  move %2,X:(%1)+		\n\
			 _endLoop:" : "=a"(src),"=a"(dest),"=r"(temp)
						: "r"(count),"0"(src),"1"(dest));
	}
	return retval;
}

static inline void *memset(void *dest, int c, size_t count) {
	register void *retval=dest;
	if (count) {
		asm volatile ("\n\
			 do  %2,_endLoop		\n\
			  move %1,X:(%0)+		\n\
			 _endLoop:" : "=a"(dest)
						: "r"(c),"r"(count),"0"(dest));
	}
	return retval;
}

#endif /* _MEMORY_H_ */

