#ifndef _MATH_H_
#define _MATH_H_  

#include <stddef.h> 

static int inline abs(int val) {
	asm("abs  %0" : "=l" (val) : "0" (val));
	return val;
}

static long inline labs(long val) {
	asm("abs  %0" : "=u" (val) : "0" (val));
	return val;
}

static fract inline fabs(fract val) {
	asm("abs  %0" : "=l" (val) : "0" (val));
	return val;
}

static longfract inline dabs(longfract val) {
	asm("abs  %0" : "=u" (val) : "0" (val));
	return val;
}

 
#define M_E 	2.7182818284590452354
	asm("DEFINE " "M_E" " \"" "2.7182818284590452354" "\"");  
#define M_LOG2E 	1.4426950408889634074
	asm("DEFINE " "M_LOG2E" " \"" "1.4426950408889634074" "\"");  
#define M_LOG10E 	0.43429448190325182765
	asm("DEFINE " "M_LOG10E" " \"" "0.43429448190325182765" "\"");  
#define M_LN2 	0.69314718055994530942
	asm("DEFINE " "M_LN2" " \"" "0.69314718055994530942" "\"");  
#define M_LN10 	2.30258509299404568402
	asm("DEFINE " "M_LN10" " \"" "2.30258509299404568402" "\"");  
#define M_PI 	3.14159265358979323846
	asm("DEFINE " "M_PI" " \"" "3.14159265358979323846" "\"");  
#define M_PI_2 	1.57079632679489661923
	asm("DEFINE " "M_PI_2" " \"" "1.57079632679489661923" "\"");  
#define M_PI_4 	0.78539816339744830962
	asm("DEFINE " "M_PI_4" " \"" "0.78539816339744830962" "\"");  
#define M_1_PI 	0.31830988618379067154
	asm("DEFINE " "M_1_PI" " \"" "0.31830988618379067154" "\"");  
#define M_2_PI 	0.63661977236758134308
	asm("DEFINE " "M_2_PI" " \"" "0.63661977236758134308" "\"");  
#define M_2_SQRTPI 	1.12837916709551257390
	asm("DEFINE " "M_2_SQRTPI" " \"" "1.12837916709551257390" "\"");  
#define M_SQRT2 	1.41421356237309504880
	asm("DEFINE " "M_SQRT2" " \"" "1.41421356237309504880" "\"");  
#define M_SQRT1_2 	0.70710678118654752440
	asm("DEFINE " "M_SQRT1_2" " \"" "0.70710678118654752440" "\"");  
#define MAXFLOAT    0.9999694824219
	asm("DEFINE " "MAXFLOAT" " \"" "0.9999694824219" "\"");  
#define MAXDOUBLE   0.999999999534339
	asm("DEFINE " "MAXDOUBLE" " \"" "0.999999999534339" "\"");  
#define MAX_ONE 	  0.999999999999
	asm("DEFINE " "MAX_ONE" " \"" "0.999999999999" "\"");  

extern fract cos(fract arg);
extern longfract ddiv(longfract dividend, fract divisor);
extern longfract drecip(int val);
extern fract fcos(fract arg);
extern fract fdiv(longfract dividend, fract divisor);
extern fract frecip(int val);
extern fract frem(longfract dividend, fract divisor);
extern fract fsin(fract arg);
extern fract sin(fract arg);

static inline longfract dlshift(longfract val, int count) {
	return (longfract)(((long)val) << count);
}

static inline longfract drshift(longfract val, int count) {
	return (longfract)(((long)val) >> count);
}

static inline fract flshift(fract val, int count) {
	return (fract)(((int)val) << count);
}

static inline fract frshift(fract val, int count) {
	return (fract)(((int)val) >> count);
}

#endif /* _MATH_H_ */ 


