;====================================================================
;
; MODULE:
;        fsin
;
; FUNCTION:
;        Calculate the sine of an argument which is limited to the
;        range [-1,1).
;
; C INTERFACE:
;        fract fsin(fract arg)
;
; RETURN VALUE:
;        sin(arg)
;
;====================================================================
                        SECTION LIBM_fsin_asm

                        INCLUDE 'gcc_mac'

;
; fract fsin(fract x)
; -1 <= x < 1
;
                X_CONST_SECTION
SinFactors
            dc  0.00000275573    ; +1/9!
            dc -0.00019841269    ; -1/7!
            dc  0.00833333333    ; +1/5!
            dc -0.16666666666    ; -1/3!
            dc  $7FFF            ; +1

                TEXT_SECTION
                GLOBAL fsin
fsin
                move R2,X:-(R3)
                lea  (R3)+,R2
                move #SinFactors,R0           ;R0<--Taylor series factors
                move X:(R2),X0                ;X0<--arg

                ;Calculate sine of argument using Taylor series:
                ;
                ;                      3       5       7       9
                ;                   arg     arg     arg     arg
                ; sin(arg) = arg - ----- + ----- - ----- + -----
                ;                    3!      5!      7!      9!
                ;
                mpyr X0,X0,B   X:(R0)+,A
                tfr3 B,Y0      X:(R0)+,B
                move Y0,X0
                macr A1,Y0,B   X:(R0)+,A
                macr B1,X0,A   X:(R0)+,B
                macr A1,Y0,B   X:(R0)+,A
                macr B1,X0,A   X:(R2)+,Y0
                mpyr A1,Y0,A
                move X:(R3)+,R2
                rts

                ENDSEC

