;====================================================================
;
; MODULE:
;        frem
;
; FUNCTION:
;        Calculate the 16-bit remainder of a divison. Signed division
;        is supported.
;
; C INTERFACE:
;        fract frem(longfract dividend, fract divisor)
;
; RETURN VALUE:
;        remainder of (dividend/divisor)
;
;====================================================================
                        SECTION LIBM_frem_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; fract frem(longfract dividend, fract divisor)
;
                GLOBAL frem
frem
                move R2,X:-(R3)
                lea  (R3)+,R2
                nop
                move X:(R2)+,A              ;A<--dividend
                move X:(R2)+,A0
                move X:(R2),Y0              ;Y0<--divisor

                abs  A  A,X1                ;A<--|dividend|, X1<--dividend
                andi #$FE,CCR               ;Perform 16-bit divide
                rep  #16
                div  Y0,A                   ;A1<--remainder, A0<--result
                tfr  Y0,B                   ;B<--divisor
                abs  B                      ;B<--|divisor|
                add  B,A                    ;Restore remainder in A1
                move A1,A                   ;Clear A0
                tst  X1                     ;If dividend is negative...
                bpl  _done
                neg  A                      ;A<-- -remainder
_done
                move X:(R3)+,R2
                rts

                ENDSEC

