;====================================================================
;
; MODULE:
;        frecip
;
; FUNCTION:
;        Calculate the 16-bit reciprocal of an integer. Reciprocals of
;        1 and 0 are not defined.
;
; C INTERFACE:
;        fract frecip(int val)
;
; RETURN VALUE:
;        (fract)(1.0/val)
;
;====================================================================
                        SECTION LIBM_frecip_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; fract frecip(int i)
;
                GLOBAL frecip
frecip
                move R2,X:-(R3)
                lea  (R3)+,R2
                move #>1,A               ;A<-- 1x2**(-15)
                move X:(R2),X0           ;X0<-- (val)x2**(-15)
                move #3,N3
                move X0,X:-(R3)          ;fdiv(1x2**(-15), (val)x2**(-15))
                move A0,X:-(R3)
                move A1,X:-(R3)
                jsr  fdiv                ;A<--1/val
                move (R3)+N3
                move X:(R3)+,R2
                rts

                ENDSEC

