;====================================================================
;
; MODULE:
;        fdiv
;
; FUNCTION:
;        Divide a 32-bit dividend by a 16-bit divisor to form a 16-bit
;        result. Signed division is supported.
;
; C INTERFACE:
;        fract fdiv(longfract dividend, fract divisor)
;
; RETURN VALUE:
;        dividend/divisor
;
;====================================================================
                        SECTION LIBM_fdiv_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; fract fdiv(longfract dividend, fract divisor)
;
                GLOBAL fdiv
fdiv
                move R2,X:-(R3)
                lea  (R3)+,R2
                nop
                move X:(R2)+,A              ;A<--dividend
                move X:(R2)+,A0
                move X:(R2),Y0              ;Y0<--divisor

                abs  A  A,B                 ;A<--|dividend|, B<--dividend
                eor  Y0,B                   ;N in CCR<--(sign of result)
                andi #$FE,CCR               ;16-bit division
                rep  #16
                div  Y0,A                   ;A1<--remainder, A0<--result
                bpl  _nonNeg                ;If result should be negative...
                neg  A                      ;A1<-- -remainder, A0<-- -result
_nonNeg            
                move A0,A                   ;A<-- result
                move X:(R3)+,R2
                rts

                ENDSEC

