;====================================================================
;
; MODULE:
;        fcos
;
; FUNCTION:
;        Calculate cosine of the argument which is in the range [-1,1)
;
; C INTERFACE:
;        fract fcos(fract arg)
;
; RETURN VALUE:
;        cos(arg)
;
;====================================================================
                        SECTION LIBM_fcos_asm

                        INCLUDE 'gcc_mac'

;
; fract fcos(fract x)
; -1 <= x < 1
;
                X_CONST_SECTION
CosFactors
            dc  0.00002480159    ; +1/8!
            dc -0.00138888888    ; -1/6!
            dc  0.04166666666    ; +1/4!
            dc -0.50000000000    ; -1/2!
            dc  $7FFF            ; +1

                TEXT_SECTION
                GLOBAL fcos
fcos
                move R2,X:-(R3)
                lea  (R3)+,R2
                move #CosFactors,R0               ;R0<--Taylor series table
                move X:(R2),X0                    ;X0<--arg

                ;Calculate the Taylor series at arg:
                ;
                ;                    2       4       6       8
                ;                 arg     arg     arg     arg
                ; cos(arg) = 1 - ----- + ----- - ----- + -----
                ;                  2!      4!      6!      8!
                ;
                mpyr X0,X0,B   X:(R0)+,A
                tfr3 B,Y0      X:(R0)+,B
                move Y0,X0
                macr A1,Y0,B   X:(R0)+,A
                macr B1,X0,A   X:(R0)+,B
                macr A1,Y0,B   X:(R0)+,A
                macr B1,X0,A
                move X:(R3)+,R2
                rts

                ENDSEC

