;====================================================================
;
; MODULE:
;        drecip
;
; FUNCTION:
;        Calculate the 32-bit reciprocal of a 16-bit integer. The results
;        are undefined for reciprocals of 1 and 0.
;
; C INTERFACE:
;        longfract drecip(int val)
;
; RETURN VALUE:
;        (longfract)(1.0/val)
;
;====================================================================
                        SECTION LIBM_drecip_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; longfract drecip(int val)
;
                GLOBAL drecip
drecip
                move R2,X:-(R3)
                lea  (R3)+,R2
                move #>1,A                  ;A<-- 1x2**(-15)
                move X:(R2),X0              ;X0<--val
                move #3,N3
                move X0,X:-(R3)             ;ddiv(1x2**(-15), (val)x2**(-15))
                move A0,X:-(R3)
                move A1,X:-(R3)
                jsr  ddiv                   ;A<--1/val
                move (R3)+N3
                move X:(R3)+,R2
                rts

                ENDSEC

