;====================================================================
;
; MODULE:
;        divsi3 (GCC5616 library function)
;
; FUNCTION:
;        Divide an int by an int and return the integer result.
;
; C INTERFACE:
;        (Built in integer division)
;
; RETURN VALUE:
;        The value of the division
;
;====================================================================
                        SECTION LIBM_divsi3_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; int divsi3(int dividend, int divisor)
;
                GLOBAL divsi3
divsi3
                move R2,X:-(R3)
                lea  (R3)+,R2
                nop
                move X:(R2),A               ;A<--dividend
                move X:(R2+1),Y0            ;Y0<--divisor

                move A2,A1
                move X:(R2),A0
                asl  A
                abs  A  A,B
                andi #$FE,CCR
                rep  #16
                 div Y0,A
                eor  Y0,B
                bpl  <_nonNeg
                neg  A
_nonNeg         move A0,A

                move X:(R3)+,R2
                rts

                ENDSEC

