;====================================================================
;
; MODULE:
;        ddiv
;        divdf3 (GCC5616 library function)
;
; FUNCTION:
;        Divide a longfract by a fract and return a longfract. Signed divides
;        are supported.
;
; C INTERFACE:
;        longfract ddiv(longfract dividend, fract divisor)
;        longfract divdf3(longfract dividend, longfract divisor)
;
; RETURN VALUE:
;        dividend/divisor
;
;====================================================================
                        SECTION LIBM_ddiv_asm

                        INCLUDE 'gcc_mac'

                TEXT_SECTION
;
; longfract ddiv(longfract dividend, fract divisor)
; NOTE: This can also serve as the 'divdf3' GCC library function:
;         longfract divdf3(longfract dividend, longfract divisor)
; Even though the second parameter is expected to be a longfract, only the
; upper half is used so the routine interface looks exactly the same
; as 'ddiv'
;
                GLOBAL ddiv
                GLOBAL divdf3
ddiv
divdf3
                move R2,X:-(R3)
                lea  (R3)+,R2
                nop
                move X:(R2)+,A              ;A<--dividend
                move X:(R2)+,A0
                move X:(R2),Y0              ;Y0<--divisor

                abs  A  A,B                 ;A<--|dividend|, B<--dividend
                move B1,X1                  ;X1<--(sign of dividend)
                eor  Y0,B                   ;N in CCR<--(sign of result)
                andi #$FE,CCR               ;Perform 16-bit divide
                rep  #16
                div  Y0,A                   ;A0<--result, A1<--remainder
                tfr  A,B                    ;B0<--result, B1<--remainder
                bpl  _nonNeg                ;If result is negative...
                neg  B                      ;B0<-- -result, B1<-- -remainder
_nonNeg
                tfr  Y0,B   B0,Y1           ;B<--divisor, Y1<-- result
                abs  B                      ;B<--|divisor|
                add  A,B                    ;Restore remainder in B1
                move B1,A                   ;A<--remainder (restored)
                tst  X1                     ;If dividend is negative...
                bpl  _done
                neg  A                      ;A<-- -remainder
_done
                asr16 A                     ;A0<-- remainder
                add  Y1,A                   ;A<-- result/remainder
                move X:(R3)+,R2
                rts

                ENDSEC

