;;    GCC5616 -- GCC 1.40 machine description for DSP5616 processors
;;    Copyright (C) 1991,1992 Andrew Sterian and Bell-Northern Research
;;
;;    This program is free software; you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation; either version 1, or (at your option)
;;    any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with the GCC distribution; if not, write to the Free Software
;;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;
;;    Contact the author at 'asterian@bnr.ca' or post to the 'comp.dsp'
;;    newsgroup.

;;
;; Machine description for DSP5616
;;

;;
;; Instructions not needed by RTL
;;

;; DMAC ???

;; IMAC
(define_insn ""
 [(set (match_operand:SI 0 "register_operand" "=l,l")
   (plus:SI (match_operand:SI 1 "register_operand" "0,0")
    (mult:SI (match_operand:SI 2 "register_operand" "%f,e")
             (match_operand:SI 3 "register_operand" "e,f"))))]
 ""
 "imac %w3,%2,%0")

(define_insn ""
 [(set (match_operand:HI 0 "register_operand" "=l,l")
   (plus:HI (match_operand:HI 1 "register_operand" "0,0")
    (mult:HI (match_operand:HI 2 "register_operand" "%f,e")
             (match_operand:HI 3 "register_operand" "e,f"))))]
 ""
 "imac %w3,%2,%0")

(define_insn ""
 [(set (match_operand:QI 0 "register_operand" "=l,l")
   (plus:QI (match_operand:QI 1 "register_operand" "0,0")
    (mult:QI (match_operand:QI 2 "register_operand" "%f,e")
             (match_operand:QI 3 "register_operand" "e,f"))))]
 ""
 "imac %w3,%2,%0")

;; MAC
(define_insn ""
 [(set (match_operand:SF 0 "register_operand" "=l,l")
   (plus:SF (match_operand:SF 1 "register_operand" "0,0")
    (mult:SF (match_operand:SF 2 "register_operand" "%f,e")
             (match_operand:SF 3 "register_operand" "e,f"))))]
 ""
 "*
{
	extendReg(operands[0]);
	return \"macr %w3,%2,%0\";
}")

;; MAC(su,uu) ???

;; ADDL/ADDR
;; Don't know what to do if source/dest are the same

;(define_insn "tleu"
; [(set (match_operand:SI 0 "register_operand" "l")
;   (if_then_else (leu (cc0) (const_int 0))
;        (match_operand:SI 1 "register_operand" "C")
;		(match_dup 0)))]
; ""
; "tle  %1,%0")

;;
;; Move instructions
;;

;; Explicit references to X:(A1) or X:(B1) since the configuration
;; file description of what's a valid base register and what is not
;; does not seem to work.  We must also allow the address registers
;; as well or the reload pass can't constrain.
(define_insn ""
 [(set (match_operand:QI 0 "register_operand" "=r")
       (mem:QI (match_operand:SI 1 "register_operand" "b")))]
 ""
 "*{ regValid[REGNO(operands[0])]=1;
	 return \"move X:(%w1),%0\";
}")

(define_insn ""
 [(set (mem:QI (match_operand:SI 0 "register_operand" "b"))
       (match_operand:QI 1 "register_operand" "r"))]
 ""
 "move %w1,X:(%w0)")

(define_insn ""
 [(set (match_operand:HI 0 "register_operand" "=r")
       (mem:HI (match_operand:SI 1 "register_operand" "b")))]
 ""
 "*{ regValid[REGNO(operands[0])]=1;
	 return \"move X:(%w1),%0\";
}")

(define_insn ""
 [(set (mem:HI (match_operand:SI 0 "register_operand" "b"))
       (match_operand:HI 1 "register_operand" "r"))]
 ""
 "move %w1,X:(%w0)")

(define_insn ""
 [(set (match_operand:SI 0 "register_operand" "=r")
       (mem:SI (match_operand:SI 1 "register_operand" "b")))]
 ""
 "*{ regValid[REGNO(operands[0])]=1;
	 return \"move X:(%w1),%0\";
}")

(define_insn ""
 [(set (mem:SI (match_operand:SI 0 "register_operand" "b"))
       (match_operand:SI 1 "register_operand" "r"))]
 ""
 "move %w1,X:(%w0)")

(define_insn ""
 [(set (match_operand:SF 0 "register_operand" "=r")
       (mem:SF (match_operand:SI 1 "register_operand" "b")))]
 ""
 "*{ regValid[REGNO(operands[0])]=1;
	 return \"move X:(%w1),%0\";
}")

(define_insn ""
 [(set (mem:SF (match_operand:SI 0 "register_operand" "b"))
       (match_operand:SF 1 "register_operand" "r"))]
 ""
 "move %w1,X:(%w0)")

(define_insn "movqi"
 [(set (match_operand:QI 0 "general_operand" "=r,m,r")
       (match_operand:QI 1 "general_operand" "r,r,mi"))]
 ""
 "*
{
    int reg0,reg1;
    switch(which_alternative) {
     case 0:    /* Register-to-register */
        reg0 = REGNO(operands[0]); reg1 = REGNO(operands[1]);
		if (reg0==reg1) return \";reg->reg\";
		regValid[reg0] = 1;
        if ((reg0==5) || (reg0==8)) {
			if (reg1 > 3)
				regValid[reg0] = regValid[reg1];
            if (reg1 < 9) {
                return \"tfr  %1,%0\";
            }
        }
        return \"move %w1,%0\";

     case 1:    /* Register-to-memory */
        output_preloadN(operands[0]);
        return \"move %w1,%0\";

     case 2:    /* Memory/immediate-to-register */
        reg0 = REGNO(operands[0]);
		regValid[reg0] = 1;
		output_preloadN(operands[1]);
        if ((reg0==5) || (reg0==8)) {
			if (GET_CODE(operands[1]) == CONST_INT) {
				if (INTVAL(operands[1]) == 0) {
					return \"clr  %0\";
				}
			}
		} else if (reg0 < 4)
			return \"move %s1,%0\";	/* Candidate for movei */
       	return \"move %1,%0\";
    }
}")

(define_insn "movhi"
 [(set (match_operand:HI 0 "general_operand" "=r,m,r")
       (match_operand:HI 1 "general_operand" "r,r,mi"))]
 ""
 "*
{
    int reg0,reg1;
    switch(which_alternative) {
     case 0:    /* Register-to-register */
        reg0 = REGNO(operands[0]); reg1 = REGNO(operands[1]);
		if (reg0==reg1) return \";reg->reg\";
		regValid[reg0] = 1;
        if ((reg0==5) || (reg0==8)) {
			if (reg1 > 3)
				regValid[reg0] = regValid[reg1];
            if (reg1 < 9) {
                return \"tfr  %1,%0\";
            }
        }
        return \"move %w1,%0\";

     case 1:    /* Register-to-memory */
        output_preloadN(operands[0]);
        return \"move %w1,%0\";

     case 2:    /* Memory/immediate-to-register */
        reg0 = REGNO(operands[0]);
		regValid[reg0] = 1;
		output_preloadN(operands[1]);
        if ((reg0==5) || (reg0==8)) {
			if (GET_CODE(operands[1]) == CONST_INT) {
				if (INTVAL(operands[1]) == 0) {
					return \"clr  %0\";
				}
			}
		} else if (reg0 < 4)
			return \"move %s1,%0\";
       	return \"move %1,%0\";
    }
}")

(define_insn "movsi"
 [(set (match_operand:SI 0 "general_operand" "=r,m,r")
       (match_operand:SI 1 "general_operand" "r,r,mi"))]
 ""
 "*
{
	int reg0, reg1;

    switch(which_alternative) {
     case 0:        /* Register-to-register */
        reg0 = REGNO(operands[0]); reg1 = REGNO(operands[1]);
		if (reg0==reg1) return \";reg->reg\";
		regValid[reg0] = 1;
        if ((reg0==5) || (reg0==8)) {
			if (reg1 > 3)
				regValid[reg0] = regValid[reg1];
            if ((reg1 < 4)  || (reg1==5) || (reg1==8)) {
                return \"tfr  %1,%0\";
            }
        }
        return \"move %w1,%0\";

     case 1:    /* Register-to-memory */
        output_preloadN(operands[0]);
        return \"move %w1,%0\";

     case 2:    /* Memory/immediate-to-register */
        reg0 = REGNO(operands[0]);
		regValid[reg0] = 1;
		output_preloadN(operands[1]);
        if ((reg0==5) || (reg0==8)) {
			if (GET_CODE(operands[1]) == CONST_INT) {
				if (INTVAL(operands[1]) == 0) {
					return \"clr  %0\";
				}
			}
		} else if (reg0 < 4)
			return \"move %s1,%0\";
       	return \"move %1,%0\";
    }
}")

(define_insn "movdi"
 [(set (match_operand:DI 0 "general_operand" "=m,A,A,A,A")
       (match_operand:DI 1 "general_operand" "A,A,m,F,n"))]
 ""
 "*
{
	int intLow, intHigh;
	char *p;
	rtx xoperands[2];
	int reg0, reg1;

	switch(which_alternative) {
     case 0:	/* Register-to-memory */
		double_reg_to_memory(operands);
		return \"\";

	 case 1:	/* Register-to-register */
		reg0 = REGNO(operands[0]); reg1 = REGNO(operands[1]);
		if (reg0==reg1) return \";reg->reg\";
		regValid[reg0] = 1;
        if ((reg0==5) || (reg0==8)) {
			if (reg1 > 3)
				regValid[reg0] = regValid[reg1];
			return \"tfr  %1,%0\";
		}
        if ((reg1==5) || (reg1==8)) {
            return \"tfr2 %1,%0\";
        }
        return \"move %x1,%x0\;move %y1,%y0\";

	 case 2:	/* Memory-to-register */
		double_reg_from_memory(operands);
		regValid[REGNO(operands[0])] = 1;
		return \"\";

	 case 3:	/* ConstantDouble-to-register */
        intLow = CONST_DOUBLE_LOW(operands[1]) & 0xFFFF;
        intHigh = (CONST_DOUBLE_LOW(operands[1]) >> 16) & 0xFFFF;
		
		regValid[REGNO(operands[0])] = 1;
		xoperands[0] = operands[0];
		xoperands[1] = gen_rtx(CONST_INT, VOIDmode, intHigh);
		if (REGNO(operands[0]) < 4)
			p = \"move %s1,%y0\";	/* Moves into X1, Y1 */
		else						/* Moves into A, B */
			if (intHigh == 0) 
				p = \"clr  %0\";
			else
				p = \"move %1,%0\";
		output_asm_insn(p, xoperands);

		xoperands[1] = gen_rtx(CONST_INT, VOIDmode, intLow);
		if (REGNO(operands[0]) > 3) {
			if (intLow == 0)
				return \"\";
			else
				output_asm_insn(\"move %1,%x0\", xoperands);
		} else
			output_asm_insn( \"move %s1,%x0\", xoperands );

		return \"\";

	 case 4:	/* ConstantInt-to-register */
		regValid[REGNO(operands[0])] = 1;
		if (REGNO(operands[0]) < 4) {
			output_asm_insn(\"move %s1,%x0\", operands);
			return \"move #0,%y0\";
		} else {
			if (INTVAL(operands[1]) == 0)
				return \"clr  %0\";
			else
				return \"clr  %0\;move %1,%x0\";
		}
	}
}")

(define_insn "movsf"
 [(set (match_operand:SF 0 "general_operand" "=r,m,r,r")
       (match_operand:SF 1 "general_operand" "r,r,m,F"))]
 ""
 "*
{
    int intVal;
    int reg0, reg1;
    rtx xoperands[2];

    switch(which_alternative) {
     case 0:        /* Register-to-register */
        reg0 = REGNO(operands[0]); reg1 = REGNO(operands[1]);
		if (reg0==reg1) return \";reg->reg\";
		regValid[reg0] = 1;
        if ((reg0==5) || (reg0==8)) {
			if (reg1 > 3)
				regValid[reg0] = regValid[reg1];
            if ((reg1 < 4)  || (reg1==5) || (reg1==8)) {
                return \"tfr  %1,%0\";
            }
        }
        return \"move %w1,%0\";

     case 1:    /* Register-to-memory */
        output_preloadN(operands[0]);
        return \"move %w1,%0\";

     case 2:    /* Memory-to-register */
        output_preloadN(operands[1]);
		regValid[REGNO(operands[0])] = 1;
        return \"move %1,%0\";

     case 3:    /* Float-to-register */
        reg0 = REGNO(operands[0]);
        if (!const_double_to_SF(operands[1], &intVal))
			error(\"Illegal floating point value\");
		
		regValid[reg0] = 1;
        if ((intVal == 0) && ((reg0==5) || (reg0==8))) {
			return \"clr  %0\";
		}
		xoperands[1] = gen_rtx(CONST_INT, VOIDmode, intVal);
		xoperands[0] = operands[0];
		if (reg0 < 4)
			output_asm_insn(\"move %s1,%0\", xoperands);
		else
			output_asm_insn(\"move %1,%0\", xoperands);
		return \"\";
    }
}")

(define_insn "movdf"
 [(set (match_operand:DF 0 "general_operand" "=m,A,A,A")
       (match_operand:DF 1 "general_operand" "A,A,m,F"))]
 ""
 "*
{
	int intLow, intHigh;
	rtx xoperands[2];
	char *p;
	int reg0, reg1;

	switch(which_alternative) {
     case 0:	/* Register-to-memory */
		double_reg_to_memory(operands);
		return \"\";

	 case 1:	/* Register-to-register */
		reg0 = REGNO(operands[0]); reg1 = REGNO(operands[1]);
		if (reg0==reg1) return \";reg->reg\";
		regValid[reg0] = 1;
        if ((reg0==5) || (reg0==8)) {
			if (reg1 > 3)
				regValid[reg0] = regValid[reg1];
            return \"tfr  %1,%0\";
        }
        if ((reg1==5) || (reg1==8)) {
            return \"tfr2 %1,%0\";
        }
        return \"move %x1,%x0\;move %y1,%y0\";

	 case 2:	/* Memory-to-register */
		double_reg_from_memory(operands);
		regValid[REGNO(operands[0])] = 1;
		return \"\";

	 case 3:	/* Constant-to-register */
		if (!const_double_to_DF(operands[1], &intHigh, &intLow)) 
			error(\"Illegal floating point value\");
		
		regValid[REGNO(operands[0])] = 1;
		xoperands[0] = operands[0];
		xoperands[1] = gen_rtx(CONST_INT, VOIDmode, intHigh);
		if (REGNO(operands[0]) < 4)
			p = \"move %s1,%y0\";	/* Moves into X1 or Y1 */
		else
			if (intHigh == 0)
				p = \"clr  %0\";
			else
				p = \"move %1,%0\";		/* Moves into A, B */
		output_asm_insn(p, xoperands);

		xoperands[1] = gen_rtx(CONST_INT, VOIDmode, intLow);
		if (REGNO(operands[0]) > 3)
			if (intLow == 0)
				return \"\";
			else
				output_asm_insn(\"move %1,%x0\", xoperands);
		else
			output_asm_insn(\"move %s1,%x0\", xoperands);

		return \"\";
	}
}")

;; The second operand should really be declared commutative but I'm
;; worried about the effects of having different predicates for the
;; two commutative operands
(define_insn "addqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
    (plus:QI (match_operand:QI 1 "register_operand" "0")
             (match_operand:QI 2 "nonmemory_operand" "CI")))]
 ""
 "* { return mathOpInsn(operands, ADD_56K); }")

(define_insn "addhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (plus:HI (match_operand:HI 1 "register_operand" "0")
            (match_operand:HI 2 "nonmemory_operand" "CI")))]
 ""
 "* { return mathOpInsn(operands, ADD_56K); }")

(define_insn "addsi3"
 [(set (match_operand:SI 0 "register_operand" "=l,?a")
   (plus:SI (match_operand:SI 1 "register_operand" "0,a")
            (match_operand:SI 2 "nonmemory_operand" "CI,g")))]
 ""
 "*
{
	if (which_alternative==0)
    	return mathOpInsn(operands, ADD_56K);
	else {
		int same = (REGNO(operands[0]) == REGNO(operands[1]));
    	int plus=0,minus=0;
		rtx xoperands[2];

		if (GET_CODE(operands[2]) == CONST_INT) {
        	plus  = (INTVAL(operands[2]) == 1);
			minus = (INTVAL(operands[2]) == -1);
		}
    	if (plus)
        	return \"lea  (%1)+,%0\";
		if (minus)
        	return (same ? \"move (%0)-\" : \"lea  (%1)-,%0\");
    	xoperands[0] = gen_rtx(REG, SImode, REGNO(operands[1])+8);
		xoperands[1] = operands[2];
        output_asm_insn(\"move %1,%0\", xoperands);
    	return (same ? \"move (%0)+N\" : \"lea  (%1)+N,%0\");
	}
}")
	
(define_insn "adddi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (plus:DI (match_operand:DI 1 "register_operand" "0")
            (match_operand:DI 2 "nonmemory_operand" "AI")))]
 ""
 "* { return mathOpInsn(operands, ADD_56K); }")

(define_insn "addsf3"
 [(set (match_operand:SF 0 "register_operand" "=l")
   (plus:SF (match_operand:SF 1 "register_operand" "%0")
            (match_operand:SF 2 "register_operand" "C")))]
 ""
 "* { return mathOpInsn(operands, ADD_56K); }")

(define_insn "adddf3"
 [(set (match_operand:DF 0 "register_operand" "=u")
   (plus:DF (match_operand:DF 1 "register_operand" "%0")
            (match_operand:DF 2 "register_operand" "A")))]
 ""
 "* { return mathOpInsn(operands, ADD_56K); }")

(define_insn "subqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
    (minus:QI  (match_operand:QI 1 "register_operand" "0")
            (match_operand:QI 2 "nonmemory_operand" "CI")))]
 ""
 "* { return mathOpInsn(operands, SUB_56K); }")

(define_insn "subhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (minus:HI   (match_operand:HI 1 "register_operand" "0")
            (match_operand:HI 2 "nonmemory_operand" "CI")))]
 ""
 "* { return mathOpInsn(operands, SUB_56K); }")

(define_insn "subsi3"
 [(set (match_operand:SI 0 "register_operand" "=l,?a")
   (minus:SI   (match_operand:SI 1 "register_operand" "0,a")
            (match_operand:SI 2 "nonmemory_operand" "CI,n")))]
 ""
 "*
{
	if (which_alternative==0)
		return mathOpInsn(operands, SUB_56K);
	else {
		int same = (REGNO(operands[0]) == REGNO(operands[1]));
    	int plus=0,minus=0;
		rtx xoperands[2];
	
		if (GET_CODE(operands[2]) == CONST_INT) {
        	plus  = (INTVAL(operands[2]) == -1);
			minus = (INTVAL(operands[2]) == 1);
		}
    	if (plus)
        	return \"lea  (%1)+,%0\";
		if (minus)
        	return (same ? \"move (%0)-\" : \"lea  (%1)-,%0\");
    	xoperands[0] = gen_rtx(REG, SImode, REGNO(operands[1])+8);
		xoperands[1] = gen_rtx(CONST_INT, SImode, -INTVAL(operands[2]));
		output_asm_insn(\"move %1,%0\", xoperands);
    	return (same ? \"move (%0)+N\" : \"lea  (%1)+N,%0\");
	}
}")
	
(define_insn "subdi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (minus:DI   (match_operand:DI 1 "register_operand" "0")
            (match_operand:DI 2 "nonmemory_operand" "AI")))]
 ""
 "* { return mathOpInsn(operands, SUB_56K); }")

(define_insn "subsf3"
 [(set (match_operand:SF 0 "register_operand" "=l")
   (minus:SF   (match_operand:SF 1 "register_operand" "0")
            (match_operand:SF 2 "register_operand" "C")))]
 ""
 "* { return mathOpInsn(operands, SUB_56K); }")

(define_insn "subdf3"
 [(set (match_operand:DF 0 "register_operand" "=u")
   (minus:DF   (match_operand:DF 1 "register_operand" "0")
            (match_operand:DF 2 "register_operand" "A")))]
 ""
 "* { return mathOpInsn(operands, SUB_56K); }")

(define_insn "mulqi3"
 [(set (match_operand:QI 0 "register_operand" "=l,l")
   (mult:QI (match_operand:QI 1 "register_operand" "%f,e")
            (match_operand:QI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "mulhi3"
 [(set (match_operand:HI 0 "register_operand" "=l,l")
   (mult:HI (match_operand:HI 1 "register_operand" "%f,e")
            (match_operand:HI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "mulsi3"
 [(set (match_operand:SI 0 "register_operand" "=l,l")
   (mult:SI (match_operand:SI 1 "register_operand" "%f,e")
            (match_operand:SI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "mulsf3"
 [(set (match_operand:SF 0 "register_operand" "=l,l")
   (mult:SF (match_operand:SF 1 "register_operand" "%f,e")
            (match_operand:SF 2 "register_operand" "e,f")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 1;
	 return \"mpyr %2,%1,%0\";
}")

; A klugy implementation of muldf
(define_insn "muldf3"
 [(set (match_operand:DF 0 "register_operand" "=u,u")
   (mult:DF (match_operand:DF 1 "register_operand" "%f,e")
            (match_operand:DF 2 "register_operand" "e,f")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 1;
	 return \"mpyr %y2,%y1,%0\";
}")

(define_insn "umulqi3"
 [(set (match_operand:QI 0 "register_operand" "=l,l")
   (umult:QI (match_operand:QI 1 "register_operand" "%f,e")
            (match_operand:QI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "umulhi3"
 [(set (match_operand:HI 0 "register_operand" "=l,l")
   (umult:HI (match_operand:HI 1 "register_operand" "%f,e")
            (match_operand:HI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "umulsi3"
 [(set (match_operand:SI 0 "register_operand" "=l,l")
   (umult:SI (match_operand:SI 1 "register_operand" "%f,e")
            (match_operand:SI 2 "register_operand" "e,f")))]
 ""
 "impy  %2,%1,%0")

(define_insn "andqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (and:QI  (match_operand:QI 1 "register_operand" "%0")
            (match_operand:QI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"and  %2,%0\";
}")

(define_insn "andhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (and:HI  (match_operand:HI 1 "register_operand" "%0")
            (match_operand:HI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"and  %2,%0\";
}")

(define_insn "andsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (and:SI  (match_operand:SI 1 "register_operand" "%0")
            (match_operand:SI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"and  %2,%0\";
}")

(define_insn "anddi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (and:DI	(match_operand:DI 1 "register_operand" "%0")
			(match_operand:DI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"and  %y2,%0\;swap %0\;and  %x2,%0\;swap %0\";
}")

(define_insn "iorqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (ior:QI  (match_operand:QI 1 "register_operand" "%0")
            (match_operand:QI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"or   %2,%0\";
}")

(define_insn "iorhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (ior:HI  (match_operand:HI 1 "register_operand" "%0")
            (match_operand:HI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"or   %2,%0\";
}")

(define_insn "iorsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (ior:SI  (match_operand:SI 1 "register_operand" "%0")
            (match_operand:SI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"or   %2,%0\";
}")

(define_insn "iordi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (ior:DI	(match_operand:DI 1 "register_operand" "%0")
			(match_operand:DI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
     return \"or   %y2,%0\;swap %0\;or   %x2,%0\;swap %0\";
}")

(define_insn "xorqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (xor:QI  (match_operand:QI 1 "register_operand" "%0")
            (match_operand:QI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"eor  %2,%0\";
}")

(define_insn "xorhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (xor:HI  (match_operand:HI 1 "register_operand" "%0")
            (match_operand:HI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"eor  %2,%0\";
}")

(define_insn "xorsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (xor:SI  (match_operand:SI 1 "register_operand" "%0")
            (match_operand:SI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"eor  %2,%0\";
}")

(define_insn "xordi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (xor:DI	(match_operand:DI 1 "register_operand" "%0")
			(match_operand:DI 2 "register_operand" "d")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"eor  %y2,%0\;swap %0\;eor  %x2,%0\;swap %0\";
}")

(define_insn "mulhisi3"
 [(set (match_operand:SI 0 "register_operand" "=l,l")
   (mult:HI (match_operand:HI 1 "register_operand" "%f,e")
            (match_operand:HI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "mulhidi3"
 [(set (match_operand:DI 0 "register_operand" "=u,u")
   (mult:HI (match_operand:HI 1 "register_operand" "%f,e")
            (match_operand:HI 2 "register_operand" "e,f")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 1;
	 return \"mpy  %2,%1,%0\;asr  %0\";
}")

(define_insn "mulqihi3"
 [(set (match_operand:HI 0 "register_operand" "=l,l")
   (mult:QI (match_operand:QI 1 "register_operand" "%f,e")
            (match_operand:QI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "mulsidi3"
 [(set (match_operand:DI 0 "register_operand" "=u,u")
   (mult:SI (match_operand:SI 1 "register_operand" "%f,e")
            (match_operand:SI 2 "register_operand" "e,f")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 1;
	 return \"mpy  %2,%1,%0\;asr  %0\";
}")

(define_insn "umulqihi3"
 [(set (match_operand:HI 0 "register_operand" "=l,l")
   (umult:QI (match_operand:QI 1 "register_operand" "%f,e")
            (match_operand:QI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "umulhisi3"
 [(set (match_operand:SI 0 "register_operand" "=l,l")
   (umult:HI (match_operand:HI 1 "register_operand" "%f,e")
            (match_operand:HI 2 "register_operand" "e,f")))]
 ""
 "impy %2,%1,%0")

(define_insn "umulhidi3"
 [(set (match_operand:DI 0 "register_operand" "=u,u")
   (umult:HI (match_operand:HI 1 "register_operand" "%f,e")
            (match_operand:HI 2 "register_operand" "e,f")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 1;
	 return \"mpy  %2,%1,%0\;asr  %0\";
}")

(define_insn "umulsidi3"
 [(set (match_operand:DI 0 "register_operand" "=u,u")
   (umult:SI (match_operand:SI 1 "register_operand" "%f,e")
            (match_operand:SI 2 "register_operand" "e,f")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 1;
	 return \"mpy  %2,%1,%0\;asr  %0\";
}")

; Would like to be able to spec. "rmJ" for third operand but
; "rep X:(R+N) is not allowed, only "rep X:(R)" and I don't quite
; know how to cleanly specify this
(define_insn "ashlqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (ashift:QI (match_operand:QI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHL_56K); }")

(define_insn "ashlhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (ashift:HI (match_operand:HI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHL_56K); }")

(define_insn "ashlsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (ashift:SI (match_operand:SI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHL_56K); }")

(define_insn "ashldi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (ashift:DI (match_operand:DI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHL_56K); }")

(define_insn "ashlsf3"
 [(set (match_operand:SF 0 "register_operand" "=l")
   (ashift:SF (match_operand:SF 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHL_56K); }")

(define_insn "ashldf3"
 [(set (match_operand:DF 0 "register_operand" "=u")
   (ashift:DF (match_operand:DF 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHL_56K); }")

(define_insn "ashrqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (ashiftrt:QI (match_operand:QI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHR_56K); }")

(define_insn "ashrhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (ashiftrt:HI (match_operand:HI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHR_56K); }")

(define_insn "ashrsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHR_56K); }")

(define_insn "ashrdi3"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHR_56K); }")

(define_insn "ashrsf3"
 [(set (match_operand:SF 0 "register_operand" "=l")
   (ashiftrt:SF (match_operand:SF 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHR_56K); }")

(define_insn "ashrdf3"
 [(set (match_operand:DF 0 "register_operand" "=u")
   (ashiftrt:DF (match_operand:DF 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ASHR_56K); }")

(define_insn "lshlqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (lshift:QI (match_operand:QI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, LSHL_56K); }")

(define_insn "lshlhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (lshift:HI (match_operand:HI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, LSHL_56K); }")

(define_insn "lshlsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (lshift:SI (match_operand:SI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, LSHL_56K); }")

(define_insn "lshrqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (lshiftrt:QI (match_operand:QI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, LSHR_56K); }")

(define_insn "lshrhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (lshiftrt:HI (match_operand:HI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, LSHR_56K); }")

(define_insn "lshrsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (lshiftrt:SI (match_operand:SI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, LSHR_56K); }")

(define_insn "rotlqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (rotate:QI (match_operand:QI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ROTL_56K); }")

(define_insn "rotlhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (rotate:HI (match_operand:HI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ROTL_56K); }")

(define_insn "rotlsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (rotate:SI (match_operand:SI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ROTL_56K); }")

(define_insn "rotrqi3"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (rotatert:QI (match_operand:QI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ROTR_56K); }")

(define_insn "rotrhi3"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (rotatert:HI (match_operand:HI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ROTR_56K); }")

(define_insn "rotrsi3"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (rotatert:SI (match_operand:SI 1 "register_operand" "0")
              (match_operand:SI 2 "nonmemory_operand" "rJ")))]
 ""
 "* { return shiftOpInsn(operands, ROTR_56K); }")

(define_insn "negqi2"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (neg:QI (match_operand:QI 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "neghi2"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (neg:HI (match_operand:HI 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "negsi2"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (neg:SI (match_operand:SI 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "negsf2"
 [(set (match_operand:SF 0 "register_operand" "=l")
   (neg:SF (match_operand:SF 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "negdf2"
 [(set (match_operand:DF 0 "register_operand" "=u")
   (neg:DF (match_operand:DF 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "abssf2"
 [(set (match_operand:SF 0 "register_operand" "=l")
   (abs:SF (match_operand:SF 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "absdf2"
 [(set (match_operand:DF 0 "register_operand" "=u")
   (abs:DF (match_operand:DF 1 "register_operand" "0")))]
 ""
 "*{ extendReg(operands[0]);
	 return \"neg  %0\";
}")

(define_insn "one_cmplqi2"
 [(set (match_operand:QI 0 "register_operand" "=l")
   (not:QI (match_operand:QI 1 "register_operand" "0")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"not  %0\";
}")

(define_insn "one_cmplhi2"
 [(set (match_operand:HI 0 "register_operand" "=l")
   (not:HI (match_operand:HI 1 "register_operand" "0")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"not  %0\";
}")

(define_insn "one_cmplsi2"
 [(set (match_operand:SI 0 "register_operand" "=l")
   (not:SI (match_operand:SI 1 "register_operand" "0")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
	 return \"not  %0\";
}")

(define_insn "one_cmpldi2"
 [(set (match_operand:DI 0 "register_operand" "=u")
   (not:DI (match_operand:DI 1 "register_operand" "0")))]
 ""
 "*{ regValid[REGNO(operands[0])] = 0;
     return \"not  %0\;swap %0\;not  %0\;swap %0\";
}")

; This is one of the imponderables of the compiler...it can actually
; generate an instruction of the form 'cmp A,A'.  We deal with this
; in NOTICE_UPDATE_CC by setting CC_ALWAYS_TRUE and by using this RTL
; code to not output anything.
(define_insn ""
 [(set (cc0) (compare (match_operand 0 "register_operand" "l")
					  (match_dup 0)))]
 ""
 ";cmp reg,reg")

(define_insn "cmpqi"
 [(set (cc0) (compare (match_operand:QI 0 "register_operand" "l")
                      (match_operand:QI 1 "register_operand" "C")))]
 ""
 "*{ extendReg(operands[0]); extendReg(operands[1]);
	  return \"cmp  %1,%0\";
}")

(define_insn "cmphi"
 [(set (cc0) (compare (match_operand:HI 0 "register_operand" "l")
                      (match_operand:HI 1 "register_operand" "C")))]
 ""
 "*{ extendReg(operands[0]); extendReg(operands[1]);
	  return \"cmp  %1,%0\";
}")

(define_insn "cmpsi"
 [(set (cc0) (compare (match_operand:SI 0 "register_operand" "l")
                      (match_operand:SI 1 "register_operand" "C")))]
 ""
 "*{ extendReg(operands[0]); extendReg(operands[1]);
	  return \"cmp  %1,%0\";
}")

(define_insn "cmpdi"
 [(set (cc0) (compare (match_operand:DI 0 "register_operand" "u")
                      (match_operand:DI 1 "register_operand" "u")))]
 ""
 "*{ extendReg(operands[0]); extendReg(operands[1]);
	  return \"cmp  %1,%0\";
}")

(define_insn "cmpsf"
 [(set (cc0) (compare (match_operand:SF 0 "register_operand" "l")
                      (match_operand:SF 1 "register_operand" "C")))]
 ""
 "*{ extendReg(operands[0]); extendReg(operands[1]);
	  return \"cmp  %1,%0\";
}")

(define_insn "cmpdf"
 [(set (cc0) (compare (match_operand:DF 0 "register_operand" "u")
                      (match_operand:DF 1 "register_operand" "u")))]
 ""
 "*{ extendReg(operands[0]); extendReg(operands[1]);
	  return \"cmp  %1,%0\";
}")

(define_insn "tstqi"
 [(set (cc0) (match_operand:QI 0 "register_operand" "C"))]
 ""
 "*{ extendReg(operands[0]);
	  return \"tst  %0\";
}")

(define_insn "tsthi"
 [(set (cc0) (match_operand:HI 0 "register_operand" "C"))]
 ""
 "*{ extendReg(operands[0]);
	  return \"tst  %0\";
}")

(define_insn "tstsi"
 [(set (cc0) (match_operand:SI 0 "register_operand" "C"))]
 ""
 "*{ extendReg(operands[0]);
	  return \"tst  %0\";
}")

(define_insn "tstdi"
 [(set (cc0) (match_operand:DI 0 "register_operand" "u"))]
 ""
 "*{ extendReg(operands[0]);
	  return \"tst  %0\";
}")

(define_insn "tstsf"
 [(set (cc0) (match_operand:SF 0 "register_operand" "C"))]
 ""
 "*{ extendReg(operands[0]);
	  return \"tst  %0\";
}")

(define_insn "tstdf"
 [(set (cc0) (match_operand:DF 0 "register_operand" "u"))]
 ""
 "*{ extendReg(operands[0]);
	  return \"tst  %0\";
}")

(define_insn "floatqisf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (float:SF (match_operand:QI 1 "register_operand" "0")))]
 ""
 "; QI->SF")

(define_insn "floathisf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (float:SF (match_operand:HI 1 "register_operand" "0")))]
 ""
 "; HI->SF")

(define_insn "floatsisf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (float:SF (match_operand:SI 1 "register_operand" "0")))]
 ""
 "; SI->SF")

(define_insn "floatdidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (float:DI (match_operand:DI 1 "register_operand" "0")))]
 ""
 "; DI->DF")

(define_insn "floatunsqisf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (unsigned_float:SF (match_operand:QI 1 "register_operand" "0")))]
 ""
 "; UQI->SF")

(define_insn "floatunshisf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (unsigned_float:SF (match_operand:HI 1 "register_operand" "0")))]
 ""
 "; UHI->SF")

(define_insn "floatunssisf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (unsigned_float:SF (match_operand:SI 1 "register_operand" "0")))]
 ""
 "; USI->SF")

(define_insn "floatqidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (float:DF (match_operand:QI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {		/* Destination is X or Y */
		if (reg0 != reg1) output_asm_insn(\"move %w1,%y0\", operands);
		return \"move #0,%x0\";
	}
	return \"move %w1,%0\";
}")

(define_insn "floathidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (float:DF (match_operand:HI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {		/* Destination is X or Y */
		if (reg0 != reg1) output_asm_insn(\"move %w1,%y0\", operands);
		return \"move #0,%x0\";
	}
	return \"move %w1,%0\";
}")

(define_insn "floatsidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (float:DF (match_operand:SI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {		/* Destination is X or Y */
		if (reg0 != reg1) output_asm_insn(\"move %w1,%y0\", operands);
		return \"move #0,%x0\";
	}
	return \"move %w1,%0\";
}")

(define_insn "floatunsqidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (unsigned_float:DF (match_operand:QI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {		/* Destination is X or Y */
		if (reg0 != reg1) output_asm_insn(\"move %w1,%y0\", operands);
		return \"move #0,%x0\";
	}
	return \"move %w1,%0\";
}")

(define_insn "floatunshidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (unsigned_float:DF (match_operand:HI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {		/* Destination is X or Y */
		if (reg0 != reg1) output_asm_insn(\"move %w1,%y0\", operands);
		return \"move #0,%x0\";
	}
	return \"move %w1,%0\";
}")

(define_insn "floatunssidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (unsigned_float:DF (match_operand:SI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {		/* Destination is X or Y */
		if (reg0 != reg1) output_asm_insn(\"move %w1,%y0\", operands);
		return \"move #0,%x0\";
	}
	return \"move %w1,%0\";
}")

(define_insn "floatunsdidf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (unsigned_float:DF (match_operand:DI 1 "register_operand" "0")))]
 ""
 "; DI->DF")

(define_insn "fixsfsi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (fix:SI (match_operand:SF 1 "register_operand" "0")))]
 ""
 ";SF->SI")

(define_expand "fix_truncsfsi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (fix:SI (match_operand:SF 1 "register_operand" "0")))]
 ""
 "")

(define_insn "fixdfsi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (fix:SI (match_operand:DF 1 "register_operand" "A")))]
 ""
 "*
{
	int reg0 = REGNO(operands[0]);
	int reg1 = REGNO(operands[1]);

	if (reg0 != reg1) {
		regValid[reg0] = 1;
		return \"move %y1,%0\";
	} else {
		return \";DF->SI\";
	}
}")

(define_insn "fixdfdi2"
 [(set (match_operand:DI 0 "register_operand" "=A")
   (fix:DI (match_operand:DF 1 "register_operand" "0")))]
 ""
 ";DF->DI")

(define_expand "fix_truncdfdi2"
 [(set (match_operand:DI 0 "register_operand" "=A")
   (fix:DI (match_operand:DF 1 "register_operand" "0")))]
 ""
 "")

(define_insn "fixunssfsi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (unsigned_fix:SI (match_operand:SF 1 "register_operand" "0")))]
 ""
 ";USF->SI")

(define_expand "fixuns_truncsfsi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (unsigned_fix:SI (match_operand:SF 1 "register_operand" "0")))]
 ""
 "")

(define_insn "fixunsdfsi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (unsigned_fix:SI (match_operand:DF 1 "register_operand" "A")))]
 ""
 "*
{
	if (REGNO(operands[0]) != REGNO(operands[1])) {
		regValid[REGNO(operands[0])] = 1;
		return \"move %y1,%0\";
	} else {
		return \";UDF->SI\";
	}
}")

(define_insn "fixunsdfdi2"
 [(set (match_operand:DI 0 "register_operand" "=A")
   (unsigned_fix:DI (match_operand:DF 1 "register_operand" "0")))]
 ""
 ";UDF->DI ")

(define_expand "fixuns_truncdfdi2"
 [(set (match_operand:DI 0 "register_operand" "=A")
   (unsigned_fix:DI (match_operand:DF 1 "register_operand" "0")))]
 ""
 "")

(define_insn "truncdisi2"
 [(set (match_operand:SI 0 "register_operand" "C")
   (truncate:SI (match_operand:DI 1 "register_operand" "A")))]
 ""
 "*
{
	int reg0 = REGNO(operands[0]);
	int reg1 = REGNO(operands[1]);

	if (reg0 < 4) {
		if (reg0 == (reg1+1)) {
			return \";DI->SI\";
		} else {
			regValid[reg0] = 1;
			return \"move %x1,%0\";
		}
	} else {
		regValid[reg0] = 1;
		return \"move %x1,%0\";
	}
}")

(define_insn "truncdihi2"
 [(set (match_operand:HI 0 "register_operand" "=C")
   (truncate:SI (match_operand:DI 1 "register_operand" "A")))]
 ""
 "*
{
	int reg0 = REGNO(operands[0]);
	int reg1 = REGNO(operands[1]);

	if (reg0 < 4) {
		if (reg0 == (reg1+1)) {
			return \";DI->HI\";
		} else {
			regValid[reg0] = 1;
			return \"move %x1,%0\";
		}
	} else {
		regValid[reg0] = 1;
		return \"move %x1,%0\";
	}
}")

(define_insn "truncdiqi2"
 [(set (match_operand:QI 0 "register_operand" "=C")
   (truncate:SI (match_operand:DI 1 "register_operand" "A")))]
 ""
 "*
{
	int reg0 = REGNO(operands[0]);
	int reg1 = REGNO(operands[1]);

	if (reg0 < 4) {
		if (reg0 == (reg1+1)) {
			return \";DI->QI\";
		} else {
			regValid[reg0] = 1;
			return \"move %x1,%0\";
		}
	} else {
		regValid[reg0] = 1;
		return \"move %x1,%0\";
	}
}")

(define_insn "truncsihi2"
 [(set (match_operand:HI 0 "register_operand" "=C")
   (truncate:HI (match_operand:SI 1 "register_operand" "0")))]
 ""
 ";SI->HI")

(define_insn "trunchiqi2"
 [(set (match_operand:QI 0 "register_operand" "=C")
   (truncate:QI (match_operand:HI 1 "register_operand" "0")))]
 ""
 ";HI->QI")

(define_insn "truncsiqi2"
 [(set (match_operand:QI 0 "register_operand" "=C")
   (truncate:QI (match_operand:SI 1 "register_operand" "0")))]
 ""
 ";SI->QI")

(define_insn "truncdfsf2"
 [(set (match_operand:SF 0 "register_operand" "=C")
   (float_truncate:SF (match_operand:DF 1 "register_operand" "A")))]
 ""
 "*
{
	if (REGNO(operands[0]) != REGNO(operands[1])) {
		regValid[REGNO(operands[0])] = 1;
		return \"move %y1,%0\";
	} else {
		return \";DF->SF\";
	}
}")

(define_insn "extendqihi2"
 [(set (match_operand:HI 0 "register_operand" "=C")
   (sign_extend:HI (match_operand:QI 1 "register_operand" "0")))]
 ""
 ";QI->HI")

(define_insn "extendhisi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (sign_extend:SI (match_operand:HI 1 "register_operand" "0")))]
 ""
 ";HI->SI")

(define_insn "extendqisi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (sign_extend:SI (match_operand:QI 1 "register_operand" "0")))]
 ""
 ";QI->SI")

(define_insn "extendsidi2"
 [(set (match_operand:DI 0 "register_operand" "A")
   (sign_extend:DI (match_operand:SI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0 = REGNO(operands[0]);
	int reg1 = REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {
		if (reg0 != (reg1-1)) output_asm_insn(\"move %w1,%x0\", operands);
		return \"move #0,%y0\";
	}
	if (reg0 != reg1) {
		return \"clr  %0\;move %w1,%x0\";
	}
	return \"swap %0\;clr24 %0\";
}")

(define_insn "zero_extendqihi2"
 [(set (match_operand:HI 0 "register_operand" "=C")
   (zero_extend:HI (match_operand:QI 1 "register_operand" "0")))]
 ""
 ";UQI->HI")

(define_insn "zero_extendhisi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (zero_extend:SI (match_operand:HI 1 "register_operand" "0")))]
 ""
 ";UHI->SI")

(define_insn "zero_extendqisi2"
 [(set (match_operand:SI 0 "register_operand" "=C")
   (zero_extend:SI (match_operand:QI 1 "register_operand" "0")))]
 ""
 ";UQI->SI")

(define_insn "zero_extendsidi2"
 [(set (match_operand:DI 0 "register_operand" "A")
   (zero_extend:DI (match_operand:SI 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {	/* Is this X1 or Y1 */
		if (reg0 != (reg1-1)) {
			output_asm_insn(\"move %w1,%x0\", operands);
		}
		return \"move #0,%y0\";
	} else {	/* This is A or B */
		if (reg1 != reg0) {
			return \"clr  %0\;move %w1,%x0\";
		}
			/* From A/B to itself */
		return \"swap %0\;clr24 %0\";
	}
}")

(define_insn "extendsfdf2"
 [(set (match_operand:DF 0 "register_operand" "=A")
   (float_extend:DF (match_operand:SF 1 "register_operand" "C")))]
 ""
 "*
{
	int reg0=REGNO(operands[0]);
	int reg1=REGNO(operands[1]);

	regValid[reg0] = 1;
	if (reg0 < 4) {	/* Is this X1 or Y1 */
		if (reg0 == reg1) {
			return \"move #0,%x0\";
		} else {
            return \"move %1,%y0\;move #0,%x0\";
		}
	} else {	/* This is A or B */
		if (reg0 != reg1) {
            return \"move %1,%0\";
		} else {
			return \"move %w1,%0\";
		}
	}
}")

(define_insn "beq"
 [(set (pc) (if_then_else (eq (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "beq  %Z0")

(define_insn "bne"
 [(set (pc) (if_then_else (ne (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "bne  %Z0")

(define_insn "blt"
 [(set (pc) (if_then_else (lt (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "blt  %Z0")

(define_insn "bgt"
 [(set (pc) (if_then_else (gt (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "bgt  %Z0")

(define_insn "bltu"
 [(set (pc) (if_then_else (ltu (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "blt  %Z0")

(define_insn "bgtu"
 [(set (pc) (if_then_else (gtu (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "bgt  %Z0")

(define_insn "ble"
 [(set (pc) (if_then_else (le (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "ble  %Z0")

(define_insn "bge"
 [(set (pc) (if_then_else (ge (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "bge  %Z0")

(define_insn "bleu"
 [(set (pc) (if_then_else (leu (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "ble  %Z0")

(define_insn "bgeu"
 [(set (pc) (if_then_else (geu (cc0) (const_int 0))
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "bge  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (eq (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "bne  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (ne (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "beq  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (lt (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "bge  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (gt (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "ble  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (ltu (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "bge  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (gtu (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "ble  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (le (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "bgt  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (ge (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "blt  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (leu (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "bgt  %Z0")

(define_insn ""
 [(set (pc) (if_then_else (geu (cc0) (const_int 0)) (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "blt  %Z0")

(define_insn "jump"
 [(set (pc) (label_ref (match_operand 0 "" "")))]
 ""
 "bra  %Z0")

(define_insn "call"
 [(call (match_operand    0 "general_operand" "o")
        (match_operand:SI 1 "general_operand" "g"))]
 ""
 "jsr  %Z0")

;
; Subroutines return values in A only
;
(define_insn "call_value"
 [(set (match_operand 0 "register_operand" "=u")
    (call (match_operand 1 "general_operand" "o")
          (match_operand:SI 2 "general_operand" "g")))]
 ""
 "jsr  %Z1")

(define_insn "nop"
 [(const_int 0)]
 ""
 "nop")

; Unfortunately, the Motorola assembler doesn't consider:
;		move #xxx,R0
;		jmp	 R0
; to be a pipeline violation (because it's actually useful sometimes)
; so we have to assume the worst and stick in a NOP before our tablejump
(define_insn "tablejump"
 [(set (pc) (match_operand 0 "register_operand" "a"))
  (use (label_ref (match_operand 1 "" "")))]
 ""
 "nop\;jmp  %Z0")

