; This program was originally published in the Motorola DSP96002 Users Manual
; and is provided under a DISCLAIMER OF WARRANTY available from Motorola DSP
; Operation, 6501 William Cannon Drive West, Austin, Texas 78735-8598.  For
; more information, refer to the DSP96002 Users Manual, Appendix B, DSP
; Benchmarks.
;
; B.1.15.3	Radix 4 Decimation in Frequency FFT  
;fftr4z macro   points,data,coef,table,temp 
;fftr4z ident   1,1 
; 
; Radix 4 Decimation in Frequency In-Place FFT Routine 
; 
;    Complex input and output data 
;       Real data in X memory 
;       Imaginary data in Y memory 
;    Normally ordered input data 
;    Digit reversed output data 
;    Coefficient lookup table 
;       Full cycle sinewave in Y memory 
;       Coefficient table can be generated by "sinewave" macro. 
; 
; 
; Macro Call - mfftr4z   points,data,coef,table,temp 
; 
;       points     number of points (4-16384, power of 4) 
;       data       starting address of data buffer 
;       coef       starting address of sinewave table 
;       table      size of sinewave table 
;       temp       starting address of temporary storage area 
; 
; Cooley-Tukey Radix 4 FFT Algorithm 
; 
;            
; ar,ai                       ar',ai' 
; br,bi        Radix 4        br',bi' 
; cr,ci       Butterfly       cr',ci' 
; dr,di                       dr',di' 
;             
; 
;       t1 = ar + cr 
;       t2 = ar - cr 
; 
;       t3 = dr + br 
;       t4 = dr - br 
; 
;       t5 = ai + ci 
;       t6 = ai - ci 
; 
;       t7 = bi + di 
;       t8 = bi - di 
; 
;       t9 = t2 + t8 
;       t10 = t2 - t8 
; 

;       t11 = t6 + t4 
;       t12 = t6 - t4 
; 
;       ar' = t1 + t3 
;       t13 = t1 - t3 
; 
;       ai' = t5 + t7 
;       t14 = t5 - t7 
; 
;       br' = t9*wr1 + t11*wi1 
;       bi' = t11*wr1 - t9*wi1 
; 
;       cr' = t13*wr2 + t14*wi2 
;       ci' = t14*wr2 - t13*wi2 
; 
;       dr' = t10*wr3 + t12*wi3 
;       di' = t12*wr3 - t10*wi3 
; 
; Address pointers are organized as follows: 
; 
;       r0 = ar,ai,br,bi pointer        n0 = butterflies per group 
;       r1 = wr (cos) pointer           n1 = rotation factor 
;       r2 = temp storage pointer       n2 = groups per pass 
;       r3 = group index counter        n3 = rotation factor 
;       r4 = cr,ci,dr,di pointer        n4 = butterflies per group 
;       r5 = wi (sin) pointer           n5 = rotation factor 
;       r6 = temp storage pointer       n6 = not used 
;       r7 = not used                   n7 = not used 
; 
; Alters Data ALU Registers 
;       d0      d4      d8 
;       d1      d5      d9 
;       d2      d6 
;       d3      d7 
; 
; Alters Address Registers 
;       r0      n0      m0 
;       r1      n1      m1 
;       r2      n2      m2 
;       r3      n3      m3 
;       r4      n4      m4 
;       r5      n5      m5 
;       r6              m6 

; 
; Alters Program Control Registers 
;       pc      sr 
; 
; Uses 6 locations on System Stack 
; 
; This program has not been exhaustively tested and may contain errors. 
; 
;                                                           	ICycles Prog
;                                                           Word    Cycle
    page                      ; 
    move    #points/4,n0      ;initialize butterflies per group   2    2 
    move    n0,n4             ;            "                      1    1 
    move    #1,n2             ;initialize groups per pass         1    1 
    move    #1,n3             ;initialize w rotation factor       1    1 
    move    #-1,m0            ;initialize linear addressing       1    1 
    move    m0,m1             ;            "                      1    1 
    move    m0,m2             ;            "                      1    1 
    move    m0,m3             ;            "                      1    1 
    move    m0,m4             ;            "                      1    1 
    move    m0,m5             ;            "                      1    1 
    move    m0,m6             ;            "                      1    1 
    move    #temp,r2          ;initialize temp storage pointers   2    2 
    move    (r2)+,r6          ;            "                      1    1 
    move    #0,r3             ;initialize group index counter     1    1 
    move    #coef+table/4,r1  ;initialize wr (cos) pointer        2    2 
    move    #coef,r5          ;initialize wi (sin) pointer        2    2 
; 
; Perform all FFT passes with triple nested DO loops 
; 
    do      #@cvi(@log(points)/@log(4)+0.5),_end_pass   ;          2    3 
    move    #data,r4                                    ;          2    2 
 
    do      n2,_end_grp                                 ;          2    3 
    move    r3,n5          ;update rotation factor                1    1 
    move    n5,n1          ;            "                         1    1 
    move    (r5)+n5        ;point at wi1                          1    1 
    move    (r1)+n1        ;point at wr1                          1    1 
    move    (r4)+n4                                     ;          1    1 
    move    r4,r0          ;point at B data (br,bi)               1    1 
    move    (r4)+n4                                     ;          1    1 
    move    (r4)+n4        ;point at D data (dr,di)               1    1 
 

    do      n0,_end_bfy                                 ;          2    3 
    move                             x:(r4),d0.s        ;          1    1 
    move                             x:(r0),d7.s  y:(r4),d2.s  ;   1    1 
    faddsub.s d0,d7                               y:(r0)-n0,d5.s ; 1    1 
    faddsub.s d5,d2                  x:(r0),d1.s                 ; 1    1 
    move                             x:(r4)-n4,d4.s              ; 1    1 
    move                             x:(r4),d4.s  y:(r0),d6.s    ; 1    1 
    faddsub.s d1,d4                  d2.s,x:(r2)+ y:(r4),d3.s    ; 1    1 
    faddsub.s d1,d5                               y:(r1)+n1,d8.s ; 1    1 
    fmpy   d5,d8,d2  faddsub.s d6,d3              y:(r5)+n5,d9.s ; 1    1 
    fmpy   d5,d9,d3  faddsub.s d6,d0 d1.s,x:(r2)- d3.s,y:(r6)    ; 1    1 
    faddsub.s d4,d7                  d0.s,d6.s    d6.s,y:(r2)    ; 1    1 
    fmpy.s d6,d9,d0                               y:(r5)+n5,d9.s ; 1    1 
    fmpy   d6,d8,d0  fadd.s  d0,d2                y:(r1)+n1,d8.s ; 1    1 
    fmpy   d4,d8,d3  fsub.s  d3,d0   x:(r2)+,d1.s y:(r6),d5.s    ; 1    1 
    faddsub.s d5,d1                  x:(r2)-,d6.s                ; 1    1 
    fmpy.s d4,d9,d1                  d7.s,x:(r0)+n0 d1.s,y:      ; 1    1 
    fmpy.s d5,d8,d2                  d2.s,x:(r0)    d0.s,y:      ; 1    1 
    fmpy   d5,d9,d0  fsub.s  d1,d2                y:(r1)-n1,d8.s ; 1    1 
    fmpy   d6,d8,d1  fadd.s  d0,d3                y:(r5)-n5,d9.s ; 1    1 
    fmpy.s d6,d9,d0                  d3.s,x:(r4)  y:(r2),d4.s    ; 1    1 
    fmpy.s d4,d8,d3                               d2.s,y:(r4)+n4 ; 1    1 
    fmpy   d4,d9,d2  fsub.s  d0,d3                y:(r1)-n1,d8.s ; 1    1 
    fadd.s    d2,d1                               y:(r5)-n5,d9.s ; 1    1 
    move                             d1.s,x:(r4)  d3.s,y:        ; 1    1 
_end_bfy 
    move    #coef,r5          ;point at wi0                      ; 2    2 
    move    #coef+table/4,r1  ;point at wr0                      ; 2    2 
    move    #0,r3             ;reset group index counter         ; 1    1 
_end_grp 
    move    n0,d0.l           ;get butterflies per group          1    1 
    lsr     d0.l              ;                                   1    1 
    lsr     d0.l    n2,d1.l   ;divide butterflies/group by 4      1    1 
    lsl     d1.l    d0.l,n0   ;multiply groups/pass by 4          1    1 
    lsl     d1.l    n3,d0.l   ;get w rotation factor              1    1 
    lsl     d0.l    d1.l,n2   ;multiply rotation factor by 4      1    1 
    lsl     d0.l    n0,n4     ;                                   1    1 
    move    d0.l,n3           ;                                   1    1 
    move    n0,d1.l           ;check for 1 butterfly per group    1    1 
    lsr     d1.l              ;                                   1    1 
    jne     skip              ;                                   1    2 
    move    #0,n3             ;reset rotation factor - last pass  1    1 
skip    nop                   ;                                   1    1 
_end_pass                     ;                                 ---  --- 
    endm                      ;                                  78   82 
 
;The speed for 1024 points using a 75ns instruction cycle is 2.72ms,  assuming internal program and 
;internal data memory.  
