/*
 * dip		A program for handling dialup IP connecions.
 *		This module handles the PPP protocol.
 *
 * Version:	@(#)ppp.c	3.3.3	08/16/93
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "dip.h"
#include "iflink.h"

void
do_ppp(struct dip *dip)
{
  char ifname[32];

#ifdef __MINT__
  strcpy ((char *)dip->protocol, "PPP");

  strcpy (ifname, "ppp");
  if (if_link (ttyname (tty_askfd ()), ifname) < 0) {
  	syslog (LOG_ERR, "if_link: %m");
  	return;
  }
  
  if (opt_v == 1) {
      printf("DIP: Interface %s\n",ifname);
  }

  /* Add the route to that host. */
  (void) attach(ifname, dip);
#else
  fprintf (stderr, "DIP: PPP protocol not available yet.\n");
#endif  
}
