/*	mark saeger,	msaeger@cse.unl.edu				*/
/*	more.h								*/
/*	Copyright 1995 Mark Saeger.					*/
/*									*/
/*	Permission is granted to any individual or instituition to use,	*/
/*	copy, or redistribute this executable so long as it is not	*/
/*	modified and that it is not sold for profit.			*/
/*									*/
/*	LIKE ANYTHING THAT IS FREE, MORE IS PROVIDED AS IS AND COMES	*/
/*	WITH NO	WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED.	*/
/*	IN NO EVENT WILL THE COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES	*/
/*	RESULTING FROM THE USE OF THIS SOFTWARE.			*/

/*the standard library includes*/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

/*some constants*/
#define FALSE 0	
#define TRUE 1
#define PROMPTNORMAL	0
#define PROMPTEND	1
#define PROMPTVERBOSE	2
#define PROMPTINVALID	3
#define PROMPTLINE	4
#define PROMPTCURR	5
#define PROMPTNONEXT	6
#define PROMPTNOREGEX	7
#define PROMPTMISSING	8
#define PROMPTNOEDIT	9
#define PROMPTILLREG	10
#define PROMPTNONEXTF	11
#define PROMPTNOPREV	12
#define PROMPTNOPREVF	13

#ifdef MINT
#define SIGNALTYPE (__Sigfunc)
#else
#define SIGNALTYPE (void *)
#endif

typedef struct _node
{
	int size;
	int dirty;
	int position;
	unsigned char nbuf[BUFSIZ];
	struct _node *link;
}node;

#define RGXCHAR 0	/*a character*/
#define RGXSTAR 1	/*a asterics*/
#define RGXDOT  2	/*a period*/
#define RGXBOL	3	/*a carat*/
#define RGXEOL	4	/*a dollar sign*/
#define RGXBOW	5	/* \< */
#define RGXEOW	6	/* \> */
#define RGXRNG	7	/* [?-?] */
#define RGXVAL	8	/* [???] */
#define RGXNRNG	9	/* [^?-?] */
#define RGXNVAL	10	/* [^???] */

typedef struct _rgx
{
	int type;
	unsigned char rdata[10];	/*biggest allowed is 10 characters*/
	struct _rgx *link;
}rgx;

/*and finally the prototypes*/
void main(int argc, char *argv[]);
void output(int pipe, FILE *ip, FILE *tty);
int putch(int ch);
int getchm(FILE *fp);
int do_prompt(FILE *tty, int *qmore, int *mlcounter, int *poffset, int pipe,
		long countlines, long totallines, int longlines[], 
	        int xlonglines, int flag, int doing,node *llist);
void filler(int *mlcounter, int mlines, int mccounter);
int read_forward(int max_to_read, unsigned char bigbuf[], int *x, int *xcount,
		int *poffset, long *countlines);
int read_backward(unsigned char bigbuf[], int *x, int *mlcounter,
		int *boffset, long *countlines, int *countchar);
node *fill(node *llist,node *bufferstdin,int max_to_read,unsigned char bigbuf[]);
node *newn(void);
int findprev(node *llist, unsigned char bigbuf[], int *max_to_read);
void sort(int longlines[], int xlonglines);
void setup_tty(void);
void cleanup_tty(void);
rgx *store_regex(void);
void search_regex(int *poffset, int top_of_form,int pipe, node *llist);
void pcr(void);
void handle_v(char *number, int pipe);
void handle_exclam(FILE *tty, int pipe);
void handle_help(int pipe);
int handle_bs(int *x, int *mccounter, unsigned char bigbuf[], int max_to_read);
void handle_tab(int x,int *mccounter);
int handle_r(FILE *tty, int number);
rgx *newr(void);
rgx *fillr(rgx *grgx,char r_d);
void destroy_globrgx(void);
rgx *fillrother(rgx *grgx, char **loptreg);
int check_bin(FILE *ip);
void handle_sig_winch(void);
int validate_regex(void);
void setup_termcap(void);
void sim_handle_tab(int *lmcounter);
