Hi!

This is my port of metamail 2.7 to the Atari.  With the help of metamail 
you can make your mailer (elm, pine, Mutt, ...) a MIME-compliant mailer.  
See the included manual pages and the documentation of your mailer for 
details.


INSTALLATION
============

Change to the directory src.  Copy all files in the subdirectory bin into 
a directory where you keep your shell scripts, e. g. /usr/local/bin.  Now 
change to the subdirectory metamail.  Copy the files

	mailto
	metamail
	mmencode
	mimencode
	splitmail

to some path where you keep your executables (/usr/local/bin again?).  If 
your file system doesn't recognize the x-flag of a file you might have to 
rename them by appending .ttp to the file names.  Note that mimencode is 
actually a symbolic link to mmencode in the same directory.  If your file 
system doesn't support symbolic links you should remove the file mimencode.

In the subdirectory richmail you should find the executables

	richtext
	richtoatk

Rename them to .ttp if necessary and put them into your executable path.

Finally install the manpages.  I've changed the directory structure a bit 
to help you with the installation.  Make a cd into the directory man.  
Then copy all files from subdirectory man1 into e.g. /usr/local/man/man1 
or somewhere else where your manpages of section 1 can be found.  Do the 
same with the manpage in man4.  Then copy all files from cat1 to 
/usr/local/man/cat1 and the same with cat4.

If you don't have the troff package the unformatted versions in man1 and 
man4 are probably of no use to you.  You should only install the 
preformatted manpages from cat1 and cat4.  Yet, if you have troff you 
don't have to bother about the formatted versions in cat1 and cat4.

Note that the manpage for mimencode is always a symbolic link to the 
manpage of mmencode.  The above remarks for the executable apply to the 
manpage as well.

Finally you should install the file mailcap in /usr/local/etc/mailcap.  
There are various other places where this file is being searched for.  See 
the manpage of mailcap for details.  Then you should edit the file.  Make 
sure to read the mailcap manual page parallel in order to know what you 
are doing.

Personal versions of mailcap (or personal alterations) can be made in the 
file .mailcap in your home directory.  However you shouldn't put a copy of 
the system-wide mailcap file in your home directory.  Your personal 
mailcap file needs only to contain your personal changes.  The other 
settings will be read from the system-wide valid /usr/local/etc/mailcap.

And now pray read the manpages for mime, mailcap and metamail (in that 
order)!  And don't blame anybody else but yourself for damage if you 
haven't read it thoroughly.


System requirements
===================

The metamail package has been compiled with MiNTLib PL46 and gcc 2.7.2.  
However most of the programs should run without MiNT, too.  This applies 
escpecially to mmencode the encoder/decoder for base64, the MIME 
replacement for uudecode/uuencode.

The metamail program itself (which you will usually never call directly by 
the way) might have severe problems if you don't have a Unix-like 
environment.  At least you should take care that you have a POSIX-shell in 
/bin/sh or have the path of a POSIX-shell in your envariable $SHELL.  Why? 
Say you receive a mail with the content-type "image/jpeg".  Metamail will 
then examine the suite of mailcap files for an appropriate entry, i. e. 
"image/jpeg" or "image/*".  If it finds one it reads a command line to 
pass to the shell to make you view the image.

Yet the original MiNTLib version of the C-library-function system() that 
is used to perform the call isn't compliant to standards.  For metamail I 
have replaced it with a compromise version.  If you have /bin/sh or $SHELL 
set everything will work fine.  If you haven't you should be very careful 
with expecting special shell features to work for your mailcap file.  You 
should namely avoid pipes (i. e. the symbol "|"), subshell execution 
(commands grouped in parentheses),  multiple commands separated by a 
semicolon and the specification of environment variables on the command 
line.

But even if you avoid these things there still might be a lot of problems.


GEM-programs?
=============

Metamail and all related programs/scripts are run from the command line.  
Yet for multi-media stuff you will probably want to use GEM programs for 
viewing and composing MIME mails.  You have to find out yourself if and 
how you can do this on your specific system.

I can describe my own environment in general to give you some clues.  I 
use MiNT 1.12.6 and N.AES 1.10 (N.AES is a commercial AES 4.1 by Overscan, 
http://www.overscan.com).  My desktop is Thing, I usually run my shell in 
TOSWIN a terminal emulator for MiNT.

It is almost impossible to run GEM programs directly from the command line 
because they cannot find their resource files (.rsc) unless you cd into 
their directory before.  Thus I usually start GEM programs indirectly by 
little shell-scripts that I put into /usr/local/bin.  They basically look 
all the same:

#!/bin/sh
# Sample start-up script for the phantasy GEM application
# smell-o-vision.prg.
#
# First cd into its directory:

cd /usr/bin/gem/smell-o-vision

# Unfortunately most GEM applications have problems to understand
# Unix-like filenames like /tmp/mailpic.gif.  They expect something like
# U:\tmp\mailpic.gif.  The following commands will process the filenames. 

# Instead of the original command line we will pass a modified one called
# "newargv".
newargv=""

# Now process all arguments.  Note that this assumes that _all_ arguments 
# are filenames.  If some of them are options (and you know how many 
# options come you need to run the "shift" command once for every option 
# you want to skip.
#
for file in $*; do
	dumbname=`echo $file | sed -e "s,/,\\\\\,g" -e "s@.*@u:&@"`
	newargv="$newargv $dumbname"
done
# In plain English this was: Look at all arguments (i. e. $*).  Convert 
# all slashes in the filename by backslashes and add it to the argument 
# vector.

# Now actually call the program with the new argument vector.  If you want 
# the shell to wait for the program to finish leave it as it is.  If you
# want to execute the program in the background (which allows you to type
# in more shell commands while the GEM application is running) place an
# ampersand ("&") behind the command.
./smell-o-vision.app "$newargv"

### The End ###

Well, that's it in brief.  You will have to try out some things if you 
want to adapt the script to the needs of a particular program.


Which GEM programs to take for mail viewers?
============================================

Don't expect me to recommend any commercial or shareware stuff here (the 
hint for overscan was enough). Try it out yourself with you payware.

If you are looking for freeware the following might be interesting for you:

1) Image Viewer

GrafTool by Joergen van Bargen works with some difficulties.  You have to 
rename it to graftool.gtp, otherwise it won't accept arguments.  Then you 
have to rename all files according to the method described above. But this 
isn't enough.  GrafTool expects a gif file to end on .gif, a jpeg file on 
.jpg and so on.  You have to change the filename in the start up script 
accordingly to make it meet these requirements, since metamail will 
always call the files something like "/tmp/mmXXXXXX" where "XXXXXX" is 
some random number. However you don't need to edit an individual version 
for every image format:  Metamail will set the environment variable 
$MM_CONTENTTYPE to the specific content type.  You can scan it within the 
startup script.

2) Sound player

I use lps.  It can handle most common sound formats, it doesn't need any 
special precautions for the filenames.  It's almost perfect.  (Well, it 
crashes with memory protection switched on).

3) Editor/Text viewer

Get yourself QED!  From version 3.97 on it is enough to set the 
environment variable $QED to the path where the qed resource file is 
found.  That's all, qed will understand all filenames, no matter if they 
are TOS- or MiNT-style.


Other programs
==============

For all mail purposes GNU recode is a very handy tool especially if you 
send and receive a lot of mail that is not in English.  These mails, if 
they contain non-ASCII characters (accented, German umlaute with diaresis 
etc.) they are coded according to the standard codeset ISO-8859-1 (aka  
Latin-1). With GNU recode you can easily recode these mails to the Atari 
codeset for reading and then back to Latin-1 for sending.

You should also have a look at mmencode that is included in the metamail 
package.  Mails with non-English characters are usually coded with the 
quoted-printable mechanism.  Basically every 8-bit character is coded into 
the sequence "=FF" where "FF" stands for the hexadecimal code of the 
particular character.  If you know what I'm talking of you should have a 
look at the manpage for mmencode.  With mmencode you can make these 
messages readable.  This is usually necessary if you want to reply to a 
message that was encoded in quoted-printable.


Mailers
=======

Metamail works fine with elm (provided that you have an elm compiled with 
the MIME extensions) and it works even finer with Mutt.  Both programs 
have been ported to MiNT.


What's MIME?
============

Funny to ask this question at the end.  Well, MIME is an abbrevation of 
"Multipurpose Internet Mail Extensions".  You can learn about MIME by 
reading the corresponding RFCs.  They are numerous right now.

The traditional standard for e-mail in the internet was SMTP as specified 
in RFC 822.  However, SMTP suffered from some restrictions, the most 
annoying being the restriction to seven bits.  This means that special 
precautions were necessary for mails that contained special characters 
like most european languages execpt english, and when sending binary data 
like images, sound files, executable programs, compressed files etc.  you 
needed to code the files down to seven bit before.  The latter was usually 
done with the uudecode/uuencode tool.

The idea of MIME is the following:  Why not put all the information 
necessary to decode and display the message contents into the message 
header that accompanies every mail?  Why use uudecode/uuencode although it 
is known not to work correctly for some systems resp. some gateways?

So uudecode/uuencode was replaced by the more reliant mechanisms base64 
(for binary data) and quoted-printable (for textual files).  Then some 
additional message header fields were defined and now you can send and 
receive whatever kind of data you want.  If you have a MIME compliant mail 
reader everything is done almost automatically.  You simply have to choose 
"Display current message" and your mail reader in cooperation with 
metamail will decode the mail correctly (or even assemble it from multiple 
parts if they were too large to be transported) and will call the 
appropriate program to display the message.


Now send yourself your first MIME message (you can use the mailto program 
for that) and have fun with it!

Guido Flohr

gufl0000@stud.uni-sb.de
http://stud.uni-sb.de/~gufl0000


Appendix: Note for programmers

It's easy to recompile metamail provided that you use GNU-C and have the 
MiNTLibs installed.  The only file I actually had to adapt was config.h, 
and splitmail.c needed a minor change.  I've also included system.c, 
wait.c and waitpid.c that should replace your corresponding versions in 
the MiNTLib.  Simply compile them together with metamail and take care 
that they get linked before MiNTLib.

BTW: The GDOS fonts for hebrew characters have been compiled by an alpha 
version of bdf2gdos, a font compiler for X11 fonts.  The compiler is still 
in alpha stadium but coming out soon.  If you're interested just drop me a 
(MIME-)mail, I will notify you if when it's ready for beta testing.


