/* from Henry Spencer's stringlib */
#include <string.h>

static char nullstr[] = "unknown error";

char *sys_errlist[] =
	{
	"OK",					/* 0 */
	"error",				/* 1 */
	"drive not ready",			/* 2 */
	"unknown command",			/* 3 */
	"crc error",				/* 4 */
	"bad request",				/* 5 */
	"seek error",				/* 6 */
	"unknown media",			/* 7 */
	"sector not found",			/* 8 */
	"out of paper",				/* 9 */
	"write failure",			/* 10 */
	"read failure",				/* 11 */
	"general mishap",			/* 12 */
	"media write protected",		/* 13 */
	"media changed",			/* 14 */
	"unknown device",			/* 15 */
	"bad sectors on format",		/* 16 */
	"disk swap request",			/* 17 */
	nullstr,				/* 18 */
	nullstr,				/* 19 */
	nullstr,				/* 20 */
	nullstr,				/* 21 */
	nullstr,				/* 22 */
	nullstr,				/* 23 */
	nullstr,				/* 24 */
	nullstr,				/* 25 */
	nullstr,				/* 26 */
	nullstr,				/* 27 */
	nullstr,				/* 28 */
	nullstr,				/* 29 */
	nullstr,				/* 30 */
	nullstr,				/* 31 */
	"invalid function number",		/* 32 */
	"file not found",			/* 33 */
	"path not found",			/* 34 */
	"no more handles",			/* 35 */
	"permission denied",			/* 36 */
	"invalid handle",			/* 37 */
	nullstr,				/* 38 */
	"out of memory",			/* 39 */
	"invalid memory block",			/* 40 */
	nullstr,				/* 41 */
	nullstr,				/* 42 */
	nullstr,				/* 43 */
	nullstr,				/* 44 */
	nullstr,				/* 45 */
	"invalid drive id",			/* 46 */
	nullstr,				/* 47 */
	"link across devices",			/* 48 */
	"no more files",			/* 49 */
	nullstr,				/* 50 */
	nullstr,				/* 51 */
	nullstr,				/* 52 */
	nullstr,				/* 53 */
	nullstr,				/* 54 */
	nullstr,				/* 55 */
	nullstr,				/* 56 */
	nullstr,				/* 57 */
	"locking conflict",			/* 58 */
	nullstr,				/* 59 */
	nullstr,				/* 60 */
	nullstr,				/* 61 */
	nullstr,				/* 62 */
	nullstr,				/* 63 */
	"range error/bad argument",		/* 64 */
	"internal error",			/* 65 */
	"bad executable format",		/* 66 */
	"memory block growth failure",		/* 67 */
	nullstr,				/* 68 */
	nullstr,				/* 69 */
	nullstr,				/* 70 */
	nullstr,				/* 71 */
	nullstr,				/* 72 */
	nullstr,				/* 73 */
	nullstr,				/* 74 */
	nullstr,				/* 75 */
	nullstr,				/* 76 */
	nullstr,				/* 77 */
	nullstr,				/* 78 */
	nullstr,				/* 79 */
	"too many symbolic links",		/* 80 */
	"broken pipe",				/* 81 */
	nullstr,				/* 82 */
	nullstr,				/* 83 */
	nullstr,				/* 84 */
	"file exists",				/* 85 */
	"name too long",			/* 86 */
	"not a tty",				/* 87 */
	"range error",				/* 88 */
	"domain error",				/* 89 */
	"I/O error",				/* 90 */
	"no space on device",			/* 91 */
	nullstr,				/* 92 */
	nullstr,				/* 93 */
	nullstr,				/* 94 */
	nullstr,				/* 95 */
	nullstr, nullstr, nullstr, nullstr, nullstr,	/* 96 - 100 */
	nullstr, nullstr, nullstr, nullstr, nullstr,	/* 101 - 105 */
	nullstr, nullstr, nullstr, nullstr, nullstr,	/* 106 - 110 */
	nullstr, nullstr, nullstr, nullstr, nullstr,	/* 111 - 115 */
	nullstr, nullstr, nullstr, nullstr, nullstr,	/* 116 - 120 */
	nullstr, nullstr, nullstr, nullstr, nullstr,	/* 121 - 125 */
	nullstr,				/* 126 */
	nullstr,				/* 127 */
	"interrupted system call"		/* 128 */
	};

int	sys_nerr = (int)(sizeof(sys_errlist)/sizeof(sys_errlist[0]));

#ifdef __MINT__

/* Support for Kay Roemer's socket library */

char *const _sock_errlist[] = {
	"Socket operation on non-socket",		/* 300 */
	"Destination address required",
	"Message too long",
	"Protocol wrong type for socket",
	"Protocol not available",
	"Protocol not supported",
	"Socket type not supported",
	"Operation not supported",
	"Protocol family not supported",
	"Address family not supported by protocol",
	"Address already in use",
	"Cannot assign requested address",
	"Network is down",
	"Network is unreachable",
	"Network dropped conn. because of reset",
	"Software caused connection abort",
	"Connection reset by peer",
	"Socket is already connected",
	"Socket is not connected",
	"Cannot send after shutdown",
	"Connection timed out",
	"Connection refused",
	"Host is down",
	"No route to host",
	"Operation already in progress",
	"Operation now in progress",
	"Operation would block"
};

int	_sock_nerr = (int)(sizeof (_sock_errlist) / sizeof (char *));

#define MINSOCKERR	300
#define MAXSOCKERR	(MINSOCKERR + _sock_nerr)

#endif

/*
 * strerror - map error number to descriptive string
 *
 */

char *
strerror(errnum)
int errnum;
{
	extern int sys_nerr;
	/* extern char *sys_errlist[]; */
#ifndef __MBASE__
	extern char const *const sys_errlist[];
#else
	extern char const *sys_errlist[];
#endif

	if (errnum >= 0 && errnum < sys_nerr)
		return(sys_errlist[errnum]);
#ifdef __MINT__
	else if (errnum >= MINSOCKERR && errnum < MAXSOCKERR)
		return(_sock_errlist[errnum - MINSOCKERR]);
#endif
	else
		return(nullstr);
}
