/*
 *	/dev/audio for Atari Ste, MegaSte, TT, Falcon running Mint.
 *	(Ste DMA stuff).
 *
 *	Based on audiodev 0.1 by Charles Briscoe-Smith, which is in
 *	turn based on lpdev 0.6 by Thierry Bousch.
 *
 *	10/28/95, Kay Roemer.
 */

#include <string.h>
#include <osbind.h>
#include "kerbind.h"
#include "file.h"
#include "atarierr.h"
#include "dmasnd.h"
#include "audios.h"
#include "device.h"
#include "mfp.h"
#include "cookie.h"

static void		dma_reset (void);
static void		dma_timer (void);
static long		dma_copyin (char *buf, long len);
static long		dma_ioctl (short mode, void *arg);
static long		dma_wspace (void);


static short stereo = 0;

/*
 * install things
 */
long
dma_init (struct device *dev)
{
	long snd_cookie;

	if (get_cookie (COOKIE__SND, &snd_cookie) ||
	    !(snd_cookie & 2)) {
		/*
		 * _SND cookie not set or no Ste
		 * compatible sound hardware.
		 */
		return 1;
	}
	if (MFP_IERA & MFP_IMRA & 0x20) {
		c_conws ("timer A in use!\r\n");
		return 1;
	}

	dev->channels = 2;
	dev->reset = dma_reset;
	dev->copyin = dma_copyin;
	dev->ioctl = dma_ioctl;
	dev->wspace = dma_wspace;
	
	DMActl = DMA_OFF;
	DMAsmc = DMA_12KHZ|DMA_MONO;

	timer_func = dma_timer;

	Jdisint (13);
	Xbtimer (0, 8, 1, new_timera_vector);
	Jenabint (13);
	return 0;
}

static long
dma_wspace (void)
{
	short sr = spl7 ();
	long avail;

	avail = BUFSIZE - dmab[bufidx].used;
	if (!playing)
		avail += BUFSIZE;
	spl (sr);
	return avail;
}

static void
dma_reset (void)
{
	short sr = spl7 ();

	playing = 0;
	DMActl = DMA_OFF;
	dmab[0].used = 0;
	dmab[1].used = 0;
	spl (sr);
	if (audio_rsel)
		wakeselect (audio_rsel);
}

/*
 * timer A (frame done) interrupt
 */
static void
dma_timer (void)
{
	short i, sr;

	sr = spl7 ();
	i = bufidx ^ 1;
	if (playing) {
		if (--playing == 0) {
			dmab[i].used = 0;
			DMActl = DMA_OFF;
		} else {
			dmab[i].used = 0;
			DMActl = DMA_PLAY;
			bufidx = i;
		}
		spl (sr);
		if (audio_rsel)
			wakeselect (audio_rsel);
	} else
		spl (sr);
}

/*
 * copy (and convert) samples from user space
 */
static long
dma_copyin (char *buf, long len)
{
	long cando;
	short i;

	timera_cli ();
	i = bufidx;
	cando = BUFSIZE - dmab[i].used;
	if (len < cando)
		cando = len;
	if (cando <= 0) {
		timera_sti ();
		return 0;
	}
	(*copyfn) (dmab[i].buf + dmab[i].used, buf, cando);
	dmab[i].used += cando;
	/*
	 * DMA wants event number of samples. If odd, then play the
	 * last sample twice..
	 */
	if (!stereo && (cando & 1)) {
		dmab[i].buf[dmab[i].used] = dmab[i].buf[dmab[i].used - 1];
		++dmab[i].used;
	}
	if (playing == 0) {
		playing = 1;
		bufidx ^= 1;
		DMASetBase (dmab[i].buf);
		DMASetEnd  (dmab[i].buf + dmab[i].used);
		DMActl = DMA_PLAY;
	} else {
		playing = 2;
		DMASetBase (dmab[i].buf);
		DMASetEnd  (dmab[i].buf + dmab[i].used);
		DMActl = DMA_PLAY|DMA_LOOP;
	}
	timera_sti ();
	return cando;
}

static long
dma_ioctl (mode, buf)
	short mode;
	void *buf;
{
	long arg = (long)buf;
	short i;

	switch (mode) {
	case AIOCGSPEED:
		i = DMAsmc;
		switch (i & 0x3) {
		case DMA_6KHZ:
			*(long *)arg = 6258;
			break;

		case DMA_12KHZ:
			*(long *)arg = 12517;
			break;

		case DMA_25KHZ:
			*(long *)arg = 25033;
			break;

		case DMA_50KHZ:
			*(long *)arg = 50066;
			break;
		}
		break;

	case AIOCSSPEED:
		if (arg < (6258L+12517L)/2)
			arg = DMA_6KHZ;
		else if (arg < (12517L+25033L)/2)
			arg = DMA_12KHZ;
		else if (arg < (25033L+50066L)/2)
			arg = DMA_25KHZ;
		else
			arg = DMA_50KHZ;
		DMAsmc = (DMAsmc & DMA_MONO) | arg;
		break;

	case AIOCSSTEREO:
		if (arg) {
			stereo = 1;
			DMAsmc = (DMAsmc & 3);
		} else {
			stereo = 0;
			DMAsmc = (DMAsmc & 3) | DMA_MONO;
		}
		break;

	default:
		return EINVFN;
	}
	return 0;
}

