/*
 * xdemineur 1.1 - X11 minefield game
 *
 * Author: Marc Baudoin (baudoin@ensta.fr)
 *
 *            |\
 *          |\| \
 *          |//  )
 *        |\ /  /        /\/\_
 *        |//  /        /. . /
 *      |\ /  /     ___/    |_
 *      |//  /     (____/    /_/\_
 *       |__|      (_____/ __     >
 *     /| ___  ________ _< \ \__  >
 *     \|| __\| _|_   _/ \\ \___\/
 *       | __\____ | |/ _ \\    >
 *     /||___\_____|___/ \_\\  _>
 *     \|____           ____ \|
 *       \   \_________/   /
 *        \   _    _      /
 *         \_//   //_____/
 *           (_   \ (_  _\
 *             |/\|   \/
 *
 * Ecole Nationale Superieure de Techniques Avancees (ENSTA)
 * 32, boulevard Victor - 75015 Paris - France
 *
 * Copyright (C) 1993 Marc Baudoin
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.  The author makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 */



#define BORD          15   /* bord entourant la fenetre et le tableau de jeu */
#define LARG_BORD      3   /* largeur du bord (en pixels) */

#define MARGE_HAUT    ( 2 * BORD + 50 )   /* marge superieure (icone, indicateurs) */

#define LARG_CASE     20   /* largeur d'une case (en pixels) */
#define HAUT_CASE     20   /* hauteur d'une case (en pixels) */

#define X_JEU         BORD
#define Y_JEU         MARGE_HAUT
#define LARG_JEU      nb_col * LARG_CASE + nb_col + 1
#define HAUT_JEU      nb_lig * HAUT_CASE + nb_lig + 1

#define LARGEUR_FEN   LARG_JEU + 2 * BORD
#define HAUTEUR_FEN   HAUT_JEU + MARGE_HAUT + BORD
#define X_FEN         ( DisplayWidth  ( display , screen ) - LARGEUR_FEN ) / 2
#define Y_FEN         ( DisplayHeight ( display , screen ) - HAUTEUR_FEN ) / 2

#define HAUT_NUMERO   30
#define LARG_NUMERO   20

#define X_NB_MINES    ( MARGE_HAUT - HAUT_NUMERO ) / 2
#define Y_NB_MINES    ( MARGE_HAUT - HAUT_NUMERO ) / 2

#define LARG_ICONE    40
#define HAUT_ICONE    40
#define X_ICONE       ( LARGEUR_FEN - LARG_ICONE ) / 2
#define Y_ICONE       ( MARGE_HAUT  - HAUT_ICONE ) / 2 

#define X_CHRONO      LARGEUR_FEN - ( MARGE_HAUT - HAUT_NUMERO ) / 2 - 3 * LARG_NUMERO
#define Y_CHRONO      ( MARGE_HAUT - HAUT_NUMERO ) / 2
