#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapesq.inc"

//The camera
camera {
  location <0, 0, -5>
  look_at <0, 0, 0>
  }

//Let there be light
object {
    light_source {<20, 30, -50> color White}
    }

//Let there be more light
object {
    light_source {<-20, 30, -50> color White}
    }

//A beautiful blue sky
object {
    sphere {<0, 0, 0>, 1}
    texture {Apocalypse turbulence .666666667 scale <.8, .8989, .8989> 
        finish {ambient 1 diffuse 0}
        }
    scale <10000, 10000, 10000>
    }

//The linoleum floor
object {
    plane {<0, 1, 0>, -3}
    texture {
       tiles {
          texture {Pine_Wood}
       tile2
          texture {
             White_Marble
             finish {reflection .765 brilliance .52}
             }
          }
       }
}

//The phantom jade thing in the middle
cylinder {
    <0, 12, 0>,       
    <0, -12, 0>,       
    0.25            
    open           
    texture {Jade}
    finish {reflection .767}  
}

//A sphere
object {
  sphere {
      <2, .7655, -1>,
      .1
      }
  texture {PinkAlabaster scale <.1, .1, .1>}
}

//Another little sphere
object {
  sphere {
      <-2, 1.63, -1.24>,
      .094
      }
  texture {Sandalwood scale <.12, .12, .15>}
}

//Another little sphere
object {
  sphere {
      <1.1654, 1.168, .752>
      .1259
      }
  texture {Spun_Brass scale <.096, .09246, .11>}
}

//Yet another little sphere
object {
  sphere {
      <1.618, 1.142, -1.95111>
      .099999
      }
  texture {Blood_Sky scale <.0799, .07998, .07235>}
}

//Hey, a cone
cone {
  <2, -.2757, 0>, 0
  <1.552, -.6757, -.0237>, .1753
  texture {Peel scale <.09, .0986, .09>}
}

//A BIG sphere
object {
   sphere {
       <-1.56, -.521, .034169>
       .32
       }
   texture {DMFLightOak}
}
  
//The BIG GUY, takin' it all in
//Extra Bonus Fractal Bumpmap
object {
  sphere {
      <0, -.5, 0>
      .9
      }
      pigment {Gold}
      finish {reflection .75}
      normal {
         bump_map {
            gif "fract003.gif"
            map_type 1
            bump_size 5
            }
        translate <0, .45, 0>
       }
      
  }

//And now for something completely different -- (Drum Roll PLEASE!)
//A Twin Glob!!!!
object {
    Twin_Glob
    texture {
       finish {Mirror}
       pigment {White}
       }
    scale <.25, .25, .25>
    rotate <13, 52, 67>
    translate <-1, .29, .19784>
}

//Another strange quartic -- No drum roll
object {
    Helix
    texture {
       finish {Mirror}
       pigment {White}
       }
    scale <.25, .25, .25>
    rotate <13, 52, 67>
    translate <-1.25617, 1, -.19784>
}


//An Olympic hexagon donut -- Yum!!!
object {
  torus {.2, .06}
  pigment { hexagon color Gold color Silver color Bronze scale <.02, .02, .02>} 
  rotate <-8.93, 1.34, 7.3357>
  translate <1.045, 1.4685, -.24642>
}

//My favorite, the stacked toruses.
//This, by itself, when you remove the scale factor, makes for a very nice 
//image in itself.  Center the tori and put in two light sources.
union {
   torus {4.0,1.0
   texture {Tom_Wood}
  }


   torus {4.0,1.0
      translate < 0.0,2.0,0.0>
   texture {Sandalwood}
  }


   torus {4.0,1.0
      translate < 0.0,4.0,0.0>
   texture {EMBWood1}
  }


   torus {4.0,1.0
      translate < 0.0,6.0,0.0>
   texture {DMFWood4}
  }


   torus {4.0,1.0
      translate < 0.0,8.0,0.0>
   texture {Dark_Wood}
  }


   torus {4.0,1.0
      translate < 0.0,10.0,0.0>
   texture {Cherry_Wood}
  }
  scale <.05, .05, .05>
  rotate <1.154, 2.452, 6.1374>
  translate <-1.653, 1.43, 0>
}

