/*********************************************
	file: main.c
	utility: main file containing main functions
	date: 05/11/96
	author: C. Moreau
	modifications:
	comments: 
*********************************************/

/*********************************************
	includes
*********************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#if defined __PUREC__
#include <tos.h>
#include <aes.h>
#include "e:\proging\c\libs\compend\include\compend.h"
#elif defined __GNUC__
#include <gemfast.h>
#endif

#include "e:\proging\c\libs\malib\include\openwork.h"
#include "e:\proging\c\libs\malib\include\alert.h"
#include "e:\proging\c\libs\malib\include\appgpath.h"

#include "files.h"
#include "config.h"

/*********************************************
	defines
*********************************************/

/*********************************************
	globals vars declarations
*********************************************/
char app_path[FILENAME_MAX];	/* application path */

/*********************************************
	locals functions definitions
*********************************************/

/*********************************************
	functions declarations
*********************************************/
/*
	name: main
	utility: 
	comment: 
	parameters:
	return:
	date:
	author: C.Moreau
	modifications:
*/
int main(void)
{
	char working_path[FILENAME_MAX];
	char fname[FILENAME_MAX]={"*.*"};
	int button;	/* value of user button */

	if (open_work() == -1)
		exit(-1);
		
	app_get_path(PROGNAME, app_path);	
	
	strcpy(working_path, app_path);

	do
	{
		strcpy(fname, "*.*");
		fsel_exinput(working_path, fname, &button, "Choose a path or a file");

		working_path[strlen(working_path)-3]='\0';			/* take off "*.*" */

		if (button == FSEL_OK)
		{
			if (	!strcmp(fname, "*.*")
				 || !strlen(fname))	/* folder selected */
			{
				int alert_butt = form_alert(3,
						 	"[2][Protect or unprotect |folder ?]"
							"[Protect|Unprotect|Cancel]"); 
				if (alert_butt == 1)	/* protect */
				{
					FIL_readonly_change = TRUE;
					FIL_readonly_set = TRUE;
					FIL_search(working_path);	
					FIL_readonly_change = FALSE;
				}
				else if (alert_butt == 2) /* unprotect */
				{
					FIL_readonly_change = TRUE;
					FIL_readonly_set = FALSE;
					FIL_search(working_path);	
					FIL_readonly_change = FALSE;
				}
			}
			else	/* file selected */
			{
				int alert_butt = form_alert(3,
						 	"[2][Protect or unprotect |file ?]"
							"[Protect|Unprotect|Cancel]"); 
				if (alert_butt == 1)	/* protect */
				{
					FIL_readonly_change = TRUE;
					FIL_readonly_set = TRUE;
					FIL_attrib_change(working_path, fname);	
					FIL_readonly_change = FALSE;
				}
				else if (alert_butt == 2) /* unprotect */
				{
					FIL_readonly_change = TRUE;
					FIL_readonly_set = FALSE;
					FIL_attrib_change(working_path, fname);	
					FIL_readonly_change = FALSE;
				}
			}
		}
	} while (button != FSEL_CANCEL);
	
	close_work();
	
	return 0;	
}

