/********************************************
	file: files.c
	utility: files functions.
	date: 19/02/97
	author: C.Moreau
	modifications:
	comments: 
*********************************************/

/********************************************
	includes
*********************************************/
#include <string.h>
#include <stdio.h>
#if defined __PUREC__
#include <tos.h>
#include <aes.h>
#include "e:\proging\c\libs\compend\include\compend.h"
#elif defined __GNUC__
#include <gemfast.h>
#endif

#include "files.h"
/********************************************
	defines
*********************************************/

/********************************************
	locals vars declarations & definitions
*********************************************/

/********************************************
	globals vars declarations
*********************************************/
extern bool FIL_readonly_change = FALSE;
extern bool FIL_readonly_set = TRUE;

/********************************************
	locals functions declarations
*********************************************/

/********************************************
	globals functions definitions
*********************************************/
/*
	name: FIL_search
	utility: search for file recursively
	comment: 
	parameters:
		char path[FILENAME_MAX]: path where to start.
	return:
		int: error code: 0 nothing, !=0 error.
	date: 06/12/95
	author: C.Moreau
	modifications:
*/
extern int FIL_search(char *path)
{
	DTA	dtabuffer;				/* En tete fichier */

	Fsetdta(&dtabuffer);		/* On fixe adresse du DTA */
	strcat(path, "*.*");		/* make search path */

	if(!Fsfirst (path, FA_DIR))	/* Do 1st file */
	{
		path[strlen(path)-3]='\0';			/* take off "*.*" */
		do		
		{		
			if (dtabuffer.d_attrib & FA_DIR)			/* It is a folder */
			{
				if ((strcmp (dtabuffer.d_fname, ".")) &&		/* Not dummy folders */
						(strcmp (dtabuffer.d_fname, "..")))	
				{
						/* make path */
					strcat(path, dtabuffer.d_fname);
					strcat(path, "\\");
					                		
					if (FIL_search(path))	/* Search again in new path */
						return -1;
					
					Fsetdta(&dtabuffer);	/* Reset DTA to its old adress */

						/* take off added path */
 					{
 						int	i=(int)strlen(path)-2;	/* end of string at '\' */
						while (path[i--]!='\\');
						path[i+2]='\0';
					}								
				}
			}
			else
			{
				FIL_attrib_change(path, dtabuffer.d_fname);
			}
		} while (!Fsnext());	/* next file */
	}
	return 0;
}

/*
	name: FIL_attrib_change
	utility: Change a file attribute
	comment: 
	parameters:
		char path[FILENAME_MAX]: file path.
		char fname[FILENAME_MAX]: filename.
	return:
		int: error code: 0: ok, !=0: error.
	date: 19/02/97
	author: C.Moreau
	modifications:
*/
extern int FIL_attrib_change(char *path, char *fname)
{
	if (FIL_readonly_change)
	{
		static char fname_tmp[FILENAME_MAX];	/* complete filename */
		int attributs;		/* file attributes */
		int error;			/* return error code */
		
		strcpy(fname_tmp, path);
		strcat(fname_tmp, fname);
		attributs=error=Fattrib(fname_tmp, FA_INQUIRE, 0);
		
		if (error >= 0)	/* no errors on reading */
		{
			if (FIL_readonly_set)
				attributs |= FA_READONLY;
			else /* unset */
				attributs &= ~FA_READONLY;

			error = Fattrib(fname_tmp, FA_SET, attributs); 
		}
		
		if (error < 0)	/* if errors on setting */
		{
			form_error(-31-error);
			return error;
		}
	}
	else /* */
	{
		
	}
	return 0;
}

/********************************************
	locals functions definitions
*********************************************/

