/*
 * $Header: /home/orchestra5/davy/stuff/misc/xsat/RCS/xsat.c,v 1.1 92/04/10 14:08:16 davy Exp $
 *
 * Copyright 1992 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * Main part of the xsat program.  Widget creation, etc.  All global variables
 * are declared in this file.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * 1285 Electrical Engineering Building
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log:	xsat.c,v $
 * Revision 1.1  92/04/10  14:08:16  davy
 * Initial revision
 *
 * Revision 1.2  94/05/24  11:22:33  trf
 * 
 */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <signal.h>
#include <stdio.h>

#include "Canvas.h"
#include "xsat.h"
#include "patchlevel.h"

static MenuItem commandsMenuItems[] = {
	{ "Set start time",		commandsSetStartTime		},
	{ "Set stop time",		commandsSetStopTime		},
	{ "Set step time",		commandsSetStepTime		},
	{ "Set elevation",		commandsSetMinElev		},
	{ "Time labels",		commandsSetTimeLabels		},
	{ "Predict",			commandsPredict			},
	{ "Print",			commandsPrint			},
	{ "Save",			commandsSave			},
	{ "Quit",			commandsQuit			},
	{ NULL,				NULL				}
};

static MenuItem citiesMenuItems[] = {
	{ "Show current city",		citiesShowCity			},
	{ "Select a city",		citiesSelectCity		},
	{ "List cities",		citiesListCities		},
	{ NULL,				NULL				}
};

static MenuItem satellitesMenuItems[] = {
	{ "Show current satellite",	satellitesShowSatellite		},
	{ "Select a satellite",		satellitesSelectSatellite	},
	{ "Add a satellite",		satellitesAddSatellite		},
	{ "List satellites",		satellitesListSatellites	},
	{ NULL,				NULL				}
};

static MenuItem mapsMenuItems[] = {
	{ "World",			mapsSelectMap			},
	{ "Antarctica",			mapsSelectMap			},
	{ "Asia",			mapsSelectMap			},
	{ "Australia",			mapsSelectMap			},
	{ "Europe",			mapsSelectMap			},
	{ "Greenland",			mapsSelectMap			},
	{ "North America",		mapsSelectMap			},
	{ "Pacific",			mapsSelectMap			},
	{ "South America",		mapsSelectMap			},
	{ "United States",		mapsSelectMap			},
	{ NULL,				NULL				}
};

static XrmOptionDescRec optionList[] = {
	{ "-city",	".cityName",	XrmoptionSepArg,	NULL	},
	{ "-elev",	".minElev",	XrmoptionSepArg,	NULL	},
	{ "-map",	".mapName",	XrmoptionSepArg,	NULL	},
	{ "-sat",	".satName",	XrmoptionSepArg,	NULL	},
	{ "-start",	".startTime",	XrmoptionSepArg,	NULL	},
	{ "-step",	".stepTime",	XrmoptionSepArg,	NULL	},
	{ "-stop",	".stopTime",	XrmoptionSepArg,	NULL	},
	{ "-time",	".timeLabels",	XrmoptionSepArg,	NULL	},
	{ "-utc",	".utc",		XrmoptionNoArg,		"true"	},
};

static String fallbackResources[] = {
    "*Dialog*value*font: -b&h-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "*Dialog*command.font: -adobe-helvetica-bold-r-normal--12-*-*-*-*-*-*-*",
    "*Label.font: -b&h-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "*Dialog*label.font: -adobe-helvetica-bold-r-normal--12-*-*-*-*-*-*-*",
    "*Text*font: -b&h-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "*SimpleMenu*font: -adobe-helvetica-medium-r-normal--12-*-*-*-*-*-*-*",
    "*MenuButton.font: -adobe-helvetica-bold-r-normal--12-*-*-*-*-*-*-*",
    "*Canvas*font: -adobe-helvetica-medium-r-normal--8-*-*-*-*-*-*-*",
    "*Dialog*command.shapeStyle: oval",
    "*MenuButton.shapeStyle: oval",
    "*Dialog*command.label: okay",
    NULL
};

static float default_margin = DEFAULT_MARGIN;

static XtResource resources[] = {

#define offset(field)	XtOffset(AppResPtr,field)

/* these are also command-line options */
	{ "cityName",	"Names",	XtRString,	sizeof(String),
		offset(cityName),	XtRImmediate,
		(XtPointer) NULL },
	{ "mapName",	"Names",	XtRString,	sizeof(String),
		offset(mapName),	XtRImmediate,
		(XtPointer) NULL },
	{ "minElev",	"MinElev",	XtRInt,		sizeof(int),
		offset(minElev),	XtRImmediate,
		(XtPointer) DEFAULT_ELEV },
	{ "printCmd",	"PrintCmd",	XtRString,	sizeof(String),
		offset(printCmd),	XtRImmediate,
		(XtPointer) DEFAULT_PRINT },
	{ "satName",	"SatName",	XtRString,	sizeof(String),
		offset(satName),	XtRImmediate,
		(XtPointer) NULL },
	{ "saveFile",	"Files",	XtRString,	sizeof(String),
		offset(saveFile),	XtRImmediate,
		(XtPointer) DEFAULT_FILE },
	{ "startTime",	"Times",	XtRString,	sizeof(String),
		offset(startTime),	XtRImmediate,
		(XtPointer) DEFAULT_STARTTIME },
	{ "stepTime",	"Times",	XtRInt,		sizeof(int),
		offset(stepTime),	XtRImmediate,
		(XtPointer) DEFAULT_STEPTIME },
	{ "stopTime",	"Times",	XtRString,	sizeof(String),
		offset(stopTime),	XtRImmediate,
		(XtPointer) DEFAULT_STOPTIME },
	{ "timeLabel",	"Times",	XtRInt,		sizeof(int),
		offset(timeLabelFreq),	XtRImmediate,
		(XtPointer) DEFAULT_TIMELABEL },
	{ "utc",	"Utc",		XtRBoolean,	sizeof(Boolean),
		offset(utc),		XtRImmediate,
		(XtPointer) False },

/* these are NOT command-line options */
	{ "mapLeftMargin",	"Margin",	XtRFloat,	sizeof(float),
		offset(mapLeftMargin),	XtRFloat,
		(XtPointer) &default_margin },
	{ "mapRightMargin",	"Margin",	XtRFloat,	sizeof(float),
		offset(mapRightMargin),	XtRFloat,
		(XtPointer) &default_margin },
	{ "mapTopMargin",	"Margin",	XtRFloat,	sizeof(float),
		offset(mapTopMargin),	XtRFloat,
		(XtPointer) &default_margin },
	{ "mapBottomMargin",	"Margin",	XtRFloat,	sizeof(float),
		offset(mapBottomMargin),	XtRFloat,
		(XtPointer) &default_margin }

#undef offset
};

AppRes		appResources;		/* XSAT application resources	*/

/* add an action to handle <return> in a Dialog's Text widget, and another
 * to clean up after cut-and-paste actions */
extern XtActionProc text_return(
#if NeedFunctionPrototypes
Widget,XExposeEvent *,String *,Cardinal *
#endif
);
extern XtActionProc text_cut_and_paste(
#if NeedFunctionPrototypes
Widget,XExposeEvent *,String *,Cardinal *
#endif
);

XtActionsRec text_actions[] = {
  {"text_return",(XtActionProc)text_return},
  {"text_cut_and_paste",(XtActionProc)text_cut_and_paste},
};

/*
 * Main widgets.
 */
Widget		formWidget;
Widget		mapCanvas;
Widget		orbitText;
Widget		topLevel;
Widget		topLabel;
Widget		botLabel;

char		startTimeStr[64];	/* start time, as a string	*/
char		stopTimeStr[64];	/* stop time, as a string	*/
char		saveFile[1024];		/* save file name		*/
char		printCmd[256];		/* print command		*/

time_t		startTime;		/* start time in UNIX format	*/
time_t		stopTime;		/* stop time in UNIX format	*/

int		timeLabelFreq;		/* time label frequency		*/
int		minElevation;		/* minimum satel. elevation	*/
int		stepTime;		/* simulation step time		*/

FILE		*psFP;			/* print/save file pointer	*/
FILE		*tmpFP;			/* text widget file pointer	*/
char		tmpFile[] = "/tmp/xsatXXXXXX"; /* text widget file name	*/

CityInfo	*currentCity;		/* currently selected city	*/
SatInfo		*currentSat;		/* currently selected satel.	*/
MapInfo		*currentMap;		/* currently selected map	*/

static void	usage();

main(argc, argv)
char **argv;
int argc;
{
	int i;
	char *str;
	MenuItem *m;
	char vers[128];
	Cardinal nargs;
	Widget w, menu;
	Arg argList[16];
	XtAppContext appContext;
	Widget commandsMenu, citiesMenu, satellitesMenu, mapsMenu;

	/*
	 * Load in information files.
	 */
	readSatList();
	readCityList();

	/*
	 * Create the top level widget.
	 */
	topLevel = XtAppInitialize(&appContext, "XSat", optionList,
				   XtNumber(optionList), &argc, argv,
				   fallbackResources, NULL, ZERO);

	if (argc != 1)
		usage(*argv, appContext);

	/*
	 * Get application resources.
	 */
	XtGetApplicationResources(topLevel, &appResources, resources,
				  XtNumber(resources), (ArgList)argv, argc);

	/*
	 * Signal handling.
	 */
	signal(SIGQUIT, commandsQuit);
	signal(SIGINT, commandsQuit);

	/*
	 * Set initial values of several variables.
	 */
	setInitialValues();

	/*
	 * Get the top label string.
	 */
	str = topLabelStr(startTime, stopTime, stepTime, minElevation);

	/* register the text actions */
	XtAppAddActions(appContext, text_actions, XtNumber(text_actions));

	/*
	 * Create all the widgets.
	 */
	formWidget = XtCreateManagedWidget("form", formWidgetClass, topLevel,
					   NULL, ZERO);

	nargs = 0;
	XtSetArg(argList[nargs], XtNfromVert, NULL); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	commandsMenu = XtCreateManagedWidget("Commands", menuButtonWidgetClass,
					     formWidget, argList, nargs);

	menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
				  commandsMenu, NULL, ZERO);

	for (i=0, m=commandsMenuItems; m->m_string != NULL; i++, m++) {
		w = XtCreateManagedWidget(m->m_string, smeBSBObjectClass,
					  menu, NULL, ZERO);
		XtAddCallback(w, XtNcallback, m->m_callback, (XtPointer)i);
	}

	nargs = 0;
	XtSetArg(argList[nargs], XtNfromVert, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, commandsMenu); nargs++;
	citiesMenu = XtCreateManagedWidget("Cities", menuButtonWidgetClass,
					   formWidget, argList, nargs);

	menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
				  citiesMenu, NULL, ZERO);

	for (i=0, m=citiesMenuItems; m->m_string != NULL; i++, m++) {
		w = XtCreateManagedWidget(m->m_string, smeBSBObjectClass,
					  menu, NULL, ZERO);
		XtAddCallback(w, XtNcallback, m->m_callback, (XtPointer)i);
	}

	nargs = 0;
	XtSetArg(argList[nargs], XtNfromVert, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, citiesMenu); nargs++;
	satellitesMenu = XtCreateManagedWidget("Satellites",
					       menuButtonWidgetClass,
					       formWidget, argList, nargs);

	menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
				  satellitesMenu, NULL, ZERO);

	for (i=0, m=satellitesMenuItems; m->m_string != NULL; i++, m++) {
		w = XtCreateManagedWidget(m->m_string, smeBSBObjectClass,
					  menu, NULL, ZERO);
		XtAddCallback(w, XtNcallback, m->m_callback, (XtPointer)i);
	}

	nargs = 0;
	XtSetArg(argList[nargs], XtNfromVert, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, satellitesMenu); nargs++;
	mapsMenu = XtCreateManagedWidget("Maps", menuButtonWidgetClass,
					 formWidget, argList, nargs);

	menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
				  mapsMenu, NULL, ZERO);

	for (i=0, m=mapsMenuItems; m->m_string != NULL; i++, m++) {
		w = XtCreateManagedWidget(m->m_string, smeBSBObjectClass,
					  menu, NULL, ZERO);
		XtAddCallback(w, XtNcallback, m->m_callback, (XtPointer)i);
	}

	nargs = 0;
	XtSetArg(argList[nargs], XtNlabel, str); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNwidth, MAPWIN_WIDTH); nargs++;
	XtSetArg(argList[nargs], XtNfromVert, commandsMenu); nargs++;
	topLabel = XtCreateManagedWidget("topLabel", labelWidgetClass,
					 formWidget, argList, nargs);

	nargs = 0;
	XtSetArg(argList[nargs], XtNfromHoriz, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromVert, topLabel); nargs++;
	XtSetArg(argList[nargs], XtNwidth, MAPWIN_WIDTH); nargs++;
	XtSetArg(argList[nargs], XtNheight, MAPWIN_HEIGHT); nargs++;
	mapCanvas = XtCreateManagedWidget("canvas", canvasWidgetClass,
					  formWidget, argList, nargs);

	nargs = 0;
	XtSetArg(argList[nargs], XtNlabel, ""); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromVert, mapCanvas); nargs++;
	XtSetArg(argList[nargs], XtNwidth, MAPWIN_WIDTH); nargs++;
	botLabel = XtCreateManagedWidget("botLabel", labelWidgetClass,
					 formWidget, argList, nargs);

	nargs = 0;
	XtSetArg(argList[nargs], XtNfromHoriz, NULL); nargs++;
	XtSetArg(argList[nargs], XtNstring, tmpFile); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromVert, botLabel); nargs++;
	XtSetArg(argList[nargs], XtNtype, XawAsciiFile); nargs++;
	XtSetArg(argList[nargs], XtNwidth, MAPWIN_WIDTH); nargs++;
	XtSetArg(argList[nargs], XtNeditType, XawtextRead); nargs++;
	XtSetArg(argList[nargs], XtNheight, MAPWIN_HEIGHT/2); nargs++;
	XtSetArg(argList[nargs], XtNscrollVertical, XawtextScrollAlways); nargs++;
	XtSetArg(argList[nargs], XtNdisplayCaret, False); nargs++;
	orbitText = XtCreateManagedWidget("orbitText", asciiTextWidgetClass,
					  formWidget, argList, nargs);

	sprintf(vers, "N9MSW XSAT Satellite Tracker Version %s Patchlevel %d",
		VERSION, PATCHLEVEL);

	nargs = 0;
	XtSetArg(argList[nargs], XtNlabel, vers); nargs++;
	XtSetArg(argList[nargs], XtNfromHoriz, NULL); nargs++;
	XtSetArg(argList[nargs], XtNtop, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNleft, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNright, XtChainLeft); nargs++;
	XtSetArg(argList[nargs], XtNbottom, XtChainTop); nargs++;
	XtSetArg(argList[nargs], XtNfromVert, orbitText); nargs++;
	XtSetArg(argList[nargs], XtNwidth, MAPWIN_WIDTH); nargs++;
	w = XtCreateManagedWidget("versLabel", labelWidgetClass,
				  formWidget, argList, nargs);

	XtRealizeWidget(topLevel);

	/*
	 * Draw a pre-selected map, if there is one.
	 */
	if (appResources.mapName != NULL)
		mapsSelectMap(NULL, appResources.mapName, NULL);

	XtAppMainLoop(appContext);
}

static void
usage(pname, appContext)
XtAppContext appContext;
char *pname;
{
	XtDestroyApplicationContext(appContext);

	fprintf(stderr, "Usage: %s [options]\n", pname);
	fprintf(stderr, "  Options:\n");
	fprintf(stderr, "       -city city      Reports for named city\n");
	fprintf(stderr, "       -elev minelev   Satellite minimum elevation\n");
	fprintf(stderr, "       -map map        Display named map\n");
	fprintf(stderr, "       -sat sat        Reports for named satellite\n");
	fprintf(stderr, "       -start time     Prediction start date/time\n");
	fprintf(stderr, "       -stop time      Prediction stop date/time\n");
	fprintf(stderr, "       -step secs      Prediction every step secs\n");
	fprintf(stderr, "       -utc            Display times in UTC\n");
	exit(1);
}
