/*
 * $Header: /home/orchestra5/davy/stuff/misc/xsat/RCS/Canvas.h,v 1.1 92/04/10 14:08:04 davy Exp $
 *
 * Copyright 1992 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * Public include file for the canvas widget.  Based on the include file for
 * the Template widget in the X11R5 distribution.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * 1285 Electrical Engineering Building
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log:	Canvas.h,v $
 * Revision 1.1  92/04/10  14:08:04  davy
 * Initial revision
 *
 * Revision 1.2  94/05/24  11:22:33  trf
 * 
 */
#ifndef _Canvas_h
#define _Canvas_h

/****************************************************************
 *
 * Canvas widget
 *
 ****************************************************************/

/*
 * Resources:
 *
 * Name		     Class		RepType		Default Value
 * ----		     -----		-------		-------------
 * background	     Background		Pixel		XtDefaultBackground
 * border	     BorderColor	Pixel		XtDefaultForeground
 * borderWidth	     BorderWidth	Dimension	1
 * destroyCallback   Callback		Pointer		NULL
 * height	     Height		Dimension	0
 * mappedWhenManaged MappedWhenManaged	Boolean		True
 * sensitive	     Sensitive		Boolean		True
 * width	     Width		Dimension	0
 * x		     Position		Position	0
 * y		     Position		Position	0
 */

/*
 * Canvas-specific resource names.
 */
#define XtNidleCursor		"idleCursor"
#define XtNbusyCursor		"busyCursor"

/*
 * Declare specific CanvasWidget class and instance datatypes.
 */
typedef struct _CanvasClassRec*		CanvasWidgetClass;
typedef struct _CanvasRec*		CanvasWidget;

/*
 * Declare the class constant.
 */
extern WidgetClass canvasWidgetClass;

#endif /* _Canvas_h */
