/* Integer math routines, partially adapted from the
   "Diffie-Hellman in 10 lines of C" program. */

#include <stdio.h>
typedef unsigned char u;
#define S 1024
#define SIZE 1024
int v,d,z;
int msb; /* Most significant byte */
int msw; /* Most significant word */
u m[1024];

a(u *x,u *y)
{
  d=0;for(v=S-1;v>=msb;v--)
  {
    d+=x[v]+y[v];x[v]=d;d=d>>8;
  }
}
s(u *x)
{
  for(v=msb;(v<S-1)&&(x[v]==m[v]);)v++;
  if(x[v]>=m[v])
  {
    d=0;for(v=S-1;v>=msb;v--)
    {
      d+=x[v]-m[v];x[v]=d;d=d>>8;
    }
  }
}
r(u *x)
{
  d=0;for(v=msb;v<S;)
  {
    d|=x[v];x[v++]=d>>1;d=(d&1)<<8;
  }
}
shift_left(u *x)
{
  d=0;for(v=S-1;v>=msb;v--)
  {
    d|=x[v]<<1;x[v]=d;d=d>>8;
  }
}
M(u *x,u *y)
{
  u X[1024],Y[1024];
  bcopy(x,X,S);bcopy(y,Y,S);bzero(x,S);
  for(z=S*8;z--;)
  {
    if(X[S-1]&1)
    {
      a(x,Y);s(x);
    }
    r(X);shift_left(Y);s(Y);
  }
}

h(char *x,u *y)
{
  int n;
  bzero(y,S);
  for(n=0;x[n]>0;n++)
  {
    for(z=4;z--;)shift_left(y);
    x[n]|=32;y[S-1]|=x[n]-48-(x[n]>96)*39;
  }
}
p(u *x){
  int n;
  for(n=0;!x[n];)n++;
  for(;n<S;n++)
    printf("%c%c",48+x[n]/16+(x[n]>159)*7,48+(x[n]&15)+7*((x[n]&15)>9));
    printf("\n");
}

fast_modmult(u *x,u *y) {
  unsigned long int M1[512],M2[512],PROD[512],MOD[512];
  int a,b;
  
  for(a=0;a<512;a++){
    M1[a]=(x[a*2]*256+x[a*2+1]);
    M2[a]=(y[a*2]*256+y[a*2+1]);
    MOD[a]=(m[a*2]*256+m[a*2+1]);
    PROD[a]=0;
  }
  for(msw=1;MOD[msw]==0;msw++){} msw--;
    
  for(a=msw;a<512;a++) {
    for(b=511;b>0;b--) {
      PROD[b]+=M1[a]*M2[b];
      PROD[b-1]+=PROD[b]>>16;
      PROD[b]&=0xFFFF;
    }
    fast_mod(PROD,MOD);
    if(a<511) {
      for(b=msw;b<511;b++) {
        PROD[b]=PROD[b+1];
      }
      PROD[511]=0;
      fast_mod(PROD,MOD);
    }
  }
  for(a=0;a<512;a++){
    x[a*2]=PROD[a]>>8;
    x[a*2+1]=PROD[a];
  }
}

fast_mod(unsigned long int *PROD,unsigned long int *MOD) {
  int MSR[512];
  int a,b,c;
  long int d;
  
  for (a=msw;a<511;a++) {
    MSR[a]=MOD[a+1]>>1|(MOD[a]&1)<<15;
  }
  MSR[511]=(MOD[511]&1)<<15;
  for(a=16;a--;) {
    for(b=msw;b<511&&(PROD[b]==MSR[b]);b++) {}
    if(PROD[b]>=MSR[b]) {
      d=0;for(c=511;c>=msw;c--) {
        d+=PROD[c]-MSR[c];PROD[c]=d&0xFFFF;d=d>>16;
      }
    }
    if(a) {
      for (b=511;b>msw;b--){
        MSR[b]=MSR[b]>>1|(MSR[b-1]&1)<<15;
      }
      MSR[msw]=MSR[msw]>>1;
    }
  }
}

modexp(u *gen,u *exp,u *mod,u *result){
  u g[1024],e[1024];
  int emsb;
  int n;

  msb=0;
  bcopy(mod,m,S);
  bcopy(exp,e,S);
  bcopy(gen,g,S);
  bzero(result,S);result[S-1]=1;
  for(msb=1;m[msb]==0;msb++){} msb--;
  for(emsb=1;e[emsb]==0;emsb++){} emsb--;
  for(n=S*8;n>=emsb*8;n--)
  {
/*
    if(e[S-1]&1)M(result,g);
    M(g,g);r(e);
*/
    if(e[S-1]&1)fast_modmult(result,g);
    fast_modmult(g,g);r(e);
  }
}

#ifdef TESTDH
main(int c,char **v){
  u g[1024],e[1024],b[1024];
  int emsb;
  int n;

  msb=0;
  h(v[1],g);h(v[2],e);h(v[3],m);
  bzero(b,S);b[S-1]=1;
  for(msb=1;m[msb]==0;msb++){} msb--;
  for(emsb=1;e[emsb]==0;emsb++){} emsb--;
  for(n=S*8;n>=emsb*8;n--)
  {
/*
    if(e[S-1]&1)M(b,g);
    M(g,g);r(e);
*/
    if(e[S-1]&1)fast_modmult(b,g);
    fast_modmult(g,g);r(e);
  }  
  p(b);
}
#endif
