/* client.c - Misc. client subroutines */

#include <stdio.h>
#include "random.h"

char* do_dh(int fd,char sk[1024]) {
  char buffer[2048],buffer2[2048];
  char gen[1024],mod[1024],pub[1024],sec[1024];
  char *ptr;
  FILE *remote;
  FILE *file;
  
  mod[1023]=0;
  if(file=fopen(".dhmg","r")) {
    fscanf(file,"%s",buffer);
    h(buffer,mod);
    fscanf(file,"%s",buffer);
    h(buffer,gen);
  }
  if(!mod[1023]) {
    printf("\nError: Can't get modulus/generator.  Check .dhmg file.\n");
    exit(1);
  }
  fclose(file);
  remote=fdopen(fd,"r+");
  randomize();
  fgets(buffer,2048,remote);
  randomize();
#ifdef DEBUG
  printf("%s",buffer);
  puts("dh3des");
#endif
  fputs("dh3des\n",remote);
  fgets(buffer,2048,remote);
  randomize();
#ifdef DEBUG
  printf("%s",buffer);
  printf("mod ");
  fprinthex(mod,stdout);
#endif
  fprintf(remote,"mod ");
  fprinthex(mod,remote);
  fgets(buffer,2048,remote);
  randomize();
#ifdef DEBUG
  printf("%s",buffer);
  printf("gen ");
  fprinthex(gen,stdout);
#endif
  fprintf(remote,"gen ");
  fprinthex(gen,remote);
  fgets(buffer,2048,remote);
  randomize();
#ifdef DEBUG
  printf("%s",buffer);
#endif      
  ptr=randomize();
  bzero(sec,1024);
  bcopy(ptr,sec+960,64);
#ifdef DEBUG
  printf("Secret exponent is ");
  p(sec);
#endif
  modexp(gen,sec,mod,pub);
  fprintf(remote,"exch ");fprinthex(pub,remote);
#ifdef DEBUG
  printf("exch ");fprinthex(pub,stdout);
#else
  putchar('.');fflush(stdout);
#endif
  fgets(buffer,2048,remote);  
#ifdef DEBUG
  printf("%s",buffer);
#else
  putchar('.');fflush(stdout);
#endif  
  sscanf(buffer,"%s %s",buffer2,buffer2);
  h(buffer2,pub);
  modexp(pub,sec,mod,sk); /* Generate session key */
#ifdef DEBUG
  printf("Session key is ");
  p(sk);
#endif
  randomize(); /* Destroy the evidence */
  bzero(sec,1024);
}

fprinthex(unsigned char *x,FILE *stream){
  int n;
  for(n=0;!x[n];)n++;
  for(;n<1024;n++)
    fprintf(stream,"%c%c",
    48+x[n]/16+(x[n]>159)*7,48+(x[n]&15)+7*((x[n]&15)>9));
  fprintf(stream,"\n");
}
  