/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/build_name.c,v $
 *
 *
 *  MODULE NAME:    build_name.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

 
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include <syslog.h>
#include "cdc.h"

extern char *index();
extern char *getenv();

int Sphinx_build_name(internet_name_flag, targetname, domainname, caname, service_name, princ_name)
int     internet_name_flag;
char    *targetname, *domainname, *caname, *service_name, *princ_name;
{
  char  *env, *cp;
#if defined(ibm032) || defined(sun)
  char  *getenv();
  char  *index();
#endif

  /*
   *  First get the domain part of the name
   */
  *targetname = 0;

  /*
   *  if service_name is "krbtgt", then princ_name is the realm name,
   *  so don't truncate it!
   */
  if (strcmp(service_name, "krbtgt") == 0) {
    strcpy(targetname, get_domain_name(princ_name));
    if (*targetname==0)  return(0);
    strcat(targetname, "/OU=Servers/CN=krbtgt");
    return(1);
  }

  if (domainname == NULL) {
    if (internet_name_flag) {
      if ((cp = index(princ_name, '.')) != 0)
        *cp = '\0';
      strcpy(targetname, get_domain_name(princ_name));
    } else strcpy(targetname, get_domain_name(NULL));
    if (*targetname==0)  return(0);
  } else strcpy(targetname, domainname);

  strcat(targetname, "/");
  if (caname == NULL) {
    if ((env = getenv("SPHINX_LOCAL_CA")) != NULL)
      strcat(targetname, env);
    else strcat(targetname, "OU=Servers");
  } else strcat(targetname, caname);

  strcat(targetname, "/CN=");
  if (internet_name_flag) {
    /*
     *  For backwards compatibility, we've hard coded the service
     *  "rcmd" to use the host's credentials.  All other services
     *  use their own credentials.
     */
    if (strcmp(service_name, "rcmd")) {
      strcat(targetname, service_name);
      strcat(targetname, ".");
    }
  }
  strcat(targetname, princ_name);
  return(1);
}
