/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.graphics.PointF;
import android.os.SystemClock;
import android.view.MotionEvent;

class Zoomer {
    private final Instrumentation _instrument;
    public static final int GESTURE_DURATION_MS = 1000;
    public static final int EVENT_TIME_INTERVAL_MS = 10;

    public Zoomer(Instrumentation inst) {
        this._instrument = inst;
    }

    public void generateZoomGesture(PointF startPoint1, PointF startPoint2, PointF endPoint1, PointF endPoint2) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float startX1 = startPoint1.x;
        float startY1 = startPoint1.y;
        float startX2 = startPoint2.x;
        float startY2 = startPoint2.y;
        float endX1 = endPoint1.x;
        float endY1 = endPoint1.y;
        float endX2 = endPoint2.x;
        float endY2 = endPoint2.y;
        float x1 = startX1;
        float y1 = startY1;
        float x2 = startX2;
        float y2 = startY2;
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[2];
        MotionEvent.PointerCoords pc1 = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords pc2 = new MotionEvent.PointerCoords();
        pc1.x = x1;
        pc1.y = y1;
        pc1.pressure = 1.0f;
        pc1.size = 1.0f;
        pc2.x = x2;
        pc2.y = y2;
        pc2.pressure = 1.0f;
        pc2.size = 1.0f;
        pointerCoords[0] = pc1;
        pointerCoords[1] = pc2;
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[2];
        MotionEvent.PointerProperties pp1 = new MotionEvent.PointerProperties();
        MotionEvent.PointerProperties pp2 = new MotionEvent.PointerProperties();
        pp1.id = 0;
        pp1.toolType = 1;
        pp2.id = 1;
        pp2.toolType = 1;
        pointerProperties[0] = pp1;
        pointerProperties[1] = pp2;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
        this._instrument.sendPointerSync(event);
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)(5 + (pp2.id << 8)), (int)2, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
        this._instrument.sendPointerSync(event);
        int numMoves = 100;
        float stepX1 = (endX1 - startX1) / (float)numMoves;
        float stepY1 = (endY1 - startY1) / (float)numMoves;
        float stepX2 = (endX2 - startX2) / (float)numMoves;
        float stepY2 = (endY2 - startY2) / (float)numMoves;
        for (int i = 0; i < numMoves; ++i) {
            pointerCoords[0].x += stepX1;
            pointerCoords[0].y += stepY1;
            pointerCoords[1].x += stepX2;
            pointerCoords[1].y += stepY2;
            event = MotionEvent.obtain((long)downTime, (long)(eventTime += 10L), (int)2, (int)2, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
            this._instrument.sendPointerSync(event);
        }
    }
}

