/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: COTInternetSocket.h,v 1.8 1999/03/10 02:35:18 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CInternetSocket.h"


class COTInternetSocket : public CInternetSocket {
public:
							COTInternetSocket();
	virtual 				~COTInternetSocket();

	virtual void			Bind(const PGPSocketAddressInternet *
									inAddress);
	virtual void			Close();
	
	virtual void			GetSocketName(PGPSocketAddressInternet * outName);

	virtual void			IOControlSocket(SInt32 inCommand,
								UInt32 * ioParam);

protected:
	EndpointRef				mEndpointRef;
	InetAddress				mBoundAddress;
	Boolean					mCanceled;
	
	virtual void			Cleanup();
	virtual void			DoBind(OTQLen inQLen);
	
	virtual Boolean			IsReadable();
	virtual Boolean			IsWriteable();
	virtual Boolean			IsError();

	virtual void			ThrowIfOTError(OSStatus inErr);
	
	static pascal void		NotifyProc(void* contextPtr, OTEventCode code, 
									   OTResult result, void* cookie);
};