/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: PGPsdkUILibInitAndTerm.cp,v 1.4 1999/03/10 02:55:57 heller Exp $
____________________________________________________________________________*/

#include "pgpConfig.h"

#include <CodeFragments.h>
#include <Gestalt.h>

#include "MacBasics.h"
#include "PGPsdkUILibUtils.h"
#include "pgpDebug.h"
#include "pgpMem.h"
#include "pgpUtilities.h"

PGP_BEGIN_C_DECLARATIONS

pascal OSErr 	INIT_PGPsdkUILib(CFragInitBlock *initBlock);
pascal void		TERM_PGPsdkUILib(void);

pascal OSErr 	__initialize(const CFragInitBlock *theInitBlock);
pascal OSErr 	__terminate(void);

PGP_END_C_DECLARATIONS

static PGPBoolean	sInitializedLibrary = FALSE;

	pascal OSErr
INIT_PGPsdkUILib(CFragInitBlock *initBlock)
{
	OSErr	err = noErr;
	
	err = __initialize( initBlock );
	if( IsntErr( err ) )
	{
		/*
		** Remember the FSSpec of the library file se we can open it's
		** resource fork later.
		*/
		
		if( IsntNull( initBlock ) )
		{
			err = SetLibraryFSSpec( initBlock->fragLocator.u.onDisk.fileSpec );
		}
		else
		{
			/* Actual error is not important here */
			
			pgpDebugMsg( "INIT_PGPsdkUILib: No initBlock" );
			err = -1;
		}
		
		if( IsntErr( err ) )
		{
			err = PGPErrorToMacError( PGPsdkUILibInit() );
			if( IsntErr( err ) )
			{
				sInitializedLibrary = TRUE;
			}
		}
	}
	
	pgpAssert( IsntErr( err ) );

	return( err );
}

	pascal void
TERM_PGPsdkUILib(void)
{
	if( sInitializedLibrary )
	{
		(void) PGPsdkUILibCleanup();
		sInitializedLibrary = FALSE;
	}
	
	__terminate();
}



/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
