/*
	File:		MacTCPCommonTypes.h

	Copyright:	(C) 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#error wrong file--see note in MacTCP.h


#ifndef __MACTCPCOMMONTYPES__
#define __MACTCPCOMMONTYPES__

#ifndef __TYPES__
#include <Types.h>
#endif

/* MacTCP return Codes in the range -23000 through -23049 */
#define inProgress				1			/* I/O in progress */

#define ipBadLapErr				-23000		/* bad network configuration */
#define ipBadCnfgErr			-23001		/* bad IP configuration error */
#define ipNoCnfgErr				-23002		/* missing IP or LAP configuration error */
#define ipLoadErr				-23003		/* error in MacTCP load */
#define ipBadAddr				-23004		/* error in getting address */
#define connectionClosing		-23005		/* connection is closing */
#define invalidLength			-23006
#define connectionExists		-23007		/* request conflicts with existing connection */
#define connectionDoesntExist	-23008		/* connection does not exist */
#define insufficientResources	-23009		/* insufficient resources to perform request */
#define invalidStreamPtr		-23010
#define streamAlreadyOpen		-23011
#define connectionTerminated	-23012
#define invalidBufPtr			-23013
#define invalidRDS				-23014
#define invalidWDS				-23014
#define openFailed				-23015
#define commandTimeout			-23016
#define duplicateSocket			-23017

/* Error codes from internal IP functions */
#define ipDontFragErr			-23032		/* Packet too large to send w/o fragmenting */
#define ipDestDeadErr			-23033		/* destination not responding */
#define icmpEchoTimeoutErr		-23035		/* ICMP echo timed-out */
#define ipNoFragMemErr			-23036		/* no memory to send fragmented pkt */
#define ipRouteErr				-23037		/* can't route packet off-net */

#define nameSyntaxErr			-23041
#define cacheFault				-23042
#define noResultProc			-23043
#define noNameServer			-23044
#define authNameErr				-23045
#define noAnsErr				-23046
#define dnrErr					-23047
#define outOfMemory				-23048

#define BYTES_16WORD			2			/* bytes per 16 bit ip word */
#define BYTES_32WORD			4			/* bytes per 32 bit ip word */
#define BYTES_64WORD			8			/* bytes per 64 bit ip word */

typedef unsigned char b_8;					/* 8-bit quantity */
typedef unsigned short b_16;				/* 16-bit quantity */
typedef unsigned long b_32;					/* 32-bit quantity */
typedef b_32 ip_addr;						/* IP address is 32-bits */

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct ip_addrbytes {
	union {
		b_32						addr;
		char						byte[4];
	} a;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct ip_addrbytes ip_addrbytes;

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct wdsEntry {
	unsigned short				length;
	char						*ptr;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct wdsEntry wdsEntry;

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct rdsEntry {
	unsigned short				length;
	char						*ptr;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct rdsEntry rdsEntry;

typedef unsigned long BufferPtr;

typedef unsigned long StreamPtr;

enum ICMPMsgType {
	netUnreach,
	hostUnreach,
	protocolUnreach,
	portUnreach,
	fragReqd,
	sourceRouteFailed,
	timeExceeded,
	parmProblem,
	missingOption,
	lastICMPMsgType				= 32767
};

typedef enum ICMPMsgType ICMPMsgType;

typedef b_16 ip_port;

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct ICMPReport {
	StreamPtr					streamPtr;
	ip_addr						localHost;
	ip_port						localPort;
	ip_addr						remoteHost;
	ip_port						remotePort;
	short						reportType;
	unsigned short				optionalAddlInfo;
	unsigned long				optionalAddlInfoPtr;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct ICMPReport ICMPReport;

typedef OSErr (*OSErrProcPtr)();

enum {
	uppOSErrProcInfo = kCStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
};

#if TARGET_RT_MAC_CFM
typedef UniversalProcPtr OSErrUPP;

#define CallOSErrProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)userRoutine, uppOSErrProcInfo)
#define NewOSErrProc(userRoutine)		\
		(OSErrUPP) NewRoutineDescriptor((ProcPtr)userRoutine, uppOSErrProcInfo, GetCurrentISA())
#else
typedef OSErrProcPtr OSErrUPP;

#define CallOSErrProc(userRoutine)		\
		(*userRoutine)()
#define NewOSErrProc(userRoutine)		\
		(OSErrUPP)(userRoutine)
#endif

typedef Ptr (*PtrProcPtr)();

enum {
	uppPtrProcInfo = kCStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(Ptr)))
};

#if TARGET_RT_MAC_CFM
typedef UniversalProcPtr PtrUPP;

#define CallPtrProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)userRoutine, uppPtrProcInfo)
#define NewPtrProc(userRoutine)		\
		(PtrUPP) NewRoutineDescriptor((ProcPtr)userRoutine, uppPtrProcInfo, GetCurrentISA())
#else
typedef PtrProcPtr PtrUPP;

#define CallPtrProc(userRoutine)		\
		(*userRoutine)()
#define NewPtrProc(userRoutine)		\
		(PtrUPP)(userRoutine)
#endif

typedef Boolean (*BooleanProcPtr)();

enum {
	uppBooleanProcInfo = kCStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
};

#if TARGET_RT_MAC_CFM
typedef UniversalProcPtr BooleanUPP;

#define CallBooleanProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)userRoutine, uppBooleanProcInfo)
#define NewBooleanProc(userRoutine)		\
		(BooleanUPP) NewRoutineDescriptor((ProcPtr)userRoutine, uppBooleanProcInfo, GetCurrentISA())
#else
typedef BooleanProcPtr BooleanUPP;

#define CallBooleanProc(userRoutine)		\
		(*userRoutine)()
#define NewBooleanProc(userRoutine)		\
		(BooleanUPP)(userRoutine)
#endif

typedef void (*voidProcPtr)();

#endif

