/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CXferView.h,v 1.4 1999/03/10 02:41:58 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LCicnButton.h>
#include <LPane.h>
#include <LPeriodical.h>

#include "CMacBinaryPipe.h"
#include "PGPFoneUtils.h"

class CXferView :	public LPane, public LPeriodical
{
public:
	enum { class_ID = 'xfvw' };
	static CXferView*	CreateXferViewStream(LStream *inStream);
	
							CXferView(LStream *inStream);
							~CXferView();
	void					DrawSelf();
	void					SpendTime(const EventRecord &inMacEvent);
	void					SetDirection(Boolean sending);
	void					StartXfer(XferInfo *xi);
	void					EndXfer(short moreXfers);
	void					SetAbortButton(LCicnButton *abortButton);
private:
	void					DoDraw(short full);
	Boolean					mSending;
	XferInfo				*mXI;
	ulong					mLastTotal;
	LCicnButton				*mAbortButton;
};

