/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CDiskTestsTable.cp,v 1.7 1999/03/10 02:24:30 heller Exp $
____________________________________________________________________________*/

#if PGP_DEBUG	// [

#include <PP_Messages.h>
#include <UTextTraits.h>

#include "MacFiles.h"
#include "pgpMacMemory.h"
#include "MacQuickdraw.h"
#include "MacStrings.h"

#include "CDiskTestsTable.h"
#include "CEditDiskTestDialog.h"

const ResIDT	kDiskTestsTableTextTraits	= 21000;

static RGBColor	sWhiteRGBColor = {0xFFFF, 0xFFFF, 0xFFFF};

CDiskTestsTable::CDiskTestsTable() : LColumnView(nil)
{
	pgpAssert( "CDiskTestsTable default constructor should never be called" );
}

CDiskTestsTable::CDiskTestsTable(LStream *inStream) : LColumnView(inStream)
{
	mTextHeight = 0;
}

CDiskTestsTable::~CDiskTestsTable()
{
}

	Boolean
CDiskTestsTable::FocusDraw(LPane *pane)
{
	Boolean	focused = LColumnView::FocusDraw( pane );
	
	UTextTraits::SetPortTextTraits ( kDiskTestsTableTextTraits );
	
	if( mTextHeight == 0 )
	{
		FontInfo	fontInfo;
		
		GetFontInfo( &fontInfo );
		
		mTextHeight = fontInfo.ascent + fontInfo.descent + fontInfo.leading;
	}
	
	RGBBackColor ( &sWhiteRGBColor );
	
	return focused;
}

	void
CDiskTestsTable::DrawSelf(void)
{
	RgnHandle	updateRgn;
	
	FocusDraw( this );
	
	updateRgn = GetLocalUpdateRgn();
	AssertHandleIsValid( updateRgn, "CDiskTestsTable::DrawSelf" );
	
	if( updateRgn != nil )
	{
		EraseRgn( updateRgn );
		DisposeRgn( updateRgn );
	}
	
	LColumnView::DrawSelf();
}

	Boolean
CDiskTestsTable::AddTest(void)
{
	DiskTestInfo	testInfo;
	OSErr			err	= noErr;
	
	pgpClearMemory( &testInfo, sizeof( testInfo ) );
	
	if( DoEditDiskTestDialog( &testInfo.config ) )
	{
		testInfo.testDriveObj = new( CTestDrive );
		if( testInfo.testDriveObj != nil )
		{
			err	= testInfo.testDriveObj->Run( &testInfo.config );
			if ( IsntErr( err ) )
			{
				InsertRows( 1, 20000, &testInfo, sizeof( testInfo ), TRUE );
			
				StartIdling();
				
				return( TRUE );
			}
			else
			{
				delete( testInfo.testDriveObj );
			}
		}		
	}
	
	return( FALSE );
}

	void
CDiskTestsTable::DeleteTest(TableIndexT rowIndex)
{
	DiskTestInfo	testInfo;
	UInt32			dataSize;
	STableCell		theCell;
	
	theCell.col = 1;
	theCell.row	= rowIndex;
	
	dataSize = sizeof( testInfo );
	GetCellData( theCell, &testInfo, dataSize );
	pgpAssert( dataSize == sizeof( testInfo ) );
	
	if( testInfo.testDriveObj != nil )
	{
		testInfo.testDriveObj->Stop();
		delete( testInfo.testDriveObj );
	}
	
	RemoveRows( 1, rowIndex, TRUE );
}

	void
CDiskTestsTable::DeleteSelectedTests(void)
{
	TableIndexT	numRows;
	TableIndexT	numColumns;
	STableCell	theCell( 0, 0 );
	
	while( GetNextSelectedCell( theCell ) )
	{
		DeleteTest( theCell.row );
		
		theCell.row = theCell.col = 0;
	}

	GetTableSize( numRows, numColumns );
	
	if( numRows == 0 )
		StopIdling();
}

	void
CDiskTestsTable::DeleteAllTests(void)
{
	TableIndexT	numRows;
	TableIndexT	numColumns;
	TableIndexT	rowIndex;
	
	GetTableSize( numRows, numColumns );
	StopIdling();
		
	for( rowIndex = numRows; rowIndex >= 1; rowIndex-- )
	{
		DeleteTest( rowIndex );
	}
}

	void
CDiskTestsTable::DrawCell(
	const STableCell	&inCell,
	const Rect			&inLocalRect)
{
	DiskTestInfo	testInfo;
	UInt32			dataSize;
	Rect			textRect;
	Str255			text;
	Str255			volName;
	
	dataSize = sizeof( testInfo );
	GetCellData( inCell, &testInfo, dataSize );
	pgpAssert( dataSize == sizeof( testInfo ) );
	
	(void) GetVolumeName( testInfo.config.vRefNum, volName );
	PrintPString( text, "\p%s (Volume: %s)", testInfo.config.testName );
	PrintPString( text, text, volName );
	
	textRect.left 	= inLocalRect.left + 5;
	textRect.right 	= textRect.left + StringWidth( text ) + 2;
	textRect.top	= inLocalRect.top;
	textRect.bottom	= textRect.top + mTextHeight;
	
	AlignRect( &inLocalRect, &textRect, kAlignAtVerticalCenter );
	
	TETextBox( &text[1], text[0], &textRect, teJustLeft );
}

	void
CDiskTestsTable::SpendTime(const EventRecord &inMacEvent)
{
	TableIndexT	numRows;
	TableIndexT	numColumns;
	TableIndexT	rowIndex;

	#pragma unused( inMacEvent )

	// Idle each of the active tests
	
	GetTableSize( numRows, numColumns );
		
	for( rowIndex = 1; rowIndex <= numRows; ++rowIndex )
	{
		DiskTestInfo	testInfo;
		UInt32			dataSize;
		STableCell		theCell;
		
		dataSize 	= sizeof( testInfo );
		theCell.row	= rowIndex;
		theCell.col	= 1;
		
		GetCellData( theCell, &testInfo, dataSize );
		pgpAssert( dataSize == sizeof( testInfo ) );
		
		if( testInfo.testDriveObj != nil )
		{
			testInfo.testDriveObj->Idle();
		}
	}
}

//	Broadcast message for a double-click on a cell

	void
CDiskTestsTable::ClickCell(
	const STableCell&		inCell,
	const SMouseDownEvent&	inMouseDown)
{
	#pragma unused( inCell, inMouseDown )

	if (GetClickCount() == 2)
	{
		if (mDoubleClickMsg != msg_Nothing)
		{
			BroadcastMessage(mDoubleClickMsg, (void*) this);
		}
	}
}

#endif	// ] PGP_DEBUG