/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPOptionView.cp,v 1.5 1999/04/04 11:13:49 wprice Exp $
____________________________________________________________________________*/

// Public includes:
#include <string.h>

#include <LTextEditView.h>
#include <UDrawingState.h>
#include <UReanimator.h>

#include "pgpMem.h"


// Private includes:
#include "CPGPOptionView.h"

CPGPOptionView::CPGPOptionView(LStream *inStream) :
					LView(inStream), LListener()
{
	mItemID 			= 0;
	mDescriptionPane	= NULL;
}

CPGPOptionView::~CPGPOptionView()
{
}

	void
CPGPOptionView::FinishCreateSelf(void)
{
	LView::FinishCreateSelf();
	
	mDescriptionPane = (LTextEditView *) FindPaneByID( kDescriptionPaneID );
	pgpAssertAddrValid( mDescriptionPane, VoidAlign );
}

	void
CPGPOptionView::SetDescription(
	const char *description)
{
	pgpAssertAddrValid( description, char );
	
	mDescriptionPane->SetTextPtr( (Ptr) description,
					strlen( description ) );

	ChangedDescription();
}

	void
CPGPOptionView::ChangedDescription(void)
{
	SInt16			newDescHeight;
	SDimension16	oldDescSize;
	Str255			description;
	
	mDescriptionPane->GetDescriptor( description );

	if( description[0] == 0 )
	{
		mDescriptionPane->Hide();
		
		newDescHeight = 0;
	}
	else
	{
		SDimension32	descImageSize;
		
		mDescriptionPane->Show();
					
		mDescriptionPane->GetImageSize( descImageSize );
		newDescHeight = descImageSize.height;
	}
	
	mDescriptionPane->GetFrameSize( oldDescSize );
	
	// Adjust the frame to account for the changed text
	ResizeFrameBy( 0, newDescHeight - oldDescSize.height, TRUE );
	ResizeImageBy( 0, newDescHeight - oldDescSize.height, TRUE );
}

	void
CPGPOptionView::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	(void) inMessage;
	(void) ioParam;
}

	CPGPOptionView *
CPGPOptionView::CreateOptionView(
	LView 	*inSuperView,
	ResIDT 	ppobResID)
{
	StColorPortState	mSavePort( UQDGlobals::GetCurrentPort() );
	CPGPOptionView		*optionView;
	
	SetDefaultView( inSuperView );
	
	optionView = (CPGPOptionView *) UReanimator::ReadObjects(
			'PPob', ppobResID );

	optionView->FinishCreate();
	
	OutOfFocus( NULL );
	
	return ( optionView );
}

