/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: PassphraseCache.h,v 1.15 1999/03/10 02:46:37 heller Exp $
____________________________________________________________________________*/

#pragma once 


#include <Timer.h>


#include "pgpPubTypes.h"
#include "pgpEncode.h"

class CPassphraseCache
{
	ulong	mEraseDelayMilliseconds;
	
	enum { kDefaultEraseDelaysSeconds	= 2 * 60 };	// 2 minutes;

	typedef struct
	{
		TMTask				tmTask;
		CPassphraseCache *	thisObject;
		TimerUPP			upp;
	#if PGP_DEBUG
		enum { kMagic	= 'ETSK' };
		OSType				magic;
	#endif
	} MyTMTask;
	
protected:
	char *		mPassbuffer;
	Boolean		mPassbufferValid;
	PGPSize		mDataLength;
	Boolean		mIsPassphrase;

	Boolean		mEraseTaskIsInstalled;
	MyTMTask	mEraseTask;
	
	void		RemoveEraseTask( void );
	void		InstallEraseTask( void );
	
	void		EraseTask( void );
	#if TARGET_RT_MAC_CFM
	static pascal void	sEraseTask( MyTMTask *task );
	#else
	static pascal void	sEraseTask( void );
	#endif
	
	void		RememberData(PGPBoolean isPassphrase,
						const PGPByte *data, PGPSize dataLength);
	
public:
			CPassphraseCache(PGPContextRef context);
	virtual	~CPassphraseCache( void );
	
	PGPBoolean	HaveData(void) { return( mPassbufferValid ); }
	void		RememberPassphrase( const char *	passphrase );
	void		RememberPasskey( const void *	passkey,
						PGPSize passkeyLength );
	void		Forget( void );
	Boolean		GetPassphraseOrPasskey( void *	buffer,
						PGPBoolean *  isPassphrase, PGPSize * passkeyLength );
	Boolean		GetPGPOptionList(PGPContextRef context, PGPOptionListRef *optionList);
	
	void		SetCacheSeconds( ulong numSeconds )
					{ mEraseDelayMilliseconds = numSeconds * 1000; }
};


class CSignPassphraseCache : public CPassphraseCache
{
private:
	typedef CPassphraseCache	inherited;
	
	PGPKeyID				mKeyID;
	PGPPublicKeyAlgorithm	mPublicKeyAlg;
	
public:
	CSignPassphraseCache(PGPContextRef context);
	
	/* key is no longer needed after remembering */
	void		RememberPassphrase( const char *passphrase, PGPKeyRef key );
	void		RememberPasskey( const void *	passkey,
						PGPSize passkeyLength, PGPKeyRef key );
	
	/* key set MUST be valid */
	Boolean		GetPassphraseOrPasskey( PGPKeySetRef allKeys,
					void *buffer, PGPBoolean * isPassphrase,
					PGPSize * passkeyLength, PGPKeyRef *key);
};


#ifdef __cplusplus
extern "C" {
#endif

 
extern CSignPassphraseCache *	gSigningPassphraseCache;
extern CSignPassphraseCache *	gDecryptionPassphraseCache;


void		InitPassphraseCaches( PGPContextRef context );
void		DisposePassphraseCaches( void );



#ifdef __cplusplus
}
#endif


