/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc. and it's affiliated companies
	All rights reserved.

	$Id: PGPsdaMacEncrypt.h,v 1.3 1999/04/04 11:12:32 wprice Exp $
____________________________________________________________________________*/

#pragma once

#include "pgpBase.h"

typedef enum PGPsdaEncryptState
{
	kPGPsdaEncryptState_Invalid	= 0,
	kPGPsdaEncryptState_Starting,
	kPGPsdaEncryptState_Analyzing,
	kPGPsdaEncryptState_DoneAnalyzing,
	kPGPsdaEncryptState_Encrypting,
	kPGPsdaEncryptState_DoneEncrypting

} PGPsdaEncryptState;

typedef struct PGPsdaEncryptProgressInfo
{
	PGPsdaEncryptState	state;
	const FSSpec		*curItem;
	PGPUInt32			bytesProcessed;
	PGPUInt32			totalBytesToProcess;

} PGPsdaEncryptProgressInfo;

PGP_BEGIN_C_DECLARATIONS

typedef OSStatus	(*PGPsdaEncryptProgressProc)(
							const PGPsdaEncryptProgressInfo *progressInfo,
							PGPUserValue userValue);

OSStatus	PGPsdaEncrypt(PGPContextRef context, PGPUInt32 numSourceItems,
					const FSSpec *sourceItems, const FSSpec *outFileSpec,
					const char *passphrase,
					PGPsdaEncryptProgressProc progressProc,
					PGPUserValue userValue);
					
PGP_END_C_DECLARATIONS

