/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CResultsTable.h,v 1.14 1999/03/10 02:39:38 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPHierarchyTable.h"
#include "PGPtools.h"
#include "PGPSharedEncryptDecrypt.h"

struct ResultsSingleItem;
struct ResultsSummaryItem;

class CResultsTable : public CPGPHierarchyTable
{
public:
	enum 				{ class_ID = 'ResT' };

						CResultsTable(LStream *inStream);
	virtual				~CResultsTable(void);
	
	virtual void		AdaptToSuperFrameSize(Int32 inSurrWidthDelta,
									Int32 inSurrHeightDelta,
									Boolean inRefresh);
	TableIndexT			AddSummaryRow(void);
	void				AddProcessedItemRow(ConstStr255Param itemName,
									PGPtoolsSignatureData *signatureData);
	virtual void		DrawSelf(void);
	void				IncrementVerifiedCount(void);
		
protected:

		
	virtual void		ClickSelf(const SMouseDownEvent	&inMouseDown);
	virtual void		DrawCell(const STableCell &inCell,
									const Rect &inLocalRect);
	virtual void		DrawDropFlag(const STableCell &inCell,
									TableIndexT inWideOpenRow);
	virtual void		FinishCreateSelf(void);
	
private:

	FontInfo			mSummaryItemFontInfo;
	FontInfo			mSingleItemFontInfo;
	PGPBoolean			mShowMarginalValidity;
	PGPBoolean			mMarginalIsInvalid;
	ControlHandle		mRightDropFlagControl;
	ControlHandle		mDownDropFlagControl;
	
	void				DrawSingleItemCell(const ResultsSingleItem *data,
									const Rect *cellRect, SInt16 bitDepth);
	void				DrawSummaryCell(const STableCell &inCell,
									const ResultsSummaryItem *data,
									const Rect *cellRect, SInt16 bitDepth);
	void				DrawValidity(PGPValidity validity,
									const Rect *columnRect);
};
